/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.connectivity;

import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.model.connectivity.Credentials;
import org.eclipse.ditto.model.connectivity.CredentialsVisitor;

@Immutable
public final class SshPublicKeyCredentials
implements Credentials {
    public static final String TYPE = "public-key";
    private final String username;
    private final String publicKey;
    private final String privateKey;

    private SshPublicKeyCredentials(String username, String publicKey, String privateKey) {
        this.username = username;
        this.publicKey = publicKey;
        this.privateKey = privateKey;
    }

    public static SshPublicKeyCredentials of(String username, String publicKey, String privateKey) {
        return new SshPublicKeyCredentials(username, publicKey, privateKey);
    }

    @Override
    public <T> T accept(CredentialsVisitor<T> visitor) {
        return visitor.sshPublicKeyAuthentication(this);
    }

    public String getUsername() {
        return this.username;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SshPublicKeyCredentials that = (SshPublicKeyCredentials)o;
        return this.username.equals(that.username) && this.publicKey.equals(that.publicKey) && this.privateKey.equals(that.privateKey);
    }

    public int hashCode() {
        return Objects.hash(this.username, this.publicKey, this.privateKey);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [username=" + this.username + ", publicKey=" + this.publicKey + "]";
    }

    @Override
    public JsonObject toJson() {
        JsonObjectBuilder jsonObjectBuilder = JsonFactory.newObjectBuilder();
        jsonObjectBuilder.set(JsonFields.TYPE, (Object)TYPE);
        jsonObjectBuilder.set(JsonFields.USERNAME, (Object)this.username);
        jsonObjectBuilder.set(JsonFields.PUBLIC_KEY, (Object)this.publicKey);
        jsonObjectBuilder.set(JsonFields.PRIVATE_KEY, (Object)this.privateKey);
        return jsonObjectBuilder.build();
    }

    static SshPublicKeyCredentials fromJson(JsonObject jsonObject) {
        String username = (String)jsonObject.getValueOrThrow(JsonFields.USERNAME);
        String publicKey = (String)jsonObject.getValueOrThrow(JsonFields.PUBLIC_KEY);
        String privateKey = (String)jsonObject.getValueOrThrow(JsonFields.PRIVATE_KEY);
        return new SshPublicKeyCredentials(username, publicKey, privateKey);
    }

    public static final class JsonFields
    extends Credentials.JsonFields {
        public static final JsonFieldDefinition<String> USERNAME = JsonFieldDefinition.ofString((CharSequence)"username", (JsonFieldMarker[])new JsonFieldMarker[0]);
        public static final JsonFieldDefinition<String> PUBLIC_KEY = JsonFieldDefinition.ofString((CharSequence)"publicKey", (JsonFieldMarker[])new JsonFieldMarker[0]);
        public static final JsonFieldDefinition<String> PRIVATE_KEY = JsonFieldDefinition.ofString((CharSequence)"privateKey", (JsonFieldMarker[])new JsonFieldMarker[0]);
    }
}

