/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.connectivity;

import java.time.Instant;
import java.util.Arrays;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonFieldSelector;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.json.FieldType;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.base.json.Jsonifiable;
import org.eclipse.ditto.model.connectivity.ConnectivityStatus;

public interface ResourceStatus
extends Jsonifiable.WithFieldSelectorAndPredicate<JsonField> {
    public ResourceType getResourceType();

    public String getClient();

    public Optional<String> getAddress();

    public ConnectivityStatus getStatus();

    public Optional<String> getStatusDetails();

    public Optional<Instant> getInStateSince();

    default public JsonObject toJson() {
        return (JsonObject)this.toJson(FieldType.notHidden());
    }

    default public JsonObject toJson(JsonSchemaVersion schemaVersion, JsonFieldSelector fieldSelector) {
        return ((JsonObject)this.toJson(schemaVersion, FieldType.notHidden())).get(fieldSelector);
    }

    @Immutable
    public static final class JsonFields {
        public static final JsonFieldDefinition<Integer> SCHEMA_VERSION = JsonFactory.newIntFieldDefinition((CharSequence)JsonSchemaVersion.getJsonKey(), (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.SPECIAL, FieldType.HIDDEN, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<String> TYPE = JsonFactory.newStringFieldDefinition((CharSequence)"type", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<String> STATUS = JsonFactory.newStringFieldDefinition((CharSequence)"status", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<String> CLIENT = JsonFactory.newStringFieldDefinition((CharSequence)"client", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<String> ADDRESS = JsonFactory.newStringFieldDefinition((CharSequence)"address", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<String> STATUS_DETAILS = JsonFactory.newStringFieldDefinition((CharSequence)"statusDetails", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<String> IN_STATE_SINCE = JsonFactory.newStringFieldDefinition((CharSequence)"inStateSince", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});

        private JsonFields() {
            throw new AssertionError();
        }
    }

    public static enum ResourceType implements CharSequence
    {
        SOURCE("source"),
        TARGET("target"),
        CLIENT("client"),
        SSH_TUNNEL("ssh"),
        UNKNOWN("unknown");

        private final String name;

        private ResourceType(String name) {
            this.name = (String)ConditionChecker.checkNotNull((Object)name);
        }

        public static Optional<ResourceType> forName(CharSequence name) {
            ConditionChecker.checkNotNull((Object)name, (String)"Name");
            return Arrays.stream(ResourceType.values()).filter(c -> c.name.contentEquals(name)).findFirst();
        }

        public String getName() {
            return this.name;
        }

        @Override
        public int length() {
            return this.name.length();
        }

        @Override
        public char charAt(int index) {
            return this.name.charAt(index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return this.name.subSequence(start, end);
        }

        @Override
        public String toString() {
            return this.name;
        }
    }
}

