/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.connectivity;

import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonArray;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonFieldSelector;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.common.ResponseType;
import org.eclipse.ditto.model.base.json.FieldType;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.base.json.Jsonifiable;
import org.eclipse.ditto.model.connectivity.GenericTarget;
import org.eclipse.ditto.model.connectivity.HeaderMapping;
import org.eclipse.ditto.model.connectivity.ImmutableReplyTarget;

public interface ReplyTarget
extends Jsonifiable.WithFieldSelectorAndPredicate<JsonField>,
GenericTarget {
    @Override
    public String getAddress();

    @Override
    public Optional<HeaderMapping> getHeaderMapping();

    public Set<ResponseType> getExpectedResponseTypes();

    public Builder toBuilder();

    default public JsonObject toJson() {
        return (JsonObject)this.toJson(FieldType.notHidden());
    }

    default public JsonObject toJson(JsonSchemaVersion schemaVersion, JsonFieldSelector fieldSelector) {
        return ((JsonObject)this.toJson(schemaVersion, FieldType.notHidden())).get(fieldSelector);
    }

    public static ReplyTarget fromJson(JsonObject jsonObject) {
        return ImmutableReplyTarget.fromJson(jsonObject);
    }

    public static Builder newBuilder() {
        return new ImmutableReplyTarget.Builder();
    }

    @Immutable
    public static final class JsonFields {
        public static final JsonFieldDefinition<String> ADDRESS = JsonFactory.newStringFieldDefinition((CharSequence)"address", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<JsonObject> HEADER_MAPPING = JsonFactory.newJsonObjectFieldDefinition((CharSequence)"headerMapping", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});
        public static final JsonFieldDefinition<JsonArray> EXPECTED_RESPONSE_TYPES = JsonFactory.newJsonArrayFieldDefinition((CharSequence)"expectedResponseTypes", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});

        JsonFields() {
            throw new AssertionError();
        }
    }

    public static interface Builder {
        public ReplyTarget build();

        public Builder address(String var1);

        public Builder headerMapping(@Nullable HeaderMapping var1);

        public Builder expectedResponseTypes(Collection<ResponseType> var1);

        public Builder expectedResponseTypes(ResponseType ... var1);
    }
}

