/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.connectivity;

import java.util.Arrays;
import java.util.Optional;
import org.eclipse.ditto.model.base.common.ConditionChecker;

public enum MetricDirection {
    INBOUND("inbound"),
    OUTBOUND("outbound");

    private final String name;

    private MetricDirection(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static Optional<MetricDirection> forName(CharSequence name) {
        ConditionChecker.checkNotNull((Object)name, (String)"Name");
        return Arrays.stream(MetricDirection.values()).filter(c -> c.name.contentEquals(name)).findFirst();
    }

    public String toString() {
        return this.name;
    }
}

