/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.connectivity;

import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonFieldSelector;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.json.FieldType;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.base.json.Jsonifiable;
import org.eclipse.ditto.model.connectivity.MetricType;

public interface Measurement
extends Jsonifiable.WithFieldSelectorAndPredicate<JsonField> {
    public MetricType getMetricType();

    public boolean isSuccess();

    public Map<Duration, Long> getCounts();

    public Optional<Instant> getLastMessageAt();

    default public JsonObject toJson() {
        return (JsonObject)this.toJson(FieldType.notHidden());
    }

    default public JsonObject toJson(JsonSchemaVersion schemaVersion, JsonFieldSelector fieldSelector) {
        return ((JsonObject)this.toJson(schemaVersion, FieldType.notHidden())).get(fieldSelector);
    }

    @Immutable
    public static final class JsonFields {
        public static final JsonFieldDefinition<String> LAST_MESSAGE_AT = JsonFactory.newStringFieldDefinition((CharSequence)"lastMessageAt", (JsonFieldMarker[])new JsonFieldMarker[]{FieldType.REGULAR, JsonSchemaVersion.V_1, JsonSchemaVersion.V_2});
    }
}

