/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.connectivity;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.connectivity.LogCategory;

@Immutable
public enum LogType {
    CONSUMED("consumed", LogCategory.SOURCE),
    DISPATCHED("dispatched", LogCategory.TARGET, LogCategory.RESPONSE),
    FILTERED("filtered", LogCategory.TARGET, LogCategory.RESPONSE),
    MAPPED("mapped", LogCategory.SOURCE, LogCategory.TARGET, LogCategory.RESPONSE),
    DROPPED("dropped", LogCategory.SOURCE, LogCategory.TARGET, LogCategory.RESPONSE),
    ENFORCED("enforced", LogCategory.SOURCE),
    PUBLISHED("published", LogCategory.TARGET, LogCategory.RESPONSE),
    ACKNOWLEDGED("acknowledged", LogCategory.SOURCE, LogCategory.TARGET, LogCategory.RESPONSE),
    OTHER("other", LogCategory.SOURCE, LogCategory.TARGET, LogCategory.RESPONSE, LogCategory.CONNECTION);

    private final String type;
    private final List<LogCategory> possibleCategories;

    private LogType(String theType, LogCategory ... possibleCateogries) {
        this.type = theType;
        this.possibleCategories = Arrays.asList(possibleCateogries);
    }

    public String getType() {
        return this.type;
    }

    public static Optional<LogType> forType(CharSequence type) {
        ConditionChecker.checkNotNull((Object)type, (String)"Type");
        return Arrays.stream(LogType.values()).filter(c -> c.type.contentEquals(type)).findFirst();
    }

    public boolean supportsCategory(LogCategory logCategory) {
        return this.possibleCategories.contains((Object)logCategory);
    }

    public String toString() {
        return this.type;
    }
}

