/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.connectivity;

import java.util.Arrays;
import java.util.Optional;
import org.eclipse.ditto.model.base.common.ConditionChecker;

public enum LogLevel {
    SUCCESS("success"),
    FAILURE("failure");

    private final String level;

    private LogLevel(String theLevel) {
        this.level = theLevel;
    }

    public String getLevel() {
        return this.level;
    }

    public static Optional<LogLevel> forLevel(CharSequence level) {
        ConditionChecker.checkNotNull((Object)level, (String)"Level");
        return Arrays.stream(LogLevel.values()).filter(c -> c.level.contentEquals(level)).findFirst();
    }

    public String toString() {
        return this.level;
    }
}

