/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.connectivity;

import java.util.Arrays;
import java.util.Optional;
import org.eclipse.ditto.model.base.common.ConditionChecker;

public enum LogCategory {
    SOURCE("source"),
    TARGET("target"),
    RESPONSE("response"),
    CONNECTION("connection");

    private final String name;

    private LogCategory(String theName) {
        this.name = theName;
    }

    public String getName() {
        return this.name;
    }

    public static Optional<LogCategory> forName(CharSequence name) {
        ConditionChecker.checkNotNull((Object)name, (String)"Name");
        return Arrays.stream(LogCategory.values()).filter(c -> c.name.contentEquals(name)).findFirst();
    }

    public String toString() {
        return this.name;
    }
}

