/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.connectivity;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonCollectors;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.connectivity.AddressMetric;
import org.eclipse.ditto.model.connectivity.ConnectivityModelFactory;
import org.eclipse.ditto.model.connectivity.ImmutableAddressMetric;
import org.eclipse.ditto.model.connectivity.TargetMetrics;

@Immutable
final class ImmutableTargetMetrics
implements TargetMetrics {
    private final Map<String, AddressMetric> addressMetrics;

    private ImmutableTargetMetrics(Map<String, AddressMetric> addressMetrics) {
        this.addressMetrics = Collections.unmodifiableMap(new HashMap<String, AddressMetric>(addressMetrics));
    }

    public static ImmutableTargetMetrics of(Map<String, AddressMetric> addressMetrics) {
        return new ImmutableTargetMetrics(addressMetrics);
    }

    @Override
    public Map<String, AddressMetric> getAddressMetrics() {
        return this.addressMetrics;
    }

    public JsonObject toJson(JsonSchemaVersion schemaVersion, Predicate<JsonField> thePredicate) {
        Predicate predicate = schemaVersion.and(thePredicate);
        JsonObjectBuilder jsonObjectBuilder = JsonFactory.newObjectBuilder();
        jsonObjectBuilder.set(TargetMetrics.JsonFields.SCHEMA_VERSION, (Object)schemaVersion.toInt(), predicate);
        jsonObjectBuilder.set(TargetMetrics.JsonFields.ADDRESS_METRICS, (Object)(this.addressMetrics.isEmpty() ? JsonFactory.nullObject() : this.addressMetricsToJson()), predicate);
        return jsonObjectBuilder.build();
    }

    private JsonObject addressMetricsToJson() {
        return (JsonObject)this.addressMetrics.entrySet().stream().map(e -> ImmutableAddressMetric.toJsonField((String)e.getKey(), (AddressMetric)e.getValue())).collect(JsonCollectors.fieldsToObject());
    }

    public static TargetMetrics fromJson(JsonObject jsonObject) {
        Map<String, AddressMetric> readAddressMetrics = jsonObject.getValue(TargetMetrics.JsonFields.ADDRESS_METRICS).map(obj -> obj.stream().collect(Collectors.toMap(f -> f.getKey().toString(), f -> ConnectivityModelFactory.addressMetricFromJson(f.getValue().asObject())))).orElse(Collections.emptyMap());
        return ImmutableTargetMetrics.of(readAddressMetrics);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImmutableTargetMetrics)) {
            return false;
        }
        ImmutableTargetMetrics that = (ImmutableTargetMetrics)o;
        return Objects.equals(this.addressMetrics, that.addressMetrics);
    }

    public int hashCode() {
        return Objects.hash(this.addressMetrics);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [addressMetrics=" + this.addressMetrics + "]";
    }
}

