/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.connectivity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.JsonArray;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.connectivity.Credentials;
import org.eclipse.ditto.model.connectivity.SshTunnel;
import org.eclipse.ditto.model.connectivity.SshTunnelBuilder;

@Immutable
final class ImmutableSshTunnel
implements SshTunnel {
    private final boolean enabled;
    private final Credentials credentials;
    private final boolean validateHost;
    private final List<String> knownHosts;
    private final String uri;

    private ImmutableSshTunnel(Builder builder) {
        this.enabled = (Boolean)ConditionChecker.checkNotNull((Object)builder.enabled, (String)"enabled");
        this.credentials = (Credentials)ConditionChecker.checkNotNull((Object)builder.credentials, (String)"credentials");
        this.validateHost = builder.validateHost;
        this.knownHosts = Collections.unmodifiableList(new ArrayList((Collection)ConditionChecker.checkNotNull((Object)builder.knownHosts, (String)"knownHosts")));
        this.uri = (String)ConditionChecker.checkNotNull((Object)builder.uri, (String)"uri");
    }

    private ImmutableSshTunnel(boolean enabled, Credentials credentials, boolean validateHost, List<String> knownHosts, String uri) {
        this.enabled = (Boolean)ConditionChecker.checkNotNull((Object)enabled, (String)"enabled");
        this.credentials = (Credentials)ConditionChecker.checkNotNull((Object)credentials, (String)"credentials");
        this.validateHost = validateHost;
        this.knownHosts = Collections.unmodifiableList(new ArrayList((Collection)ConditionChecker.checkNotNull(knownHosts, (String)"knownHosts")));
        this.uri = (String)ConditionChecker.checkNotNull((Object)uri, (String)"uri");
    }

    public static SshTunnelBuilder getBuilder(boolean enabled, Credentials credentials, boolean validateHost, List<String> knownHosts, String uri) {
        return new Builder(enabled, credentials, validateHost, knownHosts, uri);
    }

    public static SshTunnelBuilder getBuilder(boolean enabled, Credentials credentials, String uri) {
        return new Builder(enabled, credentials, uri);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public Credentials getCredentials() {
        return this.credentials;
    }

    @Override
    public boolean isValidateHost() {
        return this.validateHost;
    }

    @Override
    public List<String> getKnownHosts() {
        return this.knownHosts;
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    public static SshTunnel fromJson(JsonObject jsonObject) {
        ConditionChecker.checkNotNull((Object)jsonObject, (String)"jsonObject");
        return new Builder(ImmutableSshTunnel.extractEnabled(jsonObject), ImmutableSshTunnel.extractCredentials(jsonObject), ImmutableSshTunnel.extractValidateHost(jsonObject), ImmutableSshTunnel.extractKnownHosts(jsonObject), ImmutableSshTunnel.extractUri(jsonObject)).build();
    }

    private static boolean extractEnabled(JsonObject jsonObject) {
        return (Boolean)jsonObject.getValueOrThrow(SshTunnel.JsonFields.ENABLED);
    }

    private static Credentials extractCredentials(JsonObject jsonObject) {
        return Credentials.fromJson((JsonObject)jsonObject.getValueOrThrow(SshTunnel.JsonFields.CREDENTIALS));
    }

    private static List<String> extractKnownHosts(JsonObject jsonObject) {
        return jsonObject.getValue(SshTunnel.JsonFields.KNOWN_HOSTS).map(array -> array.stream().map(JsonValue::asString).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    private static boolean extractValidateHost(JsonObject jsonObject) {
        return (Boolean)jsonObject.getValueOrThrow(SshTunnel.JsonFields.VALIDATE_HOST);
    }

    private static String extractUri(JsonObject jsonObject) {
        return (String)jsonObject.getValueOrThrow(SshTunnel.JsonFields.URI);
    }

    public JsonObject toJson(JsonSchemaVersion schemaVersion, Predicate<JsonField> thePredicate) {
        Predicate predicate = schemaVersion.and(thePredicate);
        JsonObjectBuilder jsonObjectBuilder = JsonFactory.newObjectBuilder();
        jsonObjectBuilder.set(SshTunnel.JsonFields.SCHEMA_VERSION, (Object)schemaVersion.toInt(), predicate);
        jsonObjectBuilder.set(SshTunnel.JsonFields.ENABLED, (Object)this.enabled);
        jsonObjectBuilder.set(SshTunnel.JsonFields.CREDENTIALS, (Object)this.credentials.toJson());
        jsonObjectBuilder.set(SshTunnel.JsonFields.VALIDATE_HOST, (Object)this.validateHost);
        jsonObjectBuilder.set(SshTunnel.JsonFields.KNOWN_HOSTS, (Object)JsonArray.of(this.knownHosts));
        jsonObjectBuilder.set(SshTunnel.JsonFields.URI, (Object)this.uri);
        return jsonObjectBuilder.build();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableSshTunnel that = (ImmutableSshTunnel)o;
        return Objects.equals(this.enabled, that.enabled) && Objects.equals(this.credentials, that.credentials) && Objects.equals(this.validateHost, that.validateHost) && Objects.equals(this.knownHosts, that.knownHosts) && Objects.equals(this.uri, that.uri);
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.credentials, this.validateHost, this.knownHosts, this.uri);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [enabled=" + this.enabled + ", credentials=" + this.credentials + ", validateHost=" + this.validateHost + ", knownHosts=" + this.knownHosts + ", uri=" + this.uri + "]";
    }

    @NotThreadSafe
    static final class Builder
    implements SshTunnelBuilder {
        private boolean enabled;
        private Credentials credentials;
        private String uri;
        private boolean validateHost = false;
        private List<String> knownHosts = new ArrayList<String>();

        Builder(boolean enabled, Credentials credentials, String uri) {
            this.enabled = enabled;
            this.credentials = credentials;
            this.uri = uri;
        }

        Builder(boolean enabled, Credentials credentials, boolean validateHost, List<String> knownHosts, String uri) {
            this.enabled = enabled;
            this.credentials = credentials;
            this.uri = uri;
            this.validateHost = validateHost;
            this.knownHosts = knownHosts;
        }

        Builder(SshTunnel sshTunnel) {
            this.enabled = sshTunnel.isEnabled();
            this.credentials = sshTunnel.getCredentials();
            this.uri = sshTunnel.getUri();
            this.validateHost = sshTunnel.isValidateHost();
            this.knownHosts = sshTunnel.getKnownHosts();
        }

        @Override
        public SshTunnelBuilder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Override
        public SshTunnelBuilder credentials(Credentials credentials) {
            this.credentials = (Credentials)ConditionChecker.checkNotNull((Object)credentials, (String)"credentials");
            return this;
        }

        @Override
        public SshTunnelBuilder validateHost(boolean validateHost) {
            this.validateHost = validateHost;
            return this;
        }

        @Override
        public SshTunnelBuilder knownHosts(List<String> knownHosts) {
            this.knownHosts = (List)ConditionChecker.checkNotNull(knownHosts, (String)"knownHosts");
            return this;
        }

        @Override
        public SshTunnelBuilder uri(String uri) {
            this.uri = (String)ConditionChecker.checkNotNull((Object)uri, (String)"uri");
            return this;
        }

        @Override
        public SshTunnel build() {
            return new ImmutableSshTunnel(this);
        }
    }
}

