/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.connectivity;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.JsonArray;
import org.eclipse.ditto.json.JsonCollectors;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.model.base.acks.AcknowledgementLabel;
import org.eclipse.ditto.model.base.acks.FilteredAcknowledgementRequest;
import org.eclipse.ditto.model.base.auth.AuthorizationContext;
import org.eclipse.ditto.model.base.auth.AuthorizationContextType;
import org.eclipse.ditto.model.base.auth.AuthorizationModelFactory;
import org.eclipse.ditto.model.base.auth.AuthorizationSubject;
import org.eclipse.ditto.model.base.auth.DittoAuthorizationContextType;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.connectivity.ConnectionType;
import org.eclipse.ditto.model.connectivity.ConnectivityModelFactory;
import org.eclipse.ditto.model.connectivity.Enforcement;
import org.eclipse.ditto.model.connectivity.HeaderMapping;
import org.eclipse.ditto.model.connectivity.ImmutableEnforcement;
import org.eclipse.ditto.model.connectivity.ImmutableHeaderMapping;
import org.eclipse.ditto.model.connectivity.ImmutablePayloadMapping;
import org.eclipse.ditto.model.connectivity.ImmutableReplyTarget;
import org.eclipse.ditto.model.connectivity.PayloadMapping;
import org.eclipse.ditto.model.connectivity.ReplyTarget;
import org.eclipse.ditto.model.connectivity.Source;
import org.eclipse.ditto.model.connectivity.SourceBuilder;

@Immutable
final class ImmutableSource
implements Source {
    static final String DEFAULT_REPLY_TARGET_ADDRESS = "{{header:reply-to}}";
    static final String PLACEHOLDER_HEADER_CORRELATION_ID = "{{header:correlation-id}}";
    private static final String PLACEHOLDER_HEADER_CONTENT_TYPE = "{{header:content-type}}";
    static final HeaderMapping DEFAULT_SOURCE_HEADER_MAPPING = ConnectivityModelFactory.newHeaderMapping(JsonObject.newBuilder().set((CharSequence)"correlation-id", "{{header:correlation-id}}").set((CharSequence)"content-type", "{{header:content-type}}").set((CharSequence)"reply-to", "{{header:reply-to}}").build());
    static final HeaderMapping DEFAULT_REPLY_TARGET_HEADER_MAPPING = ConnectivityModelFactory.newHeaderMapping(JsonObject.newBuilder().set((CharSequence)"correlation-id", "{{header:correlation-id}}").set((CharSequence)"content-type", "{{header:content-type}}").build());
    private static final int DEFAULT_CONSUMER_COUNT = 1;
    private static final int DEFAULT_INDEX = 0;
    private static final boolean DEFAULT_REPLY_TARGET_ENABLED = true;
    private final Set<String> addresses;
    private final int consumerCount;
    @Nullable
    private final Integer qos;
    private final int index;
    private final AuthorizationContext authorizationContext;
    @Nullable
    private final Enforcement enforcement;
    @Nullable
    private final FilteredAcknowledgementRequest acknowledgementRequests;
    private final HeaderMapping headerMapping;
    private final PayloadMapping payloadMapping;
    private final boolean replyTargetEnabled;
    @Nullable
    private final ReplyTarget replyTarget;
    private final Set<AcknowledgementLabel> declaredAcknowledgementLabels;

    private ImmutableSource(Builder builder) {
        this.addresses = Collections.unmodifiableSet(new HashSet((Collection)ConditionChecker.checkNotNull((Object)builder.addresses, (String)"addresses")));
        this.consumerCount = builder.consumerCount;
        this.qos = builder.qos;
        this.authorizationContext = (AuthorizationContext)ConditionChecker.checkNotNull((Object)builder.authorizationContext, (String)"authorizationContext");
        this.index = builder.index;
        this.enforcement = builder.enforcement;
        this.acknowledgementRequests = builder.acknowledgementRequests;
        this.headerMapping = builder.headerMapping;
        this.payloadMapping = builder.payloadMapping;
        this.replyTargetEnabled = builder.replyTargetEnabled;
        this.replyTarget = builder.replyTarget;
        this.declaredAcknowledgementLabels = builder.declaredAcknowledgementLabels;
    }

    @Override
    public Set<String> getAddresses() {
        return this.addresses;
    }

    @Override
    public int getConsumerCount() {
        return this.consumerCount;
    }

    @Override
    public AuthorizationContext getAuthorizationContext() {
        return this.authorizationContext;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public Optional<Integer> getQos() {
        return Optional.ofNullable(this.qos);
    }

    @Override
    public Optional<Enforcement> getEnforcement() {
        return Optional.ofNullable(this.enforcement);
    }

    @Override
    public Optional<FilteredAcknowledgementRequest> getAcknowledgementRequests() {
        return Optional.ofNullable(this.acknowledgementRequests);
    }

    @Override
    public Optional<HeaderMapping> getHeaderMapping() {
        return Optional.of(this.headerMapping);
    }

    @Override
    public PayloadMapping getPayloadMapping() {
        return this.payloadMapping;
    }

    @Override
    public Optional<ReplyTarget> getReplyTarget() {
        return Optional.ofNullable(this.replyTarget);
    }

    @Override
    public boolean isReplyTargetEnabled() {
        return this.replyTargetEnabled;
    }

    @Override
    public Set<AcknowledgementLabel> getDeclaredAcknowledgementLabels() {
        return this.declaredAcknowledgementLabels;
    }

    public JsonObject toJson(JsonSchemaVersion schemaVersion, Predicate<JsonField> thePredicate) {
        Predicate predicate = schemaVersion.and(thePredicate);
        JsonObjectBuilder jsonObjectBuilder = JsonFactory.newObjectBuilder();
        jsonObjectBuilder.set(Source.JsonFields.SCHEMA_VERSION, (Object)schemaVersion.toInt(), predicate);
        jsonObjectBuilder.set(Source.JsonFields.ADDRESSES, (Object)((JsonArray)this.addresses.stream().map(JsonFactory::newValue).collect(JsonCollectors.valuesToArray())), predicate.and(Objects::nonNull));
        jsonObjectBuilder.set(Source.JsonFields.CONSUMER_COUNT, (Object)this.consumerCount, predicate);
        if (this.qos != null) {
            jsonObjectBuilder.set(Source.JsonFields.QOS, (Object)this.qos);
        }
        if (!this.authorizationContext.isEmpty()) {
            jsonObjectBuilder.set(Source.JsonFields.AUTHORIZATION_CONTEXT, (Object)((JsonArray)this.authorizationContext.stream().map(AuthorizationSubject::getId).map(JsonFactory::newValue).collect(JsonCollectors.valuesToArray())), predicate);
        }
        if (this.enforcement != null) {
            jsonObjectBuilder.set(Source.JsonFields.ENFORCEMENT, (Object)((JsonObject)this.enforcement.toJson(schemaVersion, thePredicate)), predicate);
        }
        if (this.acknowledgementRequests != null) {
            jsonObjectBuilder.set(Source.JsonFields.ACKNOWLEDGEMENT_REQUESTS, (Object)((JsonObject)this.acknowledgementRequests.toJson(schemaVersion, thePredicate)), predicate);
        }
        jsonObjectBuilder.set(Source.JsonFields.HEADER_MAPPING, (Object)((JsonObject)this.headerMapping.toJson(schemaVersion, thePredicate)), predicate);
        if (!this.payloadMapping.isEmpty()) {
            jsonObjectBuilder.set(Source.JsonFields.PAYLOAD_MAPPING, (Object)((JsonArray)this.payloadMapping.toJson()), predicate);
        }
        if (this.replyTarget != null) {
            jsonObjectBuilder.set(Source.JsonFields.REPLY_TARGET, (Object)((JsonObject)this.replyTarget.toJson(schemaVersion, thePredicate)), predicate);
        }
        if (!this.replyTargetEnabled || this.replyTarget != null) {
            jsonObjectBuilder.set(Source.JsonFields.REPLY_TARGET_ENABLED, (Object)this.replyTargetEnabled, predicate);
        }
        if (!this.declaredAcknowledgementLabels.isEmpty()) {
            jsonObjectBuilder.set(Source.JsonFields.DECLARED_ACKS, (Object)ImmutableSource.declaredAcksToJson(this.declaredAcknowledgementLabels));
        }
        return jsonObjectBuilder.build();
    }

    public static Source fromJson(JsonObject jsonObject, int index) {
        Set readSources = jsonObject.getValue(Source.JsonFields.ADDRESSES).map(array -> array.stream().map(JsonValue::asString).collect(Collectors.toSet())).orElse(Collections.emptySet());
        int readConsumerCount = jsonObject.getValue(Source.JsonFields.CONSUMER_COUNT).orElse(1);
        Integer readQos = jsonObject.getValue(Source.JsonFields.QOS).orElse(null);
        JsonArray authContext = jsonObject.getValue(Source.JsonFields.AUTHORIZATION_CONTEXT).orElseGet(() -> JsonArray.newBuilder().build());
        List authorizationSubjects = authContext.stream().filter(JsonValue::isString).map(JsonValue::asString).map(AuthorizationSubject::newInstance).collect(Collectors.toList());
        AuthorizationContext readAuthorizationContext = AuthorizationModelFactory.newAuthContext((AuthorizationContextType)DittoAuthorizationContextType.PRE_AUTHENTICATED_CONNECTION, authorizationSubjects);
        Enforcement readEnforcement = jsonObject.getValue(Source.JsonFields.ENFORCEMENT).map(ImmutableEnforcement::fromJson).orElse(null);
        FilteredAcknowledgementRequest readAcknowledgementRequests = jsonObject.getValue(Source.JsonFields.ACKNOWLEDGEMENT_REQUESTS).map(FilteredAcknowledgementRequest::fromJson).orElse(null);
        HeaderMapping readHeaderMapping = jsonObject.getValue(Source.JsonFields.HEADER_MAPPING).map(ImmutableHeaderMapping::fromJson).orElse(null);
        PayloadMapping readPayloadMapping = jsonObject.getValue(Source.JsonFields.PAYLOAD_MAPPING).map(ImmutablePayloadMapping::fromJson).orElse(ConnectivityModelFactory.emptyPayloadMapping());
        boolean replyTargetEnabled = jsonObject.getValue(Source.JsonFields.REPLY_TARGET_ENABLED).orElse(true);
        ReplyTarget readReplyTarget = jsonObject.getValue(Source.JsonFields.REPLY_TARGET).flatMap(ImmutableReplyTarget::fromJsonOptional).orElse(null);
        Set declaredAcknowledgementLabels = jsonObject.getValue(Source.JsonFields.DECLARED_ACKS).map(ImmutableSource::declaredAcksFromJson).orElse(Collections.emptySet());
        return ((Builder)((Builder)new Builder().addresses(readSources)).qos(readQos).authorizationContext(readAuthorizationContext).consumerCount(readConsumerCount).index(index).enforcement(readEnforcement).acknowledgementRequests(readAcknowledgementRequests).headerMapping(readHeaderMapping).payloadMapping(readPayloadMapping).replyTargetEnabled(replyTargetEnabled).replyTarget(readReplyTarget).declaredAcknowledgementLabels(declaredAcknowledgementLabels)).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableSource that = (ImmutableSource)o;
        return this.consumerCount == that.consumerCount && Objects.equals(this.addresses, that.addresses) && Objects.equals(this.index, that.index) && Objects.equals(this.qos, that.qos) && Objects.equals(this.enforcement, that.enforcement) && Objects.equals(this.acknowledgementRequests, that.acknowledgementRequests) && Objects.equals(this.headerMapping, that.headerMapping) && Objects.equals(this.payloadMapping, that.payloadMapping) && Objects.equals(this.authorizationContext, that.authorizationContext) && this.replyTargetEnabled == that.replyTargetEnabled && Objects.equals(this.replyTarget, that.replyTarget) && Objects.equals(this.declaredAcknowledgementLabels, that.declaredAcknowledgementLabels);
    }

    public int hashCode() {
        return Objects.hash(this.index, this.addresses, this.qos, this.consumerCount, this.authorizationContext, this.enforcement, this.acknowledgementRequests, this.headerMapping, this.payloadMapping, this.replyTargetEnabled, this.replyTarget, this.declaredAcknowledgementLabels);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [index=" + this.index + ", addresses=" + this.addresses + ", consumerCount=" + this.consumerCount + ", qos=" + this.qos + ", authorizationContext=" + this.authorizationContext + ", enforcement=" + this.enforcement + ", acknowledgementRequests=" + this.acknowledgementRequests + ", headerMapping=" + this.headerMapping + ", payloadMapping=" + this.payloadMapping + ", replyTargetEnabled=" + this.replyTargetEnabled + ", replyTarget=" + this.replyTarget + ", declaredAcknowledgementLabels=" + this.declaredAcknowledgementLabels + "]";
    }

    static Source migrateReplyTarget(Source source, ConnectionType connectionType) {
        boolean isLegacySource = source.isReplyTargetEnabled() && !source.getReplyTarget().isPresent();
        boolean supportsHeaders = ConnectionType.supportsHeaders(connectionType);
        if (isLegacySource && supportsHeaders) {
            return ImmutableSource.migrateReplyTargetWithHeaders(source);
        }
        if (isLegacySource) {
            return ImmutableSource.migrateReplyTargetWithoutHeaders(source);
        }
        return source;
    }

    private static Source migrateReplyTargetWithoutHeaders(Source source) {
        return ConnectivityModelFactory.newSourceBuilder(source).replyTarget(ReplyTarget.newBuilder().address(DEFAULT_REPLY_TARGET_ADDRESS).build()).build();
    }

    private static Source migrateReplyTargetWithHeaders(Source source) {
        HeaderMapping mapping = source.getHeaderMapping().map(sourceHeaderMapping -> {
            HashMap<String, String> mergedMapping = new HashMap<String, String>(DEFAULT_SOURCE_HEADER_MAPPING.getMapping());
            mergedMapping.putAll(sourceHeaderMapping.getMapping());
            return ConnectivityModelFactory.newHeaderMapping(mergedMapping);
        }).orElse(DEFAULT_SOURCE_HEADER_MAPPING);
        return ConnectivityModelFactory.newSourceBuilder(source).headerMapping(mapping).replyTarget(ReplyTarget.newBuilder().address(DEFAULT_REPLY_TARGET_ADDRESS).headerMapping(DEFAULT_REPLY_TARGET_HEADER_MAPPING).build()).build();
    }

    private static Set<AcknowledgementLabel> declaredAcksFromJson(JsonArray jsonArray) {
        return jsonArray.stream().map(JsonValue::formatAsString).map(AcknowledgementLabel::of).collect(Collectors.toSet());
    }

    private static JsonArray declaredAcksToJson(Set<AcknowledgementLabel> declaredAcks) {
        return (JsonArray)declaredAcks.stream().map(JsonValue::of).collect(JsonCollectors.valuesToArray());
    }

    @NotThreadSafe
    static final class Builder
    implements SourceBuilder<Builder> {
        @Nullable
        private Set<String> addresses = new HashSet<String>();
        @Nullable
        private AuthorizationContext authorizationContext;
        @Nullable
        private Enforcement enforcement;
        private HeaderMapping headerMapping = ConnectivityModelFactory.emptyHeaderMapping();
        @Nullable
        private Integer qos = null;
        @Nullable
        private FilteredAcknowledgementRequest acknowledgementRequests;
        private boolean replyTargetEnabled = true;
        @Nullable
        private ReplyTarget replyTarget;
        private Set<AcknowledgementLabel> declaredAcknowledgementLabels = Collections.emptySet();
        private PayloadMapping payloadMapping = ConnectivityModelFactory.emptyPayloadMapping();
        private int index = 0;
        private int consumerCount = 1;

        Builder() {
        }

        public Builder(Source source) {
            ((Builder)((Builder)this.addresses((Set)source.getAddresses())).authorizationContext(source.getAuthorizationContext()).enforcement(source.getEnforcement().orElse(null)).headerMapping(source.getHeaderMapping().orElse(null)).qos(source.getQos().orElse(null)).acknowledgementRequests(source.getAcknowledgementRequests().orElse(null)).replyTarget(source.getReplyTarget().orElse(null)).declaredAcknowledgementLabels((Set)source.getDeclaredAcknowledgementLabels())).payloadMapping(source.getPayloadMapping()).index(source.getIndex()).consumerCount(source.getConsumerCount());
        }

        @Override
        public Builder addresses(Set<String> addresses) {
            this.addresses = addresses;
            return this;
        }

        @Override
        public Builder address(String address) {
            if (this.addresses == null) {
                this.addresses = new HashSet<String>();
            }
            this.addresses.add(address);
            return this;
        }

        @Override
        public Builder consumerCount(int consumerCount) {
            this.consumerCount = consumerCount;
            return this;
        }

        @Override
        public Builder index(int index) {
            this.index = index;
            return this;
        }

        @Override
        public Builder qos(@Nullable Integer qos) {
            this.qos = qos;
            return this;
        }

        @Override
        public Builder authorizationContext(AuthorizationContext authorizationContext) {
            this.authorizationContext = (AuthorizationContext)ConditionChecker.checkNotNull((Object)authorizationContext, (String)"authorizationContext");
            return this;
        }

        @Override
        public Builder enforcement(@Nullable Enforcement enforcement) {
            this.enforcement = enforcement;
            return this;
        }

        @Override
        public Builder acknowledgementRequests(@Nullable FilteredAcknowledgementRequest acknowledgementRequests) {
            this.acknowledgementRequests = acknowledgementRequests;
            return this;
        }

        @Override
        public Builder headerMapping(@Nullable HeaderMapping headerMapping) {
            this.headerMapping = headerMapping == null ? ConnectivityModelFactory.emptyHeaderMapping() : headerMapping;
            return this;
        }

        @Override
        public Builder payloadMapping(PayloadMapping payloadMapping) {
            this.payloadMapping = payloadMapping;
            return this;
        }

        @Override
        public Builder replyTarget(@Nullable ReplyTarget replyTarget) {
            this.replyTarget = replyTarget;
            return this;
        }

        @Override
        public Builder replyTargetEnabled(boolean replyTargetEnabled) {
            this.replyTargetEnabled = replyTargetEnabled;
            return this;
        }

        @Override
        public Builder declaredAcknowledgementLabels(Set<AcknowledgementLabel> declaredAcknowledgmentLabels) {
            this.declaredAcknowledgementLabels = declaredAcknowledgmentLabels;
            return this;
        }

        @Override
        public Source build() {
            return new ImmutableSource(this);
        }
    }
}

