/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.connectivity;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.JsonArray;
import org.eclipse.ditto.json.JsonCollectors;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonMissingFieldException;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.common.ResponseType;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.connectivity.ConnectivityModelFactory;
import org.eclipse.ditto.model.connectivity.HeaderMapping;
import org.eclipse.ditto.model.connectivity.ReplyTarget;

@Immutable
final class ImmutableReplyTarget
implements ReplyTarget {
    private static final Set<ResponseType> DEFAULT_EXPECTED_RESPONSE_TYPES;
    private final String address;
    @Nullable
    private final HeaderMapping headerMapping;
    private final Set<ResponseType> expectedResponseTypes;

    private ImmutableReplyTarget(Builder builder) {
        this.address = (String)ConditionChecker.checkNotNull((Object)builder.address);
        this.headerMapping = builder.headerMapping;
        this.expectedResponseTypes = Collections.unmodifiableSet(new HashSet(builder.expectedResponseTypes));
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public Optional<HeaderMapping> getHeaderMapping() {
        return Optional.ofNullable(this.headerMapping);
    }

    @Override
    public Set<ResponseType> getExpectedResponseTypes() {
        return this.expectedResponseTypes;
    }

    @Override
    public ReplyTarget.Builder toBuilder() {
        return new Builder().address(this.address).headerMapping(this.headerMapping);
    }

    public JsonObject toJson(JsonSchemaVersion schemaVersion, Predicate<JsonField> predicate) {
        JsonObjectBuilder jsonObjectBuilder = JsonFactory.newObjectBuilder();
        jsonObjectBuilder.set(ReplyTarget.JsonFields.ADDRESS, (Object)this.address);
        if (this.headerMapping != null) {
            jsonObjectBuilder.set(ReplyTarget.JsonFields.HEADER_MAPPING, (Object)((JsonObject)this.headerMapping.toJson(schemaVersion, predicate)), predicate);
        }
        jsonObjectBuilder.set(ReplyTarget.JsonFields.EXPECTED_RESPONSE_TYPES, (Object)((JsonArray)this.expectedResponseTypes.stream().map(ResponseType::getName).map(JsonFactory::newValue).collect(JsonCollectors.valuesToArray())));
        return jsonObjectBuilder.build();
    }

    static ReplyTarget fromJson(JsonObject jsonObject) {
        return ImmutableReplyTarget.fromJsonOptional(jsonObject).orElseThrow(() -> new JsonMissingFieldException(ReplyTarget.JsonFields.ADDRESS));
    }

    static Optional<ReplyTarget> fromJsonOptional(JsonObject jsonObject) {
        return jsonObject.getValue(ReplyTarget.JsonFields.ADDRESS).map(address -> new Builder().address((String)address).headerMapping(jsonObject.getValue(ReplyTarget.JsonFields.HEADER_MAPPING).map(ConnectivityModelFactory::newHeaderMapping).orElse(null)).expectedResponseTypes((Collection<ResponseType>)jsonObject.getValue(ReplyTarget.JsonFields.EXPECTED_RESPONSE_TYPES).map(jsonArray -> jsonArray.stream().map(JsonValue::asString).map(ResponseType::fromName).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet())).orElse(DEFAULT_EXPECTED_RESPONSE_TYPES)).build());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableReplyTarget that = (ImmutableReplyTarget)o;
        return Objects.equals(this.address, that.address) && Objects.equals(this.headerMapping, that.headerMapping) && Objects.equals(this.expectedResponseTypes, that.expectedResponseTypes);
    }

    public int hashCode() {
        return Objects.hash(this.address, this.headerMapping, this.expectedResponseTypes);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [address=" + this.address + ", headerMapping=" + this.headerMapping + ", expectedResponseTypes=" + this.expectedResponseTypes + "]";
    }

    static /* synthetic */ Set access$300() {
        return DEFAULT_EXPECTED_RESPONSE_TYPES;
    }

    static {
        HashSet<ResponseType> defaultExpectedResponseTypes = new HashSet<ResponseType>();
        defaultExpectedResponseTypes.add(ResponseType.RESPONSE);
        defaultExpectedResponseTypes.add(ResponseType.ERROR);
        DEFAULT_EXPECTED_RESPONSE_TYPES = Collections.unmodifiableSet(new HashSet(defaultExpectedResponseTypes));
    }

    @NotThreadSafe
    static final class Builder
    implements ReplyTarget.Builder {
        @Nullable
        private String address;
        @Nullable
        private HeaderMapping headerMapping;
        private final Collection<ResponseType> expectedResponseTypes = new HashSet<ResponseType>(ImmutableReplyTarget.access$300());

        Builder() {
        }

        @Override
        public ReplyTarget build() {
            return new ImmutableReplyTarget(this);
        }

        @Override
        public ReplyTarget.Builder address(String address) {
            this.address = address;
            return this;
        }

        @Override
        public Builder headerMapping(@Nullable HeaderMapping headerMapping) {
            this.headerMapping = headerMapping;
            return this;
        }

        @Override
        public ReplyTarget.Builder expectedResponseTypes(Collection<ResponseType> expectedResponseTypes) {
            this.expectedResponseTypes.clear();
            this.expectedResponseTypes.addAll(expectedResponseTypes);
            return this;
        }

        @Override
        public ReplyTarget.Builder expectedResponseTypes(ResponseType ... expectedResponseTypes) {
            return this.expectedResponseTypes(Arrays.asList(expectedResponseTypes));
        }
    }
}

