/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.connectivity;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonCollectors;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.connectivity.ConnectivityModelFactory;
import org.eclipse.ditto.model.connectivity.MappingContext;
import org.eclipse.ditto.model.connectivity.PayloadMappingDefinition;

@Immutable
final class ImmutablePayloadMappingDefinition
implements PayloadMappingDefinition {
    private final Map<String, MappingContext> definitions;

    private ImmutablePayloadMappingDefinition(Map<String, MappingContext> definitions) {
        ConditionChecker.checkNotNull(definitions, (String)"definitions");
        this.definitions = Collections.unmodifiableMap(new HashMap<String, MappingContext>(definitions));
    }

    static PayloadMappingDefinition empty() {
        return new ImmutablePayloadMappingDefinition(Collections.emptyMap());
    }

    static PayloadMappingDefinition from(Map<String, MappingContext> definitions) {
        return new ImmutablePayloadMappingDefinition(definitions);
    }

    @Override
    public Map<String, MappingContext> getDefinitions() {
        return this.definitions;
    }

    @Override
    public PayloadMappingDefinition withDefinition(String id, MappingContext mappingContext) {
        HashMap<String, MappingContext> newDefinitions = new HashMap<String, MappingContext>(this.definitions);
        newDefinitions.put(id, mappingContext);
        return new ImmutablePayloadMappingDefinition(newDefinitions);
    }

    @Override
    public boolean isEmpty() {
        return this.definitions.isEmpty();
    }

    public static PayloadMappingDefinition fromJson(JsonObject jsonObject) {
        return ImmutablePayloadMappingDefinition.from(ConnectivityModelFactory.mappingsFromJson(jsonObject));
    }

    public JsonObject toJson(JsonSchemaVersion schemaVersion, Predicate<JsonField> predicate) {
        return (JsonObject)this.definitions.entrySet().stream().map(e -> JsonField.newInstance((CharSequence)((CharSequence)e.getKey()), (JsonValue)((MappingContext)e.getValue()).toJson(schemaVersion, predicate))).collect(JsonCollectors.fieldsToObject());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutablePayloadMappingDefinition that = (ImmutablePayloadMappingDefinition)o;
        return Objects.equals(this.definitions, that.definitions);
    }

    public int hashCode() {
        return Objects.hash(this.definitions);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [definitions=" + this.definitions + "]";
    }
}

