/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.connectivity;

import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonCollectors;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonKey;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonParseException;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.connectivity.Measurement;
import org.eclipse.ditto.model.connectivity.MetricType;

@Immutable
final class ImmutableMeasurement
implements Measurement {
    private static final String SUCCESS_FIELD_NAME = "success";
    private static final String FAILURE_FIELD_NAME = "failure";
    private final MetricType metricType;
    private final boolean success;
    private final Map<Duration, Long> values;
    @Nullable
    private final Instant lastMessageAt;

    ImmutableMeasurement(MetricType metricType, boolean success, Map<Duration, Long> values, @Nullable Instant lastMessageAt) {
        this.metricType = metricType;
        this.values = Collections.unmodifiableMap(new HashMap<Duration, Long>(values));
        this.success = success;
        this.lastMessageAt = lastMessageAt;
    }

    @Override
    public MetricType getMetricType() {
        return this.metricType;
    }

    @Override
    public boolean isSuccess() {
        return this.success;
    }

    @Override
    public Map<Duration, Long> getCounts() {
        return this.values;
    }

    @Override
    public Optional<Instant> getLastMessageAt() {
        return Optional.ofNullable(this.lastMessageAt);
    }

    public JsonObject toJson(JsonSchemaVersion schemaVersion, Predicate<JsonField> thePredicate) {
        JsonObject counts = (JsonObject)this.values.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).map(e -> JsonFactory.newField((JsonKey)JsonFactory.newKey((CharSequence)((Duration)e.getKey()).toString()), (JsonValue)JsonValue.of((Object)((Long)e.getValue())))).collect(JsonCollectors.fieldsToObject());
        return JsonFactory.newObjectBuilder().set((CharSequence)this.metricType.getName(), (JsonValue)JsonFactory.newObjectBuilder().set((CharSequence)ImmutableMeasurement.getSuccessFieldName(this.success), (JsonValue)JsonFactory.newObjectBuilder((Iterable)counts).set(Measurement.JsonFields.LAST_MESSAGE_AT, (Object)this.getLastMessageAt().map(Object::toString).orElse(null)).build()).build()).build();
    }

    private static String getSuccessFieldName(boolean success) {
        return success ? SUCCESS_FIELD_NAME : FAILURE_FIELD_NAME;
    }

    private static boolean fromSuccessFieldName(String success) {
        switch (success) {
            case "success": {
                return true;
            }
            case "failure": {
                return false;
            }
        }
        throw new JsonParseException("Unknown key " + success + ", expected '" + SUCCESS_FIELD_NAME + "' or '" + FAILURE_FIELD_NAME + ".");
    }

    public static Measurement fromJson(JsonObject jsonObject) {
        JsonField type = ImmutableMeasurement.unwrap((JsonValue)jsonObject);
        JsonField success = ImmutableMeasurement.unwrap(type.getValue());
        JsonObject counterJson = success.getValue().asObject();
        Map<Duration, Long> readCounterMap = counterJson.stream().filter(f -> f.getValue().isNumber()).collect(Collectors.toMap(f -> Duration.parse(f.getKeyName()), f -> f.getValue().asLong()));
        Instant readLastMessageAt = counterJson.getValue(Measurement.JsonFields.LAST_MESSAGE_AT).map(Instant::parse).orElse(null);
        return new ImmutableMeasurement(MetricType.forName(type.getKeyName()).orElseThrow(() -> (JsonParseException)JsonParseException.newBuilder().message("Unknown metricType: '" + type.getKeyName() + "'").build()), ImmutableMeasurement.fromSuccessFieldName(success.getKeyName()), readCounterMap, readLastMessageAt);
    }

    private static JsonField unwrap(JsonValue jsonValue) {
        if (jsonValue.isObject() && jsonValue.asObject().getSize() > 0) {
            JsonObject jsonObject = jsonValue.asObject();
            String inner = ((JsonKey)jsonObject.getKeys().get(0)).toString();
            return JsonField.newInstance((CharSequence)inner, (JsonValue)((JsonValue)jsonObject.getValue((CharSequence)inner).orElseThrow(() -> (JsonParseException)JsonParseException.newBuilder().message("No inner object found.").build())));
        }
        throw (JsonParseException)JsonParseException.newBuilder().message("No inner object found.").build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableMeasurement that = (ImmutableMeasurement)o;
        return this.success == that.success && Objects.equals(this.values, that.values) && Objects.equals(this.lastMessageAt, that.lastMessageAt) && Objects.equals((Object)this.metricType, (Object)that.metricType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.values, this.metricType, this.lastMessageAt, this.success});
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [values=" + this.values + ", lastMessageAt=" + this.lastMessageAt + ", counterType=" + (Object)((Object)this.metricType) + ", success=" + this.success + "]";
    }
}

