/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.connectivity;

import java.text.MessageFormat;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.json.JsonParseException;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.connectivity.LogCategory;
import org.eclipse.ditto.model.connectivity.LogEntry;
import org.eclipse.ditto.model.connectivity.LogEntryBuilder;
import org.eclipse.ditto.model.connectivity.LogLevel;
import org.eclipse.ditto.model.connectivity.LogType;
import org.eclipse.ditto.model.things.ThingId;

@Immutable
public final class ImmutableLogEntry
implements LogEntry {
    private final String correlationId;
    private final Instant timestamp;
    private final LogCategory logCategory;
    private final LogType logType;
    private final LogLevel logLevel;
    private final String message;
    @Nullable
    private final String address;
    @Nullable
    private final ThingId thingId;

    private ImmutableLogEntry(Builder builder) {
        this.correlationId = builder.correlationId;
        this.timestamp = builder.timestamp;
        this.logCategory = builder.logCategory;
        this.logType = builder.logType;
        this.logLevel = builder.logLevel;
        this.message = builder.message;
        this.address = builder.address;
        this.thingId = builder.thingId;
    }

    public static LogEntryBuilder getBuilder(String correlationId, Instant timestamp, LogCategory logCategory, LogType logType, LogLevel logLevel, String message) {
        return ImmutableLogEntry.getBuilder(correlationId, timestamp, logCategory, logType, logLevel, message, null, null);
    }

    public static LogEntryBuilder getBuilder(String correlationId, Instant timestamp, LogCategory logCategory, LogType logType, LogLevel logLevel, String message, @Nullable String address, @Nullable ThingId thingId) {
        return new Builder(correlationId, timestamp, logCategory, logType, logLevel, message).address(address).thingId(thingId);
    }

    public static LogEntry fromJson(JsonObject jsonObject) {
        String correlationId = (String)jsonObject.getValueOrThrow(LogEntry.JsonFields.CORRELATION_ID);
        Instant timestamp = ImmutableLogEntry.getTimestampOrThrow((CharSequence)jsonObject.getValueOrThrow(LogEntry.JsonFields.TIMESTAMP));
        LogCategory category = ImmutableLogEntry.getLogCategoryOrThrow(jsonObject);
        LogType type = ImmutableLogEntry.getLogTypeOrThrow(jsonObject);
        LogLevel level = ImmutableLogEntry.getLogLevelOrThrow(jsonObject);
        String message = (String)jsonObject.getValueOrThrow(LogEntry.JsonFields.MESSAGE);
        String address = jsonObject.getValue(LogEntry.JsonFields.ADDRESS).orElse(null);
        ThingId thingId = jsonObject.getValue(LogEntry.JsonFields.THING_ID).map(ThingId::of).orElse(null);
        return ImmutableLogEntry.getBuilder(correlationId, timestamp, category, type, level, message, address, thingId).build();
    }

    private static Instant getTimestampOrThrow(CharSequence dateTime) {
        try {
            return Instant.parse(dateTime);
        }
        catch (DateTimeParseException e) {
            String msgPattern = "The JSON object''s field <{0}> is not in ISO-8601 format as expected!";
            throw (JsonParseException)JsonParseException.newBuilder().message(MessageFormat.format("The JSON object''s field <{0}> is not in ISO-8601 format as expected!", LogEntry.JsonFields.TIMESTAMP.getPointer())).cause((Throwable)e).build();
        }
    }

    private static LogCategory getLogCategoryOrThrow(JsonObject jsonObject) {
        String readLogCategory = (String)jsonObject.getValueOrThrow(LogEntry.JsonFields.CATEGORY);
        return LogCategory.forName(readLogCategory).orElseThrow(() -> (JsonParseException)JsonParseException.newBuilder().message(MessageFormat.format("Log category <{0}> is invalid!", readLogCategory)).build());
    }

    private static LogType getLogTypeOrThrow(JsonObject jsonObject) {
        String readLogType = (String)jsonObject.getValueOrThrow(LogEntry.JsonFields.TYPE);
        return LogType.forType(readLogType).orElseThrow(() -> (JsonParseException)JsonParseException.newBuilder().message(MessageFormat.format("Log type <{0}> is invalid!", readLogType)).build());
    }

    private static LogLevel getLogLevelOrThrow(JsonObject jsonObject) {
        String readLogLevel = (String)jsonObject.getValueOrThrow(LogEntry.JsonFields.LEVEL);
        return LogLevel.forLevel(readLogLevel).orElseThrow(() -> (JsonParseException)JsonParseException.newBuilder().message(MessageFormat.format("Log level <{0}> is invalid!", readLogLevel)).build());
    }

    @Override
    public String getCorrelationId() {
        return this.correlationId;
    }

    @Override
    public Instant getTimestamp() {
        return this.timestamp;
    }

    @Override
    public LogCategory getLogCategory() {
        return this.logCategory;
    }

    @Override
    public LogType getLogType() {
        return this.logType;
    }

    @Override
    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public Optional<String> getAddress() {
        return Optional.ofNullable(this.address);
    }

    @Override
    public Optional<ThingId> getThingId() {
        return Optional.ofNullable(this.thingId);
    }

    public JsonObject toJson(JsonSchemaVersion schemaVersion, Predicate<JsonField> predicate) {
        JsonObjectBuilder builder = JsonFactory.newObjectBuilder().set(LogEntry.JsonFields.CORRELATION_ID, (Object)this.correlationId).set(LogEntry.JsonFields.TIMESTAMP, (Object)this.timestamp.toString()).set(LogEntry.JsonFields.CATEGORY, (Object)this.logCategory.getName()).set(LogEntry.JsonFields.TYPE, (Object)this.logType.getType()).set(LogEntry.JsonFields.LEVEL, (Object)this.logLevel.getLevel()).set(LogEntry.JsonFields.MESSAGE, (Object)this.message);
        if (null != this.address) {
            builder.set(LogEntry.JsonFields.ADDRESS, (Object)this.address);
        }
        if (null != this.thingId) {
            builder.set(LogEntry.JsonFields.THING_ID, (Object)this.thingId.toString());
        }
        return builder.build();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableLogEntry that = (ImmutableLogEntry)o;
        return Objects.equals(this.correlationId, that.correlationId) && Objects.equals(this.timestamp, that.timestamp) && this.logCategory == that.logCategory && this.logType == that.logType && this.logLevel == that.logLevel && Objects.equals(this.message, that.message) && Objects.equals(this.address, that.address) && Objects.equals(this.thingId, that.thingId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.correlationId, this.timestamp, this.logCategory, this.logType, this.logLevel, this.message, this.address, this.thingId});
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [correlationId=" + this.correlationId + ", timestamp=" + this.timestamp + ", logCategory=" + (Object)((Object)this.logCategory) + ", logType=" + (Object)((Object)this.logType) + ", logLevel=" + (Object)((Object)this.logLevel) + ", message=" + this.message + ", address=" + this.address + ", thingId=" + this.thingId + "]";
    }

    @NotThreadSafe
    private static final class Builder
    implements LogEntryBuilder {
        private String correlationId;
        private Instant timestamp;
        private LogCategory logCategory;
        private LogType logType;
        private LogLevel logLevel;
        private String message;
        @Nullable
        private String address;
        @Nullable
        private ThingId thingId;

        Builder(String correlationId, Instant timestamp, LogCategory logCategory, LogType logType, LogLevel logLevel, String message) {
            this.correlationId = (String)ConditionChecker.checkNotNull((Object)correlationId, (String)"correlation id");
            this.timestamp = (Instant)ConditionChecker.checkNotNull((Object)timestamp, (String)"timestamp");
            this.logCategory = (LogCategory)((Object)ConditionChecker.checkNotNull((Object)((Object)logCategory), (String)"log category"));
            this.logType = (LogType)((Object)ConditionChecker.checkNotNull((Object)((Object)logType), (String)"log type"));
            this.logLevel = (LogLevel)((Object)ConditionChecker.checkNotNull((Object)((Object)logLevel), (String)"log level"));
            this.message = (String)ConditionChecker.checkNotNull((Object)message, (String)"message");
        }

        @Override
        public LogEntryBuilder correlationId(String correlationId) {
            this.correlationId = (String)ConditionChecker.checkNotNull((Object)correlationId);
            return this;
        }

        @Override
        public LogEntryBuilder timestamp(Instant timestamp) {
            this.timestamp = (Instant)ConditionChecker.checkNotNull((Object)timestamp);
            return this;
        }

        @Override
        public LogEntryBuilder logCategory(LogCategory logCategory) {
            this.logCategory = (LogCategory)((Object)ConditionChecker.checkNotNull((Object)((Object)logCategory)));
            return this;
        }

        @Override
        public LogEntryBuilder logType(LogType logType) {
            this.logType = (LogType)((Object)ConditionChecker.checkNotNull((Object)((Object)logType)));
            return this;
        }

        @Override
        public LogEntryBuilder logLevel(LogLevel logLevel) {
            this.logLevel = (LogLevel)((Object)ConditionChecker.checkNotNull((Object)((Object)logLevel)));
            return this;
        }

        @Override
        public LogEntryBuilder message(String message) {
            this.message = (String)ConditionChecker.checkNotNull((Object)message);
            return this;
        }

        @Override
        public LogEntryBuilder address(@Nullable String address) {
            this.address = address;
            return this;
        }

        @Override
        public LogEntryBuilder thingId(@Nullable ThingId thingId) {
            this.thingId = thingId;
            return this;
        }

        @Override
        public LogEntry build() {
            return new ImmutableLogEntry(this);
        }
    }
}

