/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.connectivity;

import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.connectivity.AddressMetric;
import org.eclipse.ditto.model.connectivity.ConnectionMetrics;
import org.eclipse.ditto.model.connectivity.ConnectivityModelFactory;

@Immutable
final class ImmutableConnectionMetrics
implements ConnectionMetrics {
    private final AddressMetric inboundMetrics;
    private final AddressMetric outboundMetrics;

    private ImmutableConnectionMetrics(AddressMetric inboundMetrics, AddressMetric outboundMetrics) {
        this.inboundMetrics = inboundMetrics;
        this.outboundMetrics = outboundMetrics;
    }

    public static ImmutableConnectionMetrics of(AddressMetric inboundMetrics, AddressMetric outboundMetrics) {
        ConditionChecker.checkNotNull((Object)inboundMetrics, (String)"inboundMetrics");
        ConditionChecker.checkNotNull((Object)outboundMetrics, (String)"outboundMetrics");
        return new ImmutableConnectionMetrics(inboundMetrics, outboundMetrics);
    }

    public static ConnectionMetrics fromJson(JsonObject jsonObject) {
        return ImmutableConnectionMetrics.of(ConnectivityModelFactory.addressMetricFromJson((JsonObject)jsonObject.getValueOrThrow(ConnectionMetrics.JsonFields.INBOUND_METRICS)), ConnectivityModelFactory.addressMetricFromJson((JsonObject)jsonObject.getValueOrThrow(ConnectionMetrics.JsonFields.OUTBOUND_METRICS)));
    }

    @Override
    public AddressMetric getInboundMetrics() {
        return this.inboundMetrics;
    }

    @Override
    public AddressMetric getOutboundMetrics() {
        return this.outboundMetrics;
    }

    public JsonObject toJson(JsonSchemaVersion schemaVersion, Predicate<JsonField> thePredicate) {
        JsonObjectBuilder jsonObjectBuilder = JsonFactory.newObjectBuilder();
        jsonObjectBuilder.set(ConnectionMetrics.JsonFields.INBOUND_METRICS, (Object)((JsonObject)this.inboundMetrics.toJson(schemaVersion, thePredicate)));
        jsonObjectBuilder.set(ConnectionMetrics.JsonFields.OUTBOUND_METRICS, (Object)((JsonObject)this.outboundMetrics.toJson(schemaVersion, thePredicate)));
        return jsonObjectBuilder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImmutableConnectionMetrics)) {
            return false;
        }
        ImmutableConnectionMetrics that = (ImmutableConnectionMetrics)o;
        return Objects.equals(this.inboundMetrics, that.inboundMetrics) && Objects.equals(this.outboundMetrics, that.outboundMetrics);
    }

    public int hashCode() {
        return Objects.hash(this.inboundMetrics, this.outboundMetrics);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [inboundMetrics=" + this.inboundMetrics + ", outboundMetrics=" + this.outboundMetrics + "]";
    }
}

