/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.connectivity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonKey;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.json.JsonObjectBuilder;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.model.connectivity.AddressMetric;
import org.eclipse.ditto.model.connectivity.ImmutableMeasurement;
import org.eclipse.ditto.model.connectivity.Measurement;
import org.eclipse.ditto.model.connectivity.MetricType;

@Immutable
final class ImmutableAddressMetric
implements AddressMetric {
    private static final JsonKey SUCCESS_KEY = JsonFactory.newKey((CharSequence)"success");
    private static final JsonKey FAILURE_KEY = JsonFactory.newKey((CharSequence)"failure");
    private final Set<Measurement> measurements;

    private ImmutableAddressMetric(Set<Measurement> measurements) {
        this.measurements = Collections.unmodifiableSet(new HashSet<Measurement>(measurements));
    }

    public static ImmutableAddressMetric of(Set<Measurement> measurements) {
        return new ImmutableAddressMetric((Set)ConditionChecker.checkNotNull(measurements, (String)"measurements"));
    }

    @Override
    public Set<Measurement> getMeasurements() {
        return this.measurements;
    }

    public JsonObject toJson(JsonSchemaVersion schemaVersion, Predicate<JsonField> thePredicate) {
        if (this.measurements.isEmpty()) {
            return JsonFactory.nullObject();
        }
        Predicate predicate = schemaVersion.and(thePredicate);
        JsonObjectBuilder jsonObjectBuilder = JsonFactory.newObjectBuilder();
        jsonObjectBuilder.set(AddressMetric.JsonFields.SCHEMA_VERSION, (Object)schemaVersion.toInt(), predicate);
        ArrayList<Measurement> sortedMeasurements = new ArrayList<Measurement>(this.measurements);
        sortedMeasurements.sort(ImmutableAddressMetric.getMeasurementComparator());
        for (Measurement measurement : sortedMeasurements) {
            JsonPointer pointer = JsonFactory.newPointer((JsonKey)JsonFactory.newKey((CharSequence)measurement.getMetricType().getName()), (JsonKey[])new JsonKey[]{measurement.isSuccess() ? SUCCESS_KEY : FAILURE_KEY});
            jsonObjectBuilder.set((CharSequence)pointer, (JsonValue)measurement.toJson().getValue((CharSequence)pointer).orElse(JsonFactory.newObject()));
        }
        return jsonObjectBuilder.build();
    }

    private static Comparator<Measurement> getMeasurementComparator() {
        List<MetricType> sortedTypes = Arrays.asList(MetricType.values());
        Collections.sort(sortedTypes);
        return (m1, m2) -> {
            if (m1.equals(m2)) {
                return 0;
            }
            return ImmutableAddressMetric.calculateComparatorScore(sortedTypes, m1, m2);
        };
    }

    private static int calculateComparatorScore(List<MetricType> sortedTypes, Measurement m1, Measurement m2) {
        int idx1 = sortedTypes.indexOf((Object)m1.getMetricType());
        int idx2 = sortedTypes.indexOf((Object)m2.getMetricType());
        int score = m1.isSuccess() && m2.isSuccess() ? 1 : (m1.isSuccess() ? 2 : 3);
        if (idx1 < idx2) {
            return -score;
        }
        if (idx1 == idx2) {
            return m1.isSuccess() ? -1 : 1;
        }
        return score;
    }

    public static AddressMetric fromJson(JsonObject jsonObject) {
        HashSet<Measurement> readMeasurements = new HashSet<Measurement>();
        jsonObject.stream().filter(field -> field.getValue().isObject()).forEach(f -> Stream.of(SUCCESS_KEY, FAILURE_KEY).map(key -> JsonFactory.newPointer((JsonKey)JsonFactory.newKey((CharSequence)f.getKeyName()), (JsonKey[])new JsonKey[]{key})).map(arg_0 -> ((JsonObject)jsonObject).get(arg_0)).filter(JsonValue::isObject).filter(o -> !o.isEmpty()).map(JsonValue::asObject).map(ImmutableMeasurement::fromJson).forEach(readMeasurements::add));
        return ImmutableAddressMetric.of(readMeasurements);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImmutableAddressMetric)) {
            return false;
        }
        ImmutableAddressMetric that = (ImmutableAddressMetric)o;
        return Objects.equals(this.measurements, that.measurements);
    }

    public int hashCode() {
        return Objects.hash(this.measurements);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [measurements=" + this.measurements + "]";
    }

    static JsonField toJsonField(String key, AddressMetric metric) {
        String nonemptyKey = key.isEmpty() ? "<empty>" : key;
        return JsonFactory.newField((JsonKey)JsonKey.of((CharSequence)nonemptyKey), (JsonValue)metric.toJson());
    }
}

