/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.connectivity;

import java.util.Arrays;
import java.util.Optional;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonFieldDefinition;
import org.eclipse.ditto.json.JsonFieldMarker;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.json.Jsonifiable;

public enum ConnectivityStatus implements CharSequence,
Jsonifiable<JsonObject>
{
    OPEN("open"),
    CLOSED("closed"),
    FAILED("failed"),
    UNKNOWN("unknown");

    public static final JsonFieldDefinition<String> JSON_KEY_NAME;
    private final String name;

    private ConnectivityStatus(String name) {
        this.name = (String)ConditionChecker.checkNotNull((Object)name);
    }

    public static Optional<ConnectivityStatus> forName(CharSequence name) {
        ConditionChecker.checkNotNull((Object)name, (String)"Name");
        return Arrays.stream(ConnectivityStatus.values()).filter(c -> c.name.contentEquals(name)).findFirst();
    }

    public static ConnectivityStatus fromJson(JsonObject jsonObject) {
        String name = (String)((JsonObject)ConditionChecker.checkNotNull((Object)jsonObject, (String)"jsonObject")).getValueOrThrow(JSON_KEY_NAME);
        return ConnectivityStatus.valueOf(name);
    }

    public String getName() {
        return this.name;
    }

    public JsonObject toJson() {
        return JsonObject.newBuilder().set(JSON_KEY_NAME, (Object)this.name()).build();
    }

    @Override
    public int length() {
        return this.name.length();
    }

    @Override
    public char charAt(int index) {
        return this.name.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.name.subSequence(start, end);
    }

    @Override
    public String toString() {
        return this.name;
    }

    static {
        JSON_KEY_NAME = JsonFactory.newStringFieldDefinition((CharSequence)"name", (JsonFieldMarker[])new JsonFieldMarker[0]);
    }
}

