/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.connectivity;

import java.net.URI;
import java.text.MessageFormat;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.common.HttpStatus;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeException;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeExceptionBuilder;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.JsonParsableException;
import org.eclipse.ditto.model.connectivity.ConnectivityException;

@JsonParsableException(errorCode="connectivity:connection.uri.invalid")
@Immutable
public final class ConnectionUriInvalidException
extends DittoRuntimeException
implements ConnectivityException {
    public static final String ERROR_CODE = "connectivity:connection.uri.invalid";
    private static final String MESSAGE_TEMPLATE = "The Connection URI ''{0}'' has an invalid format.";
    private static final String DEFAULT_DESCRIPTION = "The accepted format is {protocol}://{username}:{password}@{hostname}:{port}/{path}";
    private static final long serialVersionUID = -3899791430534146626L;

    private ConnectionUriInvalidException(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
        super(ERROR_CODE, HttpStatus.BAD_REQUEST, dittoHeaders, message, description, cause, href);
    }

    public static Builder newBuilder(String uri) {
        return new Builder(uri);
    }

    public static ConnectionUriInvalidException fromMessage(@Nullable String message, DittoHeaders dittoHeaders) {
        return (ConnectionUriInvalidException)DittoRuntimeException.fromMessage((String)message, (DittoHeaders)dittoHeaders, (DittoRuntimeExceptionBuilder)new Builder());
    }

    public static ConnectionUriInvalidException fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return (ConnectionUriInvalidException)DittoRuntimeException.fromJson((JsonObject)jsonObject, (DittoHeaders)dittoHeaders, (DittoRuntimeExceptionBuilder)new Builder());
    }

    public DittoRuntimeException setDittoHeaders(DittoHeaders dittoHeaders) {
        return new Builder().message(this.getMessage()).description((String)this.getDescription().orElse(null)).cause(this.getCause()).href((URI)this.getHref().orElse(null)).dittoHeaders(dittoHeaders).build();
    }

    @NotThreadSafe
    public static final class Builder
    extends DittoRuntimeExceptionBuilder<ConnectionUriInvalidException> {
        private Builder() {
            this.description(ConnectionUriInvalidException.DEFAULT_DESCRIPTION);
        }

        private Builder(String uri) {
            this();
            this.message(MessageFormat.format(ConnectionUriInvalidException.MESSAGE_TEMPLATE, uri));
        }

        protected ConnectionUriInvalidException doBuild(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
            return new ConnectionUriInvalidException(dittoHeaders, message, description, cause, href);
        }
    }
}

