/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.connectivity;

import java.util.Arrays;
import java.util.Optional;
import org.eclipse.ditto.model.base.common.ConditionChecker;

public enum ConnectionType implements CharSequence
{
    AMQP_091("amqp-091"),
    AMQP_10("amqp-10"),
    MQTT("mqtt"),
    KAFKA("kafka"),
    HTTP_PUSH("http-push"),
    MQTT_5("mqtt-5");

    private final String name;

    private ConnectionType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static Optional<ConnectionType> forName(CharSequence name) {
        ConditionChecker.checkNotNull((Object)name, (String)"Name");
        return Arrays.stream(ConnectionType.values()).filter(c -> c.name.contentEquals(name)).findFirst();
    }

    @Override
    public int length() {
        return this.name.length();
    }

    @Override
    public char charAt(int index) {
        return this.name.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.name.subSequence(start, end);
    }

    @Override
    public String toString() {
        return this.name;
    }

    static boolean supportsHeaders(ConnectionType connectionType) {
        return connectionType != MQTT;
    }
}

