/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.connectivity;

import java.net.URI;
import java.text.MessageFormat;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.common.HttpStatus;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeException;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeExceptionBuilder;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.JsonParsableException;
import org.eclipse.ditto.model.connectivity.ConnectivityException;

@JsonParsableException(errorCode="connectivity:connection.id.invalid")
@Immutable
public final class ConnectionIdInvalidException
extends DittoRuntimeException
implements ConnectivityException {
    public static final String ERROR_CODE = "connectivity:connection.id.invalid";
    private static final String MESSAGE_TEMPLATE = "The Connection ID ''{0}'' is not valid.";
    private static final String DEFAULT_DESCRIPTION = String.format("It must be conform to the regular expression: <%s>.", "[a-zA-Z0-9-_]{1,80}");
    private static final long serialVersionUID = 8973217862319783106L;

    private ConnectionIdInvalidException(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
        super(ERROR_CODE, HttpStatus.BAD_REQUEST, dittoHeaders, message, description, cause, href);
    }

    public static Builder newBuilder(@Nullable CharSequence id) {
        return new Builder(id);
    }

    public static ConnectionIdInvalidException fromJson(JsonObject jsonObject, DittoHeaders dittoHeaders) {
        return (ConnectionIdInvalidException)DittoRuntimeException.fromJson((JsonObject)jsonObject, (DittoHeaders)dittoHeaders, (DittoRuntimeExceptionBuilder)new Builder());
    }

    public DittoRuntimeException setDittoHeaders(DittoHeaders dittoHeaders) {
        return new Builder().message(this.getMessage()).description((String)this.getDescription().orElse(null)).cause(this.getCause()).href((URI)this.getHref().orElse(null)).dittoHeaders(dittoHeaders).build();
    }

    @NotThreadSafe
    public static final class Builder
    extends DittoRuntimeExceptionBuilder<ConnectionIdInvalidException> {
        private Builder() {
            this.description(DEFAULT_DESCRIPTION);
        }

        private Builder(@Nullable CharSequence id) {
            this();
            this.message(MessageFormat.format(ConnectionIdInvalidException.MESSAGE_TEMPLATE, String.valueOf(id)));
        }

        protected ConnectionIdInvalidException doBuild(DittoHeaders dittoHeaders, @Nullable String message, @Nullable String description, @Nullable Throwable cause, @Nullable URI href) {
            return new ConnectionIdInvalidException(dittoHeaders, message, description, cause, href);
        }
    }
}

