/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.model.connectivity;

import java.util.Objects;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.entity.id.EntityId;
import org.eclipse.ditto.model.connectivity.ConnectionIdInvalidException;
import org.eclipse.ditto.model.connectivity.ConnectionIdPatternValidator;

@Immutable
public final class ConnectionId
implements EntityId {
    static final String ID_REGEX = "[a-zA-Z0-9-_]{1,80}";
    static final Pattern ID_PATTERN = Pattern.compile("[a-zA-Z0-9-_]{1,80}");
    private static final ConnectionId DUMMY_ID = ConnectionId.of("_");
    private final String stringRepresentation;

    private ConnectionId(String stringRepresentation, boolean shouldValidate) {
        this.stringRepresentation = shouldValidate ? this.validate(stringRepresentation) : stringRepresentation;
    }

    public static ConnectionId generateRandom() {
        return new ConnectionId(UUID.randomUUID().toString(), false);
    }

    public static ConnectionId of(CharSequence connectionId) {
        if (connectionId instanceof ConnectionId) {
            return (ConnectionId)((Object)connectionId);
        }
        return new ConnectionId(((CharSequence)ConditionChecker.checkNotNull((Object)connectionId, (String)"connectionId")).toString(), true);
    }

    public static ConnectionId dummy() {
        return DUMMY_ID;
    }

    public boolean isDummy() {
        return DUMMY_ID.equals(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectionId connectionId = (ConnectionId)o;
        return Objects.equals(this.stringRepresentation, connectionId.stringRepresentation);
    }

    public int hashCode() {
        return Objects.hash(this.stringRepresentation);
    }

    public String toString() {
        return this.stringRepresentation;
    }

    private String validate(@Nullable String entityId) {
        if (entityId == null || !ConnectionIdPatternValidator.getInstance(entityId).isValid()) {
            throw (ConnectionIdInvalidException)ConnectionIdInvalidException.newBuilder(entityId).build();
        }
        return entityId;
    }
}

