/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.maven.runner;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.tomcat.maven.runner.PasswordUtil;
import org.apache.tomcat.maven.runner.Tomcat8Runner;

public class Tomcat8RunnerCli {
    public static final String STAND_ALONE_PROPERTIES_FILENAME = "tomcat.standalone.properties";
    static Option httpPort;
    static Option httpsPort;
    static Option maxPostSize;
    static Option ajpPort;
    static Option serverXmlPath;
    static Option resetExtract;
    static Option help;
    static Option debug;
    static Option sysProps;
    static Option clientAuth;
    static Option keyAlias;
    static Option obfuscate;
    static Option httpProtocol;
    static Option extractDirectory;
    static Option loggerName;
    static Option uriEncoding;
    static Options options;

    public static void main(String[] args) throws Exception {
        Properties systemProperties;
        String port;
        GnuParser parser = new GnuParser();
        CommandLine line = null;
        try {
            line = parser.parse(options, args);
        }
        catch (ParseException e) {
            System.err.println("Parsing failed.  Reason: " + e.getMessage());
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(Tomcat8RunnerCli.getCmdLineSyntax(), options);
            System.exit(1);
        }
        if (line.hasOption(help.getOpt())) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(Tomcat8RunnerCli.getCmdLineSyntax(), options);
            System.exit(0);
        }
        if (line.hasOption(obfuscate.getOpt())) {
            System.out.println(PasswordUtil.obfuscate(line.getOptionValue(obfuscate.getOpt())));
            System.exit(0);
        }
        Tomcat8Runner tomcat8Runner = new Tomcat8Runner();
        tomcat8Runner.runtimeProperties = Tomcat8RunnerCli.buildStandaloneProperties();
        if (line.hasOption(serverXmlPath.getOpt())) {
            tomcat8Runner.serverXmlPath = line.getOptionValue(serverXmlPath.getOpt());
        }
        if ((port = tomcat8Runner.runtimeProperties.getProperty("httpPort")) != null) {
            tomcat8Runner.httpPort = Integer.parseInt(port);
        }
        if (line.hasOption(httpPort.getOpt())) {
            tomcat8Runner.httpPort = Integer.parseInt(line.getOptionValue(httpPort.getOpt()));
        }
        if (line.hasOption(maxPostSize.getOpt())) {
            tomcat8Runner.maxPostSize = Integer.parseInt(line.getOptionValue(maxPostSize.getOpt()));
        }
        if (line.hasOption(httpsPort.getOpt())) {
            tomcat8Runner.httpsPort = Integer.parseInt(line.getOptionValue(httpsPort.getOpt()));
        }
        if (line.hasOption(ajpPort.getOpt())) {
            tomcat8Runner.ajpPort = Integer.parseInt(line.getOptionValue(ajpPort.getOpt()));
        }
        if (line.hasOption(resetExtract.getOpt())) {
            tomcat8Runner.resetExtract = true;
        }
        if (line.hasOption(debug.getOpt())) {
            tomcat8Runner.debug = true;
        }
        if (line.hasOption(httpProtocol.getOpt())) {
            tomcat8Runner.httpProtocol = line.getOptionValue(httpProtocol.getOpt());
        }
        if (line.hasOption(sysProps.getOpt()) && (systemProperties = line.getOptionProperties(sysProps.getOpt())) != null && !systemProperties.isEmpty()) {
            for (Map.Entry<Object, Object> sysProp : systemProperties.entrySet()) {
                System.setProperty((String)sysProp.getKey(), (String)sysProp.getValue());
            }
        }
        if (line.hasOption(clientAuth.getOpt())) {
            tomcat8Runner.clientAuth = clientAuth.getOpt();
        }
        if (line.hasOption(keyAlias.getOpt())) {
            tomcat8Runner.keyAlias = line.getOptionValue(keyAlias.getOpt());
        }
        if (line.hasOption(extractDirectory.getOpt())) {
            tomcat8Runner.extractDirectory = line.getOptionValue(extractDirectory.getOpt());
        }
        if (line.hasOption(loggerName.getOpt())) {
            tomcat8Runner.loggerName = line.getOptionValue(loggerName.getOpt());
        }
        if (line.hasOption(uriEncoding.getOpt())) {
            tomcat8Runner.uriEncoding = line.getOptionValue(uriEncoding.getOpt());
        }
        tomcat8Runner.run();
    }

    private static Properties buildStandaloneProperties() throws IOException {
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(STAND_ALONE_PROPERTIES_FILENAME);
        Properties properties = new Properties();
        properties.load(is);
        return properties;
    }

    public static String getCmdLineSyntax() {
        return "java -jar [path to your exec war jar]";
    }

    static {
        OptionBuilder.withArgName("httpPort");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("http port to use");
        httpPort = OptionBuilder.create("httpPort");
        OptionBuilder.withArgName("httpsPort");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("https port to use");
        httpsPort = OptionBuilder.create("httpsPort");
        OptionBuilder.withArgName("maxPostSize");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("max post size to use");
        maxPostSize = OptionBuilder.create("maxPostSize");
        OptionBuilder.withArgName("ajpPort");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("ajp port to use");
        ajpPort = OptionBuilder.create("ajpPort");
        OptionBuilder.withArgName("serverXmlPath");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("server.xml to use, optional");
        serverXmlPath = OptionBuilder.create("serverXmlPath");
        OptionBuilder.withArgName("resetExtract");
        OptionBuilder.withDescription("clean previous extract directory");
        resetExtract = OptionBuilder.create("resetExtract");
        OptionBuilder.withLongOpt("help");
        OptionBuilder.withDescription("help");
        help = OptionBuilder.create('h');
        OptionBuilder.withLongOpt("debug");
        OptionBuilder.withDescription("debug");
        debug = OptionBuilder.create('X');
        OptionBuilder.withDescription("use value for given property");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription("key=value");
        OptionBuilder.withValueSeparator();
        sysProps = OptionBuilder.create('D');
        OptionBuilder.withArgName("clientAuth");
        OptionBuilder.withDescription("enable client authentication for https");
        clientAuth = OptionBuilder.create("clientAuth");
        OptionBuilder.withArgName("keyAlias");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription("alias from keystore for ssl");
        keyAlias = OptionBuilder.create("keyAlias");
        OptionBuilder.withArgName("password");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription("obfuscate the password and exit");
        obfuscate = OptionBuilder.create("obfuscate");
        OptionBuilder.withArgName("httpProtocol");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("http protocol to use: HTTP/1.1 or org.apache.coyote.http11.Http11NioProtocol");
        httpProtocol = OptionBuilder.create("httpProtocol");
        OptionBuilder.withArgName("extractDirectory");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("path to extract war content, default value: .extract");
        extractDirectory = OptionBuilder.create("extractDirectory");
        OptionBuilder.withArgName("loggerName");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("logger to use: slf4j to use slf4j bridge on top of jul");
        loggerName = OptionBuilder.create("loggerName");
        OptionBuilder.withArgName("uriEncoding");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("connector uriEncoding default ISO-8859-1");
        uriEncoding = OptionBuilder.create("uriEncoding");
        options = new Options();
        options.addOption(httpPort).addOption(httpsPort).addOption(ajpPort).addOption(serverXmlPath).addOption(resetExtract).addOption(help).addOption(debug).addOption(sysProps).addOption(httpProtocol).addOption(clientAuth).addOption(keyAlias).addOption(obfuscate).addOption(extractDirectory).addOption(loggerName).addOption(uriEncoding).addOption(maxPostSize);
    }
}

