/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.store.raw.data;

import java.io.File;
import java.util.Properties;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.daemon.DaemonService;
import org.apache.derby.iapi.services.daemon.Serviceable;
import org.apache.derby.iapi.store.access.FileResource;
import org.apache.derby.iapi.store.access.RowSource;
import org.apache.derby.iapi.store.raw.ContainerHandle;
import org.apache.derby.iapi.store.raw.ContainerKey;
import org.apache.derby.iapi.store.raw.Corruptable;
import org.apache.derby.iapi.store.raw.LockingPolicy;
import org.apache.derby.iapi.store.raw.RawStoreFactory;
import org.apache.derby.iapi.store.raw.StreamContainerHandle;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.store.raw.UndoHandler;
import org.apache.derby.iapi.store.raw.data.RawContainerHandle;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.io.StorageFactory;

public interface DataFactory
extends Corruptable {
    public static final String MODULE = "org.apache.derby.iapi.store.raw.data.DataFactory";
    public static final String TEMP_SEGMENT_NAME = "tmp";
    public static final String DB_LOCKFILE_NAME = "db.lck";
    public static final String DB_EX_LOCKFILE_NAME = "dbex.lck";

    public boolean isReadOnly();

    public ContainerHandle openContainer(RawTransaction var1, ContainerKey var2, LockingPolicy var3, int var4) throws StandardException;

    public RawContainerHandle openDroppedContainer(RawTransaction var1, ContainerKey var2, LockingPolicy var3, int var4) throws StandardException;

    public long addContainer(RawTransaction var1, long var2, long var4, int var6, Properties var7, int var8) throws StandardException;

    public long addAndLoadStreamContainer(RawTransaction var1, long var2, Properties var4, RowSource var5) throws StandardException;

    public StreamContainerHandle openStreamContainer(RawTransaction var1, long var2, long var4, boolean var6) throws StandardException;

    public void dropStreamContainer(RawTransaction var1, long var2, long var4) throws StandardException;

    public void reCreateContainerForRedoRecovery(RawTransaction var1, long var2, long var4, ByteArray var6) throws StandardException;

    public void dropContainer(RawTransaction var1, ContainerKey var2) throws StandardException;

    public void checkpoint() throws StandardException;

    public void idle() throws StandardException;

    public UUID getIdentifier();

    public void setRawStoreFactory(RawStoreFactory var1, boolean var2, Properties var3) throws StandardException;

    public void createFinished() throws StandardException;

    public FileResource getFileHandler();

    public void removeStubsOK();

    public int reclaimSpace(Serviceable var1, ContextManager var2) throws StandardException;

    public void postRecovery() throws StandardException;

    public void setupCacheCleaner(DaemonService var1);

    public int encrypt(byte[] var1, int var2, int var3, byte[] var4, int var5, boolean var6) throws StandardException;

    public int decrypt(byte[] var1, int var2, int var3, byte[] var4, int var5) throws StandardException;

    public void decryptAllContainers(RawTransaction var1) throws StandardException;

    public void encryptAllContainers(RawTransaction var1) throws StandardException;

    public void removeOldVersionOfContainers() throws StandardException;

    public void setDatabaseEncrypted(boolean var1);

    public int getEncryptionBlockSize();

    public void freezePersistentStore() throws StandardException;

    public void unfreezePersistentStore();

    public void writeInProgress() throws StandardException;

    public void writeFinished();

    public void backupDataFiles(Transaction var1, File var2) throws StandardException;

    public long getMaxContainerId() throws StandardException;

    public void removeDroppedContainerFileStubs(LogInstant var1) throws StandardException;

    public StorageFactory getStorageFactory();

    public String getRootDirectory();

    public void stop();

    public boolean databaseEncrypted();

    public void setUndoInsertEventHandler(UndoHandler var1);
}

