/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.loader;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import javax.management.ObjectName;
import javax.servlet.ServletContext;
import org.apache.catalina.Context;
import org.apache.catalina.Globals;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Loader;
import org.apache.catalina.loader.ParallelWebappClassLoader;
import org.apache.catalina.loader.WebappClassLoaderBase;
import org.apache.catalina.util.LifecycleMBeanBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomcat.util.res.StringManager;

public class WebappLoader
extends LifecycleMBeanBase
implements Loader,
PropertyChangeListener {
    private WebappClassLoaderBase classLoader = null;
    private Context context = null;
    private boolean delegate = false;
    private String loaderClass = ParallelWebappClassLoader.class.getName();
    private ClassLoader parentClassLoader = null;
    private boolean reloadable = false;
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.loader");
    protected final PropertyChangeSupport support = new PropertyChangeSupport(this);
    private String classpath = null;
    private static final Log log = LogFactory.getLog(WebappLoader.class);

    public WebappLoader() {
        this(null);
    }

    public WebappLoader(ClassLoader parent) {
        this.parentClassLoader = parent;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public void setContext(Context context) {
        if (this.context == context) {
            return;
        }
        if (this.getState().isAvailable()) {
            throw new IllegalStateException(sm.getString("webappLoader.setContext.ise"));
        }
        if (this.context != null) {
            this.context.removePropertyChangeListener(this);
        }
        Context oldContext = this.context;
        this.context = context;
        this.support.firePropertyChange("context", oldContext, this.context);
        if (this.context != null) {
            this.setReloadable(this.context.getReloadable());
            this.context.addPropertyChangeListener(this);
        }
    }

    @Override
    public boolean getDelegate() {
        return this.delegate;
    }

    @Override
    public void setDelegate(boolean delegate) {
        boolean oldDelegate = this.delegate;
        this.delegate = delegate;
        this.support.firePropertyChange("delegate", (Object)oldDelegate, (Object)this.delegate);
    }

    public String getLoaderClass() {
        return this.loaderClass;
    }

    public void setLoaderClass(String loaderClass) {
        this.loaderClass = loaderClass;
    }

    @Override
    public boolean getReloadable() {
        return this.reloadable;
    }

    @Override
    public void setReloadable(boolean reloadable) {
        boolean oldReloadable = this.reloadable;
        this.reloadable = reloadable;
        this.support.firePropertyChange("reloadable", (Object)oldReloadable, (Object)this.reloadable);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void backgroundProcess() {
        if (this.reloadable && this.modified()) {
            try {
                Thread.currentThread().setContextClassLoader(WebappLoader.class.getClassLoader());
                if (this.context != null) {
                    this.context.reload();
                }
            }
            finally {
                if (this.context != null && this.context.getLoader() != null) {
                    Thread.currentThread().setContextClassLoader(this.context.getLoader().getClassLoader());
                }
            }
        }
    }

    public String[] getLoaderRepositories() {
        if (this.classLoader == null) {
            return new String[0];
        }
        URL[] urls = this.classLoader.getURLs();
        String[] result = new String[urls.length];
        for (int i = 0; i < urls.length; ++i) {
            result[i] = urls[i].toExternalForm();
        }
        return result;
    }

    public String getLoaderRepositoriesString() {
        String[] repositories = this.getLoaderRepositories();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < repositories.length; ++i) {
            sb.append(repositories[i]).append(":");
        }
        return sb.toString();
    }

    public String getClasspath() {
        return this.classpath;
    }

    @Override
    public boolean modified() {
        return this.classLoader != null ? this.classLoader.modified() : false;
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("WebappLoader[");
        if (this.context != null) {
            sb.append(this.context.getName());
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    protected void startInternal() throws LifecycleException {
        if (log.isDebugEnabled()) {
            log.debug(sm.getString("webappLoader.starting"));
        }
        if (this.context.getResources() == null) {
            log.info("No resources for " + this.context);
            this.setState(LifecycleState.STARTING);
            return;
        }
        try {
            this.classLoader = this.createClassLoader();
            this.classLoader.setResources(this.context.getResources());
            this.classLoader.setDelegate(this.delegate);
            this.setClassPath();
            this.setPermissions();
            this.classLoader.start();
            String contextName = this.context.getName();
            if (!contextName.startsWith("/")) {
                contextName = "/" + contextName;
            }
            ObjectName cloname = new ObjectName(this.context.getDomain() + ":type=" + this.classLoader.getClass().getSimpleName() + ",host=" + this.context.getParent().getName() + ",context=" + contextName);
            Registry.getRegistry(null, null).registerComponent((Object)this.classLoader, cloname, null);
        }
        catch (Throwable t) {
            t = ExceptionUtils.unwrapInvocationTargetException(t);
            ExceptionUtils.handleThrowable(t);
            log.error("LifecycleException ", t);
            throw new LifecycleException("start: ", t);
        }
        this.setState(LifecycleState.STARTING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void stopInternal() throws LifecycleException {
        if (log.isDebugEnabled()) {
            log.debug(sm.getString("webappLoader.stopping"));
        }
        this.setState(LifecycleState.STOPPING);
        ServletContext servletContext = this.context.getServletContext();
        servletContext.removeAttribute("org.apache.catalina.jsp_classpath");
        if (this.classLoader != null) {
            try {
                this.classLoader.stop();
            }
            finally {
                this.classLoader.destroy();
            }
            try {
                String contextName = this.context.getName();
                if (!contextName.startsWith("/")) {
                    contextName = "/" + contextName;
                }
                ObjectName cloname = new ObjectName(this.context.getDomain() + ":type=" + this.classLoader.getClass().getSimpleName() + ",host=" + this.context.getParent().getName() + ",context=" + contextName);
                Registry.getRegistry(null, null).unregisterComponent(cloname);
            }
            catch (Exception e) {
                log.error("LifecycleException ", e);
            }
        }
        this.classLoader = null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (!(event.getSource() instanceof Context)) {
            return;
        }
        if (event.getPropertyName().equals("reloadable")) {
            try {
                this.setReloadable((Boolean)event.getNewValue());
            }
            catch (NumberFormatException e) {
                log.error(sm.getString("webappLoader.reloadable", event.getNewValue().toString()));
            }
        }
    }

    private WebappClassLoaderBase createClassLoader() throws Exception {
        Class<?> clazz = Class.forName(this.loaderClass);
        WebappClassLoaderBase classLoader = null;
        if (this.parentClassLoader == null) {
            this.parentClassLoader = this.context.getParentClassLoader();
        }
        Class[] argTypes = new Class[]{ClassLoader.class};
        Object[] args = new Object[]{this.parentClassLoader};
        Constructor<?> constr = clazz.getConstructor(argTypes);
        classLoader = (WebappClassLoaderBase)constr.newInstance(args);
        return classLoader;
    }

    private void setPermissions() {
        if (!Globals.IS_SECURITY_ENABLED) {
            return;
        }
        if (this.context == null) {
            return;
        }
        ServletContext servletContext = this.context.getServletContext();
        File workDir = (File)servletContext.getAttribute("javax.servlet.context.tempdir");
        if (workDir != null) {
            try {
                String workDirPath = workDir.getCanonicalPath();
                this.classLoader.addPermission(new FilePermission(workDirPath, "read,write"));
                this.classLoader.addPermission(new FilePermission(workDirPath + File.separator + "-", "read,write,delete"));
            }
            catch (IOException workDirPath) {
                // empty catch block
            }
        }
        for (URL url : this.context.getResources().getBaseUrls()) {
            this.classLoader.addPermission(url);
        }
    }

    private void setClassPath() {
        if (this.context == null) {
            return;
        }
        ServletContext servletContext = this.context.getServletContext();
        if (servletContext == null) {
            return;
        }
        StringBuilder classpath = new StringBuilder();
        ClassLoader loader = this.getClassLoader();
        if (this.delegate && loader != null) {
            loader = loader.getParent();
        }
        while (loader != null && this.buildClassPath(classpath, loader)) {
            loader = loader.getParent();
        }
        if (this.delegate && (loader = this.getClassLoader()) != null) {
            this.buildClassPath(classpath, loader);
        }
        this.classpath = classpath.toString();
        servletContext.setAttribute("org.apache.catalina.jsp_classpath", this.classpath);
    }

    private boolean buildClassPath(StringBuilder classpath, ClassLoader loader) {
        if (loader instanceof URLClassLoader) {
            URL[] repositories = ((URLClassLoader)loader).getURLs();
            for (int i = 0; i < repositories.length; ++i) {
                String repository = repositories[i].toString();
                if (repository.startsWith("file://")) {
                    repository = this.utf8Decode(repository.substring(7));
                } else {
                    if (!repository.startsWith("file:")) continue;
                    repository = this.utf8Decode(repository.substring(5));
                }
                if (repository == null) continue;
                if (classpath.length() > 0) {
                    classpath.append(File.pathSeparator);
                }
                classpath.append(repository);
            }
        } else {
            String cp = this.getClasspath(loader);
            if (cp == null) {
                log.info("Unknown loader " + loader + " " + loader.getClass());
            } else {
                if (classpath.length() > 0) {
                    classpath.append(File.pathSeparator);
                }
                classpath.append(cp);
            }
            return false;
        }
        return true;
    }

    private String utf8Decode(String input) {
        String result = null;
        try {
            result = URLDecoder.decode(input, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return result;
    }

    private String getClasspath(ClassLoader loader) {
        try {
            Method m = loader.getClass().getMethod("getClasspath", new Class[0]);
            if (log.isTraceEnabled()) {
                log.trace("getClasspath " + m);
            }
            Object o = m.invoke((Object)loader, new Object[0]);
            if (log.isDebugEnabled()) {
                log.debug("gotClasspath " + o);
            }
            if (o instanceof String) {
                return (String)o;
            }
            return null;
        }
        catch (Exception ex) {
            Throwable t = ExceptionUtils.unwrapInvocationTargetException(ex);
            ExceptionUtils.handleThrowable(t);
            if (log.isDebugEnabled()) {
                log.debug("getClasspath ", ex);
            }
            return null;
        }
    }

    @Override
    protected String getDomainInternal() {
        return this.context.getDomain();
    }

    @Override
    protected String getObjectNameKeyProperties() {
        StringBuilder name = new StringBuilder("type=Loader");
        name.append(",host=");
        name.append(this.context.getParent().getName());
        name.append(",context=");
        String contextName = this.context.getName();
        if (!contextName.startsWith("/")) {
            name.append("/");
        }
        name.append(contextName);
        return name.toString();
    }
}

