/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.cms.managed;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.eclipse.dirigible.api.v3.core.DestinationsFacade;
import org.eclipse.dirigible.cms.api.ICmsProvider;
import org.eclipse.dirigible.commons.config.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmsProviderManaged
implements ICmsProvider {
    public static final String DIRIGIBLE_CMS_MANAGED_CONFIGURATION_AUTH_METHOD_KEY = "key";
    public static final String DIRIGIBLE_CMS_MANAGED_CONFIGURATION_AUTH_METHOD_DEST = "destination";
    public static final String NAME = "cmis";
    public static final String TYPE = "managed";
    private static final String PARAM_USER = "User";
    private static final String PARAM_PASSWORD = "Password";
    private static final Logger logger = LoggerFactory.getLogger(CmsProviderManaged.class);
    private Object cmisSession;

    public String getName() {
        return NAME;
    }

    public String getType() {
        return TYPE;
    }

    public Object getSession() {
        if (this.cmisSession == null) {
            try {
                this.cmisSession = this.lookupCmisSession();
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException | NamingException e) {
                String message = "Error in initializing the managed CMIS session";
                logger.error(message, (Throwable)e);
                throw new IllegalStateException(message, e);
            }
        }
        return this.cmisSession;
    }

    public Object lookupCmisSession() throws NamingException, NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        block11: {
            InitialContext ctx = new InitialContext();
            Configuration.load((String)"/dirigible-cms.properties");
            String key = Configuration.get((String)"DIRIGIBLE_CMS_MANAGED_CONFIGURATION_JNDI_NAME");
            if (key != null) {
                Object ecmService = ctx.lookup(key);
                if (ecmService != null) {
                    String authMethod = Configuration.get((String)"DIRIGIBLE_CMS_MANAGED_CONFIGURATION_AUTH_METHOD");
                    logger.debug(String.format("CMIS Authentication Method: %s", authMethod));
                    String uniqueName = null;
                    String secretKey = null;
                    if (DIRIGIBLE_CMS_MANAGED_CONFIGURATION_AUTH_METHOD_KEY.equals(authMethod)) {
                        uniqueName = Configuration.get((String)"DIRIGIBLE_CMS_MANAGED_CONFIGURATION_NAME");
                        secretKey = Configuration.get((String)"DIRIGIBLE_CMS_MANAGED_CONFIGURATION_KEY");
                    } else if (DIRIGIBLE_CMS_MANAGED_CONFIGURATION_AUTH_METHOD_DEST.equals(authMethod)) {
                        String destinationName = Configuration.get((String)"DIRIGIBLE_CMS_MANAGED_CONFIGURATION_DESTINATION");
                        Map destinationPropeties = DestinationsFacade.initializeFromDestination((String)destinationName);
                        if (destinationPropeties.get(PARAM_USER) != null) {
                            uniqueName = (String)destinationPropeties.get(PARAM_USER);
                        }
                        if (destinationPropeties.get(PARAM_PASSWORD) != null) {
                            secretKey = (String)destinationPropeties.get(PARAM_PASSWORD);
                        }
                    } else {
                        String message = String.format("Connection to CMIS Repository was failed. Invalid Authentication Method: %s", authMethod);
                        logger.error(message);
                        throw new SecurityException(message);
                    }
                    logger.info(String.format("Connecting to CMIS Repository with name: %s for type: %s", uniqueName, authMethod));
                    try {
                        Method connectMethod = ecmService.getClass().getMethod("connect", String.class, String.class);
                        Object openCmisSession = connectMethod.invoke(ecmService, uniqueName, secretKey);
                        if (openCmisSession != null) {
                            logger.info(String.format("Connection to CMIS Repository with name: %s was successful.", uniqueName));
                            return openCmisSession;
                        }
                        break block11;
                    }
                    catch (Throwable t) {
                        String message = "Connection to CMIS Repository was failed.";
                        logger.error(message, t);
                        throw new IllegalStateException(message, t);
                    }
                }
                String message = "ECM is requested as CMIS service, but it is not available.";
                logger.error(message);
                throw new IllegalStateException(message);
            }
            String message = "CMIS service JNDI name has not been provided.";
            logger.error(message);
            throw new IllegalArgumentException(message);
        }
        String message = "Initializing the managed CMIS session failed.";
        logger.error(message);
        throw new IllegalStateException(message);
    }
}

