/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.ui;

import org.eclipse.core.variables.IDynamicVariable;
import org.eclipse.core.variables.IStringVariable;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.debug.internal.ui.stringsubstitution.IArgumentSelector;
import org.eclipse.debug.internal.ui.stringsubstitution.StringSubstitutionMessages;
import org.eclipse.debug.internal.ui.stringsubstitution.StringVariableLabelProvider;
import org.eclipse.debug.internal.ui.stringsubstitution.StringVariablePresentationManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class StringVariableSelectionDialog
extends ElementListSelectionDialog {
    private Button fArgumentButton;
    private Text fDescriptionText;
    private Text fArgumentText;
    private String fArgumentValue;
    private Button fEditVariablesButton;

    public StringVariableSelectionDialog(Shell parent) {
        super(parent, (ILabelProvider)new StringVariableLabelProvider());
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.setTitle(StringSubstitutionMessages.StringVariableSelectionDialog_2);
        this.setMessage(StringSubstitutionMessages.StringVariableSelectionDialog_3);
        this.setMultipleSelection(false);
        this.setElements(VariablesPlugin.getDefault().getStringVariableManager().getVariables());
    }

    public String getVariableExpression() {
        Object[] selected = this.getResult();
        if (selected != null && selected.length == 1) {
            IStringVariable variable = (IStringVariable)selected[0];
            StringBuffer buffer = new StringBuffer();
            buffer.append("${");
            buffer.append(variable.getName());
            if (this.fArgumentValue != null && this.fArgumentValue.length() > 0) {
                buffer.append(":");
                buffer.append(this.fArgumentValue);
            }
            buffer.append("}");
            return buffer.toString();
        }
        return null;
    }

    protected Control createContents(Composite parent) {
        Control ctrl = super.createContents(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(ctrl, "org.eclipse.debug.ui.variable_selection_dialog_context");
        return ctrl;
    }

    protected Control createDialogArea(Composite parent) {
        Control control = super.createDialogArea(parent);
        this.createArgumentArea((Composite)control);
        return control;
    }

    private void createArgumentArea(Composite parent) {
        Composite container = SWTFactory.createComposite(parent, parent.getFont(), 2, 1, 768, 0, 0);
        SWTFactory.createHorizontalSpacer(container, 1);
        this.fEditVariablesButton = SWTFactory.createPushButton(container, StringSubstitutionMessages.StringVariableSelectionDialog_0, null, 128);
        this.fEditVariablesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StringVariableSelectionDialog.this.editVariables();
            }
        });
        SWTFactory.createWrapLabel(container, StringSubstitutionMessages.StringVariableSelectionDialog_6, 2);
        Composite args = SWTFactory.createComposite(container, container.getFont(), 2, 2, 768, 0, 0);
        this.fArgumentText = new Text(args, 2048);
        this.fArgumentText.setFont(container.getFont());
        this.fArgumentText.setLayoutData((Object)new GridData(768));
        this.fArgumentButton = SWTFactory.createPushButton(args, StringSubstitutionMessages.StringVariableSelectionDialog_7, null);
        this.fArgumentButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StringVariableSelectionDialog.this.configureArgument();
            }
        });
        SWTFactory.createWrapLabel(container, StringSubstitutionMessages.StringVariableSelectionDialog_8, 2);
        this.fDescriptionText = new Text(container, 2624);
        this.fDescriptionText.setFont(container.getFont());
        this.fDescriptionText.setEditable(false);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.heightHint = 50;
        this.fDescriptionText.setLayoutData((Object)gd);
    }

    protected void editVariables() {
        final Display display = DebugUIPlugin.getStandardDisplay();
        BusyIndicator.showWhile((Display)display, (Runnable)new Runnable(){

            public void run() {
                SWTFactory.showPreferencePage("org.eclipse.debug.ui.StringVariablePreferencePage");
                IStringVariable[] elements = VariablesPlugin.getDefault().getStringVariableManager().getVariables();
                display.asyncExec(new Runnable(this, elements){
                    final /* synthetic */ 3 this$1;
                    private final /* synthetic */ IStringVariable[] val$elements;
                    {
                        this.this$1 = var1_1;
                        this.val$elements = iStringVariableArray;
                    }

                    public void run() {
                        StringVariableSelectionDialog.access$0(3.access$0(this.this$1), this.val$elements);
                    }
                });
            }

            static /* synthetic */ StringVariableSelectionDialog access$0(3 var0) {
                return var0.StringVariableSelectionDialog.this;
            }
        });
    }

    protected void configureArgument() {
        Object[] objects = this.getSelectedElements();
        IStringVariable variable = (IStringVariable)objects[0];
        IArgumentSelector selector = StringVariablePresentationManager.getDefault().getArgumentSelector(variable);
        String value = selector.selectArgument(variable, this.getShell());
        if (value != null) {
            this.fArgumentText.setText(value);
        }
    }

    protected void handleSelectionChanged() {
        super.handleSelectionChanged();
        Object[] objects = this.getSelectedElements();
        boolean buttonEnabled = false;
        boolean argEnabled = false;
        String text = null;
        if (objects.length == 1) {
            IStringVariable variable = (IStringVariable)objects[0];
            IArgumentSelector selector = StringVariablePresentationManager.getDefault().getArgumentSelector(variable);
            if (variable instanceof IDynamicVariable) {
                argEnabled = ((IDynamicVariable)variable).supportsArgument();
            }
            buttonEnabled = argEnabled && selector != null;
            text = variable.getDescription();
        }
        if (text == null) {
            text = "";
        }
        this.fArgumentText.setEnabled(argEnabled);
        this.fArgumentButton.setEnabled(buttonEnabled);
        this.fDescriptionText.setText(text);
    }

    protected void okPressed() {
        this.fArgumentValue = this.fArgumentText.getText().trim();
        super.okPressed();
    }

    private String getDialogSettingsSectionName() {
        return "org.eclipse.debug.ui.STRING_VARIABLE_SELECTION_DIALOG_SECTION";
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = DebugUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(this.getDialogSettingsSectionName());
        if (section == null) {
            section = settings.addNewSection(this.getDialogSettingsSectionName());
        }
        return section;
    }

    static /* synthetic */ void access$0(StringVariableSelectionDialog stringVariableSelectionDialog, Object[] objectArray) {
        stringVariableSelectionDialog.setListElements(objectArray);
    }
}

