/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.launch;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.ITerminate;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.DelegatingModelPresentation;
import org.eclipse.debug.internal.ui.actions.AddToFavoritesAction;
import org.eclipse.debug.internal.ui.actions.EditLaunchConfigurationAction;
import org.eclipse.debug.internal.ui.commands.actions.DebugCommandAction;
import org.eclipse.debug.internal.ui.commands.actions.DisconnectCommandAction;
import org.eclipse.debug.internal.ui.commands.actions.DropToFrameCommandAction;
import org.eclipse.debug.internal.ui.commands.actions.ResumeCommandAction;
import org.eclipse.debug.internal.ui.commands.actions.StepIntoCommandAction;
import org.eclipse.debug.internal.ui.commands.actions.StepOverCommandAction;
import org.eclipse.debug.internal.ui.commands.actions.StepReturnCommandAction;
import org.eclipse.debug.internal.ui.commands.actions.SuspendCommandAction;
import org.eclipse.debug.internal.ui.commands.actions.TerminateAllAction;
import org.eclipse.debug.internal.ui.commands.actions.TerminateAndRelaunchAction;
import org.eclipse.debug.internal.ui.commands.actions.TerminateAndRemoveAction;
import org.eclipse.debug.internal.ui.commands.actions.TerminateCommandAction;
import org.eclipse.debug.internal.ui.commands.actions.ToggleStepFiltersAction;
import org.eclipse.debug.internal.ui.sourcelookup.EditSourceLookupPathAction;
import org.eclipse.debug.internal.ui.sourcelookup.LookupSourceAction;
import org.eclipse.debug.internal.ui.viewers.model.InternalTreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.model.VirtualFindAction;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelChangedListener;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDeltaVisitor;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxy;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdateListener;
import org.eclipse.debug.internal.ui.viewers.model.provisional.TreeModelViewer;
import org.eclipse.debug.internal.ui.views.DebugModelPresentationContext;
import org.eclipse.debug.internal.ui.views.DebugUIViewsMessages;
import org.eclipse.debug.ui.AbstractDebugView;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.contexts.AbstractDebugContextProvider;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IPerspectiveListener2;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.progress.UIJob;

public class LaunchView
extends AbstractDebugView
implements ISelectionChangedListener,
IPerspectiveListener2,
IPageListener,
IShowInTarget,
IShowInSource,
IShowInTargetList,
IPartListener2,
IViewerUpdateListener {
    public static final String ID_CONTEXT_ACTIVITY_BINDINGS = "contextActivityBindings";
    private static final String TERMINATE = "terminate";
    private static final String DISCONNECT = "disconnect";
    private static final String SUSPEND = "suspend";
    private static final String RESUME = "resume";
    private static final String STEP_RETURN = "step_return";
    private static final String STEP_OVER = "step_over";
    private static final String DROP_TO_FRAME = "drop_to_frame";
    private static final String STEP_INTO = "step_into";
    private static final String TERMINATE_AND_REMOVE = "terminate_and_remove";
    private static final String TERMINATE_ALL = "terminate_all";
    private static final String TERMINATE_AND_RELAUNCH = "terminate_relaunch";
    private static final String TOGGLE_STEP_FILTERS = "toggle_step_filters";
    private boolean fIsActive = true;
    private IDebugModelPresentation fPresentation = null;
    private EditLaunchConfigurationAction fEditConfigAction = null;
    private AddToFavoritesAction fAddToFavoritesAction = null;
    private EditSourceLookupPathAction fEditSourceAction = null;
    private LookupSourceAction fLookupAction = null;
    private ContextProvider fProvider;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    protected String getHelpContextId() {
        return "org.eclipse.debug.ui.debug_view_context";
    }

    protected void createActions() {
        this.setAction("Properties", (IAction)new PropertyDialogAction((IShellProvider)this.getSite(), this.getSite().getSelectionProvider()));
        this.fEditConfigAction = new EditLaunchConfigurationAction();
        this.fAddToFavoritesAction = new AddToFavoritesAction();
        this.fEditSourceAction = new EditSourceLookupPathAction(this);
        this.fLookupAction = new LookupSourceAction(this);
        this.setAction(FIND_ACTION, (IAction)new VirtualFindAction((InternalTreeModelViewer)this.getViewer()));
        this.addCapabilityAction(new TerminateCommandAction(), TERMINATE);
        this.addCapabilityAction(new DisconnectCommandAction(), DISCONNECT);
        this.addCapabilityAction(new SuspendCommandAction(), SUSPEND);
        this.addCapabilityAction(new ResumeCommandAction(), RESUME);
        this.addCapabilityAction(new StepReturnCommandAction(), STEP_RETURN);
        this.addCapabilityAction(new StepOverCommandAction(), STEP_OVER);
        this.addCapabilityAction(new StepIntoCommandAction(), STEP_INTO);
        this.addCapabilityAction(new DropToFrameCommandAction(), DROP_TO_FRAME);
        this.addCapabilityAction(new TerminateAndRemoveAction(), TERMINATE_AND_REMOVE);
        this.addCapabilityAction(new TerminateAndRelaunchAction(), TERMINATE_AND_RELAUNCH);
        this.addCapabilityAction(new TerminateAllAction(), TERMINATE_ALL);
        this.addCapabilityAction(new ToggleStepFiltersAction(), TOGGLE_STEP_FILTERS);
    }

    private void addCapabilityAction(DebugCommandAction capability, String actionID) {
        capability.init((IWorkbenchPart)this);
        this.setAction(actionID, (IAction)capability);
    }

    private void disposeCommandAction(String actionID) {
        DebugCommandAction action = (DebugCommandAction)this.getAction(actionID);
        action.dispose();
    }

    protected Viewer createViewer(Composite parent) {
        this.fPresentation = new DelegatingModelPresentation();
        TreeModelViewer viewer = new TreeModelViewer(parent, 268436226, new DebugModelPresentationContext("org.eclipse.debug.ui.DebugView", this.fPresentation));
        viewer.addSelectionChangedListener(this);
        viewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.character == '\u007f' && event.stateMask == 0) {
                    LaunchView.this.handleDeleteKeyPressed();
                }
            }
        });
        viewer.addViewerUpdateListener(this);
        this.getSite().setSelectionProvider((ISelectionProvider)viewer);
        viewer.setInput(DebugPlugin.getDefault().getLaunchManager());
        this.fProvider = new ContextProvider(viewer);
        DebugUITools.getDebugContextManager().getContextService(this.getSite().getWorkbenchWindow()).addDebugContextProvider(this.fProvider);
        return viewer;
    }

    private void handleDeleteKeyPressed() {
        IStructuredSelection selection = (IStructuredSelection)this.getViewer().getSelection();
        Iterator iter = selection.iterator();
        boolean itemsToTerminate = false;
        while (iter.hasNext()) {
            ITerminate terminable;
            Object item = iter.next();
            if (!(item instanceof ITerminate) || !(terminable = (ITerminate)item).canTerminate() || terminable.isTerminated()) continue;
            itemsToTerminate = true;
            break;
        }
        if (itemsToTerminate && !MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)DebugUIViewsMessages.LaunchView_Terminate_and_Remove_1, (String)DebugUIViewsMessages.LaunchView_Terminate_and_remove_selected__2)) {
            return;
        }
        MultiStatus status = new MultiStatus(DebugUIPlugin.getUniqueIdentifier(), 5012, DebugUIViewsMessages.LaunchView_Exceptions_occurred_attempting_to_terminate_and_remove_3, null);
        iter = selection.iterator();
        while (iter.hasNext()) {
            try {
                LaunchView.terminateAndRemove(iter.next());
            }
            catch (DebugException exception) {
                status.merge(exception.getStatus());
            }
        }
        if (!status.isOK()) {
            IWorkbenchWindow window = DebugUIPlugin.getActiveWorkbenchWindow();
            if (window != null) {
                DebugUIPlugin.errorDialog(window.getShell(), DebugUIViewsMessages.LaunchView_Terminate_and_Remove_4, DebugUIViewsMessages.LaunchView_Terminate_and_remove_failed_5, (IStatus)status);
            } else {
                DebugUIPlugin.log((IStatus)status);
            }
        }
    }

    public static void terminateAndRemove(Object element) throws DebugException {
        ILaunch launch = null;
        ILaunch terminable = null;
        if (element instanceof ILaunch) {
            launch = (ILaunch)element;
        } else if (element instanceof IDebugElement) {
            launch = ((IDebugElement)element).getLaunch();
        } else if (element instanceof IProcess) {
            launch = ((IProcess)element).getLaunch();
        }
        terminable = launch;
        if (terminable == null && element instanceof ITerminate) {
            terminable = (ITerminate)element;
        }
        if (terminable == null) {
            return;
        }
        if (!terminable.canTerminate() && !terminable.isTerminated()) {
            return;
        }
        try {
            if (!terminable.isTerminated()) {
                terminable.terminate();
            }
        }
        finally {
            if (launch != null) {
                ILaunchManager lManager = DebugPlugin.getDefault().getLaunchManager();
                lManager.removeLaunch(launch);
            }
        }
    }

    private void commonInit(IViewSite site) {
        site.getPage().addPartListener((IPartListener2)this);
        site.getWorkbenchWindow().addPageListener((IPageListener)this);
        site.getWorkbenchWindow().addPerspectiveListener((IPerspectiveListener)this);
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.commonInit(site);
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.commonInit(site);
    }

    protected void configureToolBar(IToolBarManager tbm) {
        tbm.add((IContributionItem)new Separator("threadGroup"));
        tbm.add((IContributionItem)new Separator("stepGroup"));
        tbm.add((IContributionItem)new GroupMarker("stepIntoGroup"));
        tbm.add((IContributionItem)new GroupMarker("stepOverGroup"));
        tbm.add((IContributionItem)new GroupMarker("stepReturnGroup"));
        tbm.add((IContributionItem)new GroupMarker("emptyStepGroup"));
        tbm.add((IContributionItem)new Separator("renderGroup"));
        tbm.appendToGroup("threadGroup", this.getAction(RESUME));
        tbm.appendToGroup("threadGroup", this.getAction(SUSPEND));
        tbm.appendToGroup("threadGroup", this.getAction(TERMINATE));
        tbm.appendToGroup("threadGroup", this.getAction(DISCONNECT));
        tbm.appendToGroup("stepIntoGroup", this.getAction(STEP_INTO));
        tbm.appendToGroup("stepOverGroup", this.getAction(STEP_OVER));
        tbm.appendToGroup("stepReturnGroup", this.getAction(STEP_RETURN));
        tbm.appendToGroup("emptyStepGroup", this.getAction(DROP_TO_FRAME));
        tbm.appendToGroup("renderGroup", this.getAction(TOGGLE_STEP_FILTERS));
    }

    public void dispose() {
        DebugUITools.getDebugContextManager().getContextService(this.getSite().getWorkbenchWindow()).removeDebugContextProvider(this.fProvider);
        this.disposeActions();
        this.fProvider.dispose();
        Viewer viewer = this.getViewer();
        if (viewer != null) {
            viewer.removeSelectionChangedListener((ISelectionChangedListener)this);
            ((TreeModelViewer)viewer).removeViewerUpdateListener(this);
        }
        IWorkbenchPage page = this.getSite().getPage();
        page.removePartListener((IPartListener2)this);
        IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
        window.removePerspectiveListener((IPerspectiveListener)this);
        window.removePageListener((IPageListener)this);
        super.dispose();
    }

    private void disposeActions() {
        PropertyDialogAction properties = (PropertyDialogAction)this.getAction("Properties");
        properties.dispose();
        this.disposeCommandAction(TERMINATE);
        this.disposeCommandAction(DISCONNECT);
        this.disposeCommandAction(SUSPEND);
        this.disposeCommandAction(RESUME);
        this.disposeCommandAction(STEP_RETURN);
        this.disposeCommandAction(STEP_OVER);
        this.disposeCommandAction(STEP_INTO);
        this.disposeCommandAction(DROP_TO_FRAME);
        this.disposeCommandAction(TERMINATE_AND_REMOVE);
        this.disposeCommandAction(TERMINATE_AND_RELAUNCH);
        this.disposeCommandAction(TERMINATE_ALL);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.fProvider.activate(event.getSelection());
        this.updateObjects();
    }

    public void doubleClick(DoubleClickEvent event) {
        ISelection selection = event.getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection ss = (IStructuredSelection)selection;
        Object o = ss.getFirstElement();
        if (o == null || o instanceof IStackFrame) {
            return;
        }
        StructuredViewer viewer = (StructuredViewer)this.getViewer();
        viewer.refresh(o);
    }

    public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        this.setActive(page.findView(this.getSite().getId()) != null);
        this.updateObjects();
    }

    public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
        this.setActive(page.findView(this.getSite().getId()) != null);
    }

    public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, IWorkbenchPartReference partRef, String changeId) {
    }

    public void pageActivated(IWorkbenchPage page) {
        if (this.getSite().getPage().equals(page)) {
            this.setActive(true);
            this.updateObjects();
        }
    }

    public void pageClosed(IWorkbenchPage page) {
    }

    public void pageOpened(IWorkbenchPage page) {
    }

    public IDebugModelPresentation getPresentation(String id) {
        return ((DelegatingModelPresentation)this.fPresentation).getPresentation(id);
    }

    protected void fillContextMenu(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("emptyEditGroup"));
        menu.add((IContributionItem)new Separator("editGroup"));
        menu.add(this.getAction(FIND_ACTION));
        menu.add((IContributionItem)new Separator("emptyStepGroup"));
        menu.add((IContributionItem)new Separator("stepGroup"));
        menu.add((IContributionItem)new GroupMarker("stepIntoGroup"));
        menu.add((IContributionItem)new GroupMarker("stepOverGroup"));
        menu.add((IContributionItem)new GroupMarker("stepReturnGroup"));
        menu.add((IContributionItem)new Separator("renderGroup"));
        menu.add((IContributionItem)new Separator("emptyThreadGroup"));
        menu.add((IContributionItem)new Separator("threadGroup"));
        menu.add((IContributionItem)new Separator("emptyLaunchGroup"));
        menu.add((IContributionItem)new Separator("launchGroup"));
        IStructuredSelection selection = (IStructuredSelection)this.getSite().getSelectionProvider().getSelection();
        this.updateAndAdd(menu, this.fEditConfigAction, selection);
        this.updateAndAdd(menu, this.fAddToFavoritesAction, selection);
        this.updateAndAdd(menu, this.fEditSourceAction, selection);
        this.updateAndAdd(menu, this.fLookupAction, selection);
        menu.add((IContributionItem)new Separator("emptyRenderGroup"));
        menu.add((IContributionItem)new Separator("renderGroup"));
        menu.add((IContributionItem)new Separator("propertyGroup"));
        PropertyDialogAction action = (PropertyDialogAction)this.getAction("Properties");
        TreeSelection sel = (TreeSelection)this.fProvider.getActiveContext();
        boolean enabled = true;
        if (sel != null && sel.size() > 0) {
            enabled = !(sel.getFirstElement() instanceof ILaunch);
        }
        action.setEnabled(action.isApplicableForSelection() && enabled);
        menu.add((IAction)action);
        menu.add((IContributionItem)new Separator("additions"));
        menu.appendToGroup("launchGroup", this.getAction(TERMINATE_AND_REMOVE));
        menu.appendToGroup("launchGroup", this.getAction(TERMINATE_ALL));
        menu.appendToGroup("threadGroup", this.getAction(RESUME));
        menu.appendToGroup("threadGroup", this.getAction(SUSPEND));
        menu.appendToGroup("threadGroup", this.getAction(TERMINATE));
        menu.appendToGroup("threadGroup", this.getAction(TERMINATE_AND_RELAUNCH));
        menu.appendToGroup("threadGroup", this.getAction(DISCONNECT));
        menu.appendToGroup("stepIntoGroup", this.getAction(STEP_INTO));
        menu.appendToGroup("stepOverGroup", this.getAction(STEP_OVER));
        menu.appendToGroup("stepReturnGroup", this.getAction(STEP_RETURN));
        menu.appendToGroup("emptyStepGroup", this.getAction(DROP_TO_FRAME));
        menu.appendToGroup("renderGroup", this.getAction(TOGGLE_STEP_FILTERS));
    }

    private void updateAndAdd(IMenuManager menu, SelectionListenerAction action, IStructuredSelection selection) {
        action.selectionChanged(selection);
        if (action.isEnabled()) {
            menu.add((IAction)action);
        }
    }

    protected void setActive(boolean active) {
        this.fIsActive = active;
    }

    protected boolean isActive() {
        return this.fIsActive && this.getViewer() != null;
    }

    public boolean show(ShowInContext context) {
        Object obj;
        IStructuredSelection ss;
        ISelection selection = context.getSelection();
        if (selection != null && selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1 && ((obj = ss.getFirstElement()) instanceof IDebugTarget || obj instanceof IProcess)) {
            Viewer viewer = this.getViewer();
            if (viewer instanceof InternalTreeModelViewer) {
                InternalTreeModelViewer tv = (InternalTreeModelViewer)viewer;
                tv.setSelection(selection, true, true);
            } else {
                viewer.setSelection(selection, true);
            }
            return true;
        }
        return false;
    }

    public ShowInContext getShowInContext() {
        Object object;
        IStructuredSelection selection;
        if (this.isActive() && (selection = (IStructuredSelection)this.getViewer().getSelection()).size() == 1 && (object = selection.getFirstElement()) instanceof IAdaptable) {
            IShowInSource show;
            IAdaptable adaptable = (IAdaptable)object;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.part.IShowInSource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((show = (IShowInSource)adaptable.getAdapter((Class)clazz)) != null) {
                return show.getShowInContext();
            }
        }
        return null;
    }

    public String[] getShowInTargetIds() {
        Object object;
        IStructuredSelection selection;
        if (this.isActive() && (selection = (IStructuredSelection)this.getViewer().getSelection()).size() == 1 && (object = selection.getFirstElement()) instanceof IAdaptable) {
            IShowInTargetList show;
            IAdaptable adaptable = (IAdaptable)object;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.ui.part.IShowInTargetList");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((show = (IShowInTargetList)adaptable.getAdapter((Class)clazz)) != null) {
                return show.getShowInTargetIds();
            }
        }
        return new String[0];
    }

    public void partClosed(IWorkbenchPartReference partRef) {
    }

    public void partVisible(IWorkbenchPartReference partRef) {
        IWorkbenchPart part = partRef.getPart(false);
        if (part == this) {
            this.setActive(true);
            this.getSite().getPage().showActionSet("org.eclipse.debug.ui.debugActionSet");
        }
    }

    public void partOpened(IWorkbenchPartReference partRef) {
    }

    public void partActivated(IWorkbenchPartReference partRef) {
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
    }

    public void partHidden(IWorkbenchPartReference partRef) {
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }

    protected void becomesVisible() {
        super.becomesVisible();
        this.getViewer().refresh();
    }

    public void updateComplete(IViewerUpdate update) {
    }

    public void updateStarted(IViewerUpdate update) {
    }

    public synchronized void viewerUpdatesBegin() {
        IWorkbenchSiteProgressService progressService;
        IWorkbenchPartSite iWorkbenchPartSite = this.getSite();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.ui.progress.IWorkbenchSiteProgressService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((progressService = (IWorkbenchSiteProgressService)iWorkbenchPartSite.getAdapter((Class)clazz)) != null) {
            progressService.incrementBusy();
        }
    }

    public synchronized void viewerUpdatesComplete() {
        IWorkbenchSiteProgressService progressService;
        IWorkbenchPartSite iWorkbenchPartSite = this.getSite();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.ui.progress.IWorkbenchSiteProgressService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((progressService = (IWorkbenchSiteProgressService)iWorkbenchPartSite.getAdapter((Class)clazz)) != null) {
            progressService.decrementBusy();
        }
    }

    class ContextProvider
    extends AbstractDebugContextProvider
    implements IModelChangedListener {
        private ISelection fContext = null;
        private TreeModelViewer fViewer = null;
        private Visitor fVisitor = new Visitor();

        private TreePath getViewerTreePath(IModelDelta node) {
            ArrayList<Object> list = new ArrayList<Object>();
            IModelDelta parentDelta = node.getParentDelta();
            while (parentDelta != null) {
                list.add(0, node.getElement());
                node = parentDelta;
                parentDelta = node.getParentDelta();
            }
            return new TreePath(list.toArray());
        }

        public ContextProvider(TreeModelViewer viewer) {
            super((IWorkbenchPart)LaunchView.this);
            this.fViewer = viewer;
            this.fViewer.addModelChangedListener(this);
        }

        protected void dispose() {
            this.fContext = null;
            this.fViewer.removeModelChangedListener(this);
        }

        public synchronized ISelection getActiveContext() {
            return this.fContext;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void activate(ISelection selection) {
            ContextProvider contextProvider = this;
            synchronized (contextProvider) {
                this.fContext = selection;
            }
            this.fire(new DebugContextEvent(this, selection, 1));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void possibleChange(TreePath element, int type) {
            DebugContextEvent event = null;
            ContextProvider contextProvider = this;
            synchronized (contextProvider) {
                TreePath current;
                ITreeSelection ss;
                if (this.fContext instanceof ITreeSelection && (ss = (ITreeSelection)this.fContext).size() == 1 && (current = ss.getPaths()[0]).startsWith(element, null)) {
                    event = current.getSegmentCount() == element.getSegmentCount() ? new DebugContextEvent(this, this.fContext, type) : new DebugContextEvent(this, this.fContext, 16);
                }
            }
            if (event == null) {
                return;
            }
            if (LaunchView.this.getControl().getDisplay().getThread() == Thread.currentThread()) {
                this.fire(event);
            } else {
                DebugContextEvent finalEvent = event;
                UIJob job = new UIJob(this, "context change", finalEvent){
                    final /* synthetic */ ContextProvider this$1;
                    private final /* synthetic */ DebugContextEvent val$finalEvent;
                    {
                        this.this$1 = contextProvider;
                        this.val$finalEvent = debugContextEvent;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        ContextProvider contextProvider = this.this$1;
                        synchronized (contextProvider) {
                            if (ContextProvider.access$1(this.this$1) instanceof IStructuredSelection) {
                                IStructuredSelection ss = (IStructuredSelection)ContextProvider.access$1(this.this$1);
                                Object changed = ((IStructuredSelection)this.val$finalEvent.getContext()).getFirstElement();
                                if (ss.size() != 1 || !ss.getFirstElement().equals(changed)) {
                                    return Status.OK_STATUS;
                                }
                            }
                        }
                        ContextProvider.access$2(this.this$1, this.val$finalEvent);
                        return Status.OK_STATUS;
                    }
                };
                job.setSystem(true);
                job.schedule();
            }
        }

        public void modelChanged(IModelDelta delta, IModelProxy proxy) {
            delta.accept(this.fVisitor);
        }

        static /* synthetic */ ISelection access$1(ContextProvider contextProvider) {
            return contextProvider.fContext;
        }

        static /* synthetic */ void access$2(ContextProvider contextProvider, DebugContextEvent debugContextEvent) {
            contextProvider.fire(debugContextEvent);
        }

        class Visitor
        implements IModelDeltaVisitor {
            Visitor() {
            }

            public boolean visit(IModelDelta delta, int depth) {
                if ((delta.getFlags() & 0xC00) > 0 && (delta.getFlags() & 0x200000) == 0) {
                    if ((delta.getFlags() & 0x400) > 0) {
                        ContextProvider.this.possibleChange(ContextProvider.this.getViewerTreePath(delta), 1);
                    } else if ((delta.getFlags() & 0x800) > 0) {
                        ContextProvider.this.possibleChange(ContextProvider.this.getViewerTreePath(delta), 16);
                    }
                }
                return true;
            }
        }
    }
}

