/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.model;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.AbstractDebugActionDelegate;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.internal.ui.viewers.model.ILabelUpdateListener;
import org.eclipse.debug.internal.ui.viewers.model.InternalTreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IViewPart;

public class VirtualCopyToClipboardActionDelegate
extends AbstractDebugActionDelegate {
    private ContentViewer fViewer;
    private static final String TAB = "\t";
    private static final String EMPTY_STRING = "";
    private static final String SEPARATOR = "line.separator";
    private boolean fDone = false;
    static /* synthetic */ Class class$0;

    protected boolean initialize(IAction action, ISelection selection) {
        if (!this.isInitialized()) {
            IDebugView adapter;
            IViewPart iViewPart = this.getView();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.debug.ui.IDebugView");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((adapter = (IDebugView)iViewPart.getAdapter((Class)clazz)) != null) {
                if (adapter.getViewer() instanceof ContentViewer) {
                    this.setViewer((ContentViewer)adapter.getViewer());
                }
                adapter.setAction(this.getActionId(), action);
            }
            return super.initialize(action, selection);
        }
        return false;
    }

    protected String getActionId() {
        return IDebugView.COPY_ACTION;
    }

    protected void append(TreeItem item, StringBuffer buffer, int indent) {
        int i = 0;
        while (i < indent) {
            buffer.append(TAB);
            ++i;
        }
        String[] labels = null;
        if (((InternalTreeModelViewer)this.fViewer).isShowColumns()) {
            labels = new String[((InternalTreeModelViewer)this.fViewer).getPresentationContext().getColumns().length];
            int i2 = 0;
            while (i2 < labels.length) {
                labels[i2] = item.getText(i2);
                ++i2;
            }
        } else {
            labels = new String[]{item.getText()};
        }
        int count = labels.length;
        if (count > 0) {
            int i3 = 0;
            while (i3 < count) {
                String text = labels[i3];
                if (text != null && !text.trim().equals(EMPTY_STRING)) {
                    buffer.append(String.valueOf(text) + TAB);
                }
                ++i3;
            }
            buffer.append(System.getProperty(SEPARATOR));
        }
    }

    public void run(IAction action) {
        if (this.fViewer instanceof InternalTreeModelViewer) {
            InternalTreeModelViewer viewer = (InternalTreeModelViewer)this.fViewer;
            this.fDone = false;
            final Object lock = new Object();
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.fViewer.getControl().getShell());
            final IProgressMonitor monitor = dialog.getProgressMonitor();
            dialog.setCancelable(true);
            boolean queued = false;
            ILabelUpdateListener listener = new ILabelUpdateListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void labelUpdatesComplete() {
                    Object object = lock;
                    synchronized (object) {
                        VirtualCopyToClipboardActionDelegate.this.fDone = true;
                        lock.notifyAll();
                    }
                }

                public void labelUpdatesBegin() {
                }

                public void labelUpdateStarted(ILabelUpdate update) {
                }

                public void labelUpdateComplete(ILabelUpdate update) {
                    monitor.worked(1);
                }
            };
            viewer.addLabelUpdateListener(listener);
            queued = viewer.populateVitrualItems();
            if (queued) {
                IRunnableWithProgress runnable = new IRunnableWithProgress(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run(IProgressMonitor m) throws InvocationTargetException, InterruptedException {
                        m.beginTask(DebugUIPlugin.removeAccelerators(VirtualCopyToClipboardActionDelegate.this.getAction().getText()), -1);
                        Object object = lock;
                        synchronized (object) {
                            if (!VirtualCopyToClipboardActionDelegate.this.fDone) {
                                lock.wait();
                            }
                        }
                        m.done();
                    }
                };
                try {
                    dialog.run(true, true, runnable);
                }
                catch (InvocationTargetException e) {
                    DebugUIPlugin.log(e);
                    return;
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
            viewer.removeLabelUpdateListener(listener);
            if (!monitor.isCanceled()) {
                List roots = this.getPrunedSelection();
                Iterator iterator = roots.iterator();
                StringBuffer buffer = new StringBuffer();
                while (iterator.hasNext()) {
                    TreeItem item = (TreeItem)iterator.next();
                    this.copy(item, buffer, 0);
                }
                TextTransfer plainTextTransfer = TextTransfer.getInstance();
                Clipboard clipboard = new Clipboard(this.fViewer.getControl().getDisplay());
                try {
                    this.doCopy(clipboard, plainTextTransfer, buffer);
                }
                finally {
                    clipboard.dispose();
                }
            }
        }
    }

    protected void copy(TreeItem item, StringBuffer buffer, int indent) {
        this.append(item, buffer, indent);
        if (item.getExpanded()) {
            TreeItem[] items = item.getItems();
            int i = 0;
            while (i < items.length) {
                this.copy(items[i], buffer, indent + 1);
                ++i;
            }
        }
    }

    protected void doCopy(Clipboard clipboard, TextTransfer plainTextTransfer, StringBuffer buffer) {
        block3: {
            try {
                clipboard.setContents((Object[])new String[]{buffer.toString()}, new Transfer[]{plainTextTransfer});
            }
            catch (SWTError e) {
                if (e.code != 2002) {
                    throw e;
                }
                if (!MessageDialog.openQuestion((Shell)this.fViewer.getControl().getShell(), (String)ActionMessages.CopyToClipboardActionDelegate_Problem_Copying_to_Clipboard_1, (String)ActionMessages.CopyToClipboardActionDelegate_There_was_a_problem_when_accessing_the_system_clipboard__Retry__2)) break block3;
                this.doCopy(clipboard, plainTextTransfer, buffer);
            }
        }
    }

    protected List getPrunedSelection() {
        Control control = this.fViewer.getControl();
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        if (control instanceof Tree) {
            Tree tree = (Tree)control;
            TreeItem[] selection = tree.getSelection();
            int i = 0;
            while (i < selection.length) {
                TreeItem item = selection[i];
                if (this.isEnabledFor(item.getData()) && this.walkHierarchy(item, items)) {
                    items.add(item);
                }
                ++i;
            }
        }
        return items;
    }

    protected boolean walkHierarchy(TreeItem item, List elements) {
        TreeItem parent = item.getParentItem();
        if (parent == null) {
            return true;
        }
        if (elements.contains(parent)) {
            return false;
        }
        return this.walkHierarchy(parent, elements);
    }

    protected ContentViewer getViewer() {
        return this.fViewer;
    }

    protected void setViewer(ContentViewer viewer) {
        this.fViewer = viewer;
    }

    protected void doAction(Object element) {
    }
}

