/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.bimap.mutable;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.collections.api.BooleanIterable;
import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.sorted.MutableSortedBag;
import org.eclipse.collections.api.bimap.ImmutableBiMap;
import org.eclipse.collections.api.bimap.MutableBiMap;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleObjectToDoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.FloatObjectToFloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.IntObjectToIntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.LongObjectToLongFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.collection.primitive.MutableBooleanCollection;
import org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import org.eclipse.collections.api.collection.primitive.MutableDoubleCollection;
import org.eclipse.collections.api.collection.primitive.MutableFloatCollection;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.collection.primitive.MutableShortCollection;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.map.primitive.MutableObjectDoubleMap;
import org.eclipse.collections.api.map.primitive.MutableObjectLongMap;
import org.eclipse.collections.api.map.sorted.MutableSortedMap;
import org.eclipse.collections.api.multimap.MutableMultimap;
import org.eclipse.collections.api.multimap.set.MutableSetMultimap;
import org.eclipse.collections.api.partition.set.PartitionMutableSet;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.set.sorted.MutableSortedSet;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.UnmodifiableIteratorAdapter;
import org.eclipse.collections.impl.bimap.mutable.HashBiMap;
import org.eclipse.collections.impl.bimap.mutable.SynchronizedBiMap;

public class UnmodifiableBiMap<K, V>
implements MutableBiMap<K, V>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final MutableBiMap<K, V> delegate;

    public UnmodifiableBiMap(MutableBiMap<K, V> delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException("Cannot create an UnmodifiableBiMap for null");
        }
        this.delegate = delegate;
    }

    public static <K, V> UnmodifiableBiMap<K, V> of(MutableBiMap<K, V> biMap) {
        return new UnmodifiableBiMap<K, V>(biMap);
    }

    public static <K, V> UnmodifiableBiMap<K, V> of(Map<K, V> map) {
        if (map == null) {
            throw new IllegalArgumentException("cannot create a UnmodifiableBiMap for null");
        }
        return new UnmodifiableBiMap<K, V>(new HashBiMap<K, V>(map));
    }

    public MutableBiMap<K, V> newEmpty() {
        return this.delegate.newEmpty();
    }

    public MutableBiMap<V, K> inverse() {
        return this.delegate.inverse().asUnmodifiable();
    }

    public V getIfAbsent(K key, Function0<? extends V> function) {
        return (V)this.delegate.getIfAbsent(key, function);
    }

    public V getIfAbsentValue(K key, V value) {
        return (V)this.delegate.getIfAbsentValue(key, value);
    }

    public <P> V getIfAbsentWith(K key, Function<? super P, ? extends V> function, P parameter) {
        return (V)this.delegate.getIfAbsentWith(key, function, parameter);
    }

    public <A> A ifPresentApply(K key, Function<? super V, ? extends A> function) {
        return (A)this.delegate.ifPresentApply(key, function);
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return this.delegate.toString();
    }

    public Set<Map.Entry<K, V>> entrySet() {
        return Collections.unmodifiableMap(this.delegate).entrySet();
    }

    public Set<K> keySet() {
        return Collections.unmodifiableSet(this.delegate.keySet());
    }

    public Collection<V> values() {
        return Collections.unmodifiableCollection(this.delegate.values());
    }

    public RichIterable<K> keysView() {
        return this.delegate.keysView();
    }

    public RichIterable<V> valuesView() {
        return this.delegate.valuesView();
    }

    public RichIterable<Pair<K, V>> keyValuesView() {
        return this.delegate.keyValuesView();
    }

    public Iterator<V> iterator() {
        return new UnmodifiableIteratorAdapter(this.delegate.iterator());
    }

    public V get(Object key) {
        return (V)this.delegate.get(key);
    }

    public V getFirst() {
        return (V)this.delegate.getFirst();
    }

    public V getLast() {
        return (V)this.delegate.getLast();
    }

    public V getOnly() {
        return (V)this.delegate.getOnly();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public boolean notEmpty() {
        return this.delegate.notEmpty();
    }

    public boolean contains(Object object) {
        return this.delegate.contains(object);
    }

    public boolean containsAllIterable(Iterable<?> source) {
        return this.delegate.containsAllIterable(source);
    }

    public boolean containsAll(Collection<?> source) {
        return this.delegate.containsAll(source);
    }

    public boolean containsAllArguments(Object ... elements) {
        return this.delegate.containsAllArguments(elements);
    }

    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    public MutableSetMultimap<V, K> flip() {
        return this.delegate.flip();
    }

    public MutableBiMap<V, K> flipUniqueValues() {
        return this.delegate.flipUniqueValues();
    }

    public MutableBiMap<K, V> clone() {
        return this;
    }

    public LazyIterable<V> asLazy() {
        return this.delegate.asLazy();
    }

    public MutableBiMap<K, V> asSynchronized() {
        return SynchronizedBiMap.of(this);
    }

    public MutableBiMap<K, V> asUnmodifiable() {
        return this;
    }

    public MutableBiMap<K, V> tap(Procedure<? super V> procedure) {
        this.forEach(procedure);
        return this;
    }

    public void each(Procedure<? super V> procedure) {
        this.delegate.each(procedure);
    }

    public void forEach(Procedure<? super V> procedure) {
        this.each(procedure);
    }

    public void forEachWithIndex(ObjectIntProcedure<? super V> objectIntProcedure) {
        this.delegate.forEachWithIndex(objectIntProcedure);
    }

    public <P> void forEachWith(Procedure2<? super V, ? super P> procedure, P parameter) {
        this.delegate.forEachWith(procedure, parameter);
    }

    public void forEachKey(Procedure<? super K> procedure) {
        this.delegate.forEachKey(procedure);
    }

    public void forEachValue(Procedure<? super V> procedure) {
        this.delegate.forEachValue(procedure);
    }

    public void forEachKeyValue(Procedure2<? super K, ? super V> procedure) {
        this.delegate.forEachKeyValue(procedure);
    }

    public MutableBiMap<K, V> select(Predicate2<? super K, ? super V> predicate) {
        return this.delegate.select(predicate);
    }

    public MutableSet<V> select(Predicate<? super V> predicate) {
        return this.delegate.select(predicate);
    }

    public <R extends Collection<V>> R select(Predicate<? super V> predicate, R target) {
        return (R)this.delegate.select(predicate, target);
    }

    public <P> MutableSet<V> selectWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return this.delegate.selectWith(predicate, parameter);
    }

    public <P, R extends Collection<V>> R selectWith(Predicate2<? super V, ? super P> predicate, P parameter, R targetCollection) {
        return (R)this.delegate.selectWith(predicate, parameter, targetCollection);
    }

    public MutableBiMap<K, V> reject(Predicate2<? super K, ? super V> predicate) {
        return this.delegate.reject(predicate);
    }

    public MutableSet<V> reject(Predicate<? super V> predicate) {
        return this.delegate.reject(predicate);
    }

    public <R extends Collection<V>> R reject(Predicate<? super V> predicate, R target) {
        return (R)this.delegate.reject(predicate, target);
    }

    public <P> MutableSet<V> rejectWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return this.delegate.rejectWith(predicate, parameter);
    }

    public <P, R extends Collection<V>> R rejectWith(Predicate2<? super V, ? super P> predicate, P parameter, R targetCollection) {
        return (R)this.delegate.rejectWith(predicate, parameter, targetCollection);
    }

    public PartitionMutableSet<V> partition(Predicate<? super V> predicate) {
        return this.delegate.partition(predicate);
    }

    public <P> PartitionMutableSet<V> partitionWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return this.delegate.partitionWith(predicate, parameter);
    }

    public <S> MutableSet<S> selectInstancesOf(Class<S> clazz) {
        return this.delegate.selectInstancesOf(clazz);
    }

    public Pair<K, V> detect(Predicate2<? super K, ? super V> predicate) {
        return this.delegate.detect(predicate);
    }

    public V detect(Predicate<? super V> predicate) {
        return (V)this.delegate.detect(predicate);
    }

    public <P> V detectWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return (V)this.delegate.detectWith(predicate, parameter);
    }

    public Optional<Pair<K, V>> detectOptional(Predicate2<? super K, ? super V> predicate) {
        return this.delegate.detectOptional(predicate);
    }

    public Optional<V> detectOptional(Predicate<? super V> predicate) {
        return this.delegate.detectOptional(predicate);
    }

    public <P> Optional<V> detectWithOptional(Predicate2<? super V, ? super P> predicate, P parameter) {
        return this.delegate.detectWithOptional(predicate, parameter);
    }

    public V detectIfNone(Predicate<? super V> predicate, Function0<? extends V> function) {
        return (V)this.delegate.detectIfNone(predicate, function);
    }

    public <P> V detectWithIfNone(Predicate2<? super V, ? super P> predicate, P parameter, Function0<? extends V> function) {
        return (V)this.delegate.detectWithIfNone(predicate, parameter, function);
    }

    public int count(Predicate<? super V> predicate) {
        return this.delegate.count(predicate);
    }

    public <P> int countWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return this.delegate.countWith(predicate, parameter);
    }

    public boolean anySatisfy(Predicate<? super V> predicate) {
        return this.delegate.anySatisfy(predicate);
    }

    public <P> boolean anySatisfyWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return this.delegate.anySatisfyWith(predicate, parameter);
    }

    public boolean allSatisfy(Predicate<? super V> predicate) {
        return this.delegate.allSatisfy(predicate);
    }

    public <P> boolean allSatisfyWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return this.delegate.allSatisfyWith(predicate, parameter);
    }

    public boolean noneSatisfy(Predicate<? super V> predicate) {
        return this.delegate.noneSatisfy(predicate);
    }

    public <P> boolean noneSatisfyWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return this.delegate.noneSatisfyWith(predicate, parameter);
    }

    public <K2, V2> MutableBiMap<K2, V2> collect(Function2<? super K, ? super V, Pair<K2, V2>> function) {
        return this.delegate.collect(function);
    }

    public <V1> RichIterable<V1> collect(Function<? super V, ? extends V1> function) {
        return this.delegate.collect(function);
    }

    public <VV, R extends Collection<VV>> R collect(Function<? super V, ? extends VV> function, R target) {
        return (R)this.delegate.collect(function, target);
    }

    public <P, V1> RichIterable<V1> collectWith(Function2<? super V, ? super P, ? extends V1> function, P parameter) {
        return this.delegate.collectWith(function, parameter);
    }

    public <P, VV, R extends Collection<VV>> R collectWith(Function2<? super V, ? super P, ? extends VV> function, P parameter, R targetCollection) {
        return (R)this.delegate.collectWith(function, parameter, targetCollection);
    }

    public <R> MutableBiMap<K, R> collectValues(Function2<? super K, ? super V, ? extends R> function) {
        return this.delegate.collectValues(function);
    }

    public BooleanIterable collectBoolean(BooleanFunction<? super V> booleanFunction) {
        return this.delegate.collectBoolean(booleanFunction);
    }

    public <R extends MutableBooleanCollection> R collectBoolean(BooleanFunction<? super V> booleanFunction, R target) {
        return (R)this.delegate.collectBoolean(booleanFunction, target);
    }

    public ByteIterable collectByte(ByteFunction<? super V> byteFunction) {
        return this.delegate.collectByte(byteFunction);
    }

    public <R extends MutableByteCollection> R collectByte(ByteFunction<? super V> byteFunction, R target) {
        return (R)this.delegate.collectByte(byteFunction, target);
    }

    public CharIterable collectChar(CharFunction<? super V> charFunction) {
        return this.delegate.collectChar(charFunction);
    }

    public <R extends MutableCharCollection> R collectChar(CharFunction<? super V> charFunction, R target) {
        return (R)this.delegate.collectChar(charFunction, target);
    }

    public DoubleIterable collectDouble(DoubleFunction<? super V> doubleFunction) {
        return this.delegate.collectDouble(doubleFunction);
    }

    public <R extends MutableDoubleCollection> R collectDouble(DoubleFunction<? super V> doubleFunction, R target) {
        return (R)this.delegate.collectDouble(doubleFunction, target);
    }

    public FloatIterable collectFloat(FloatFunction<? super V> floatFunction) {
        return this.delegate.collectFloat(floatFunction);
    }

    public <R extends MutableFloatCollection> R collectFloat(FloatFunction<? super V> floatFunction, R target) {
        return (R)this.delegate.collectFloat(floatFunction, target);
    }

    public IntIterable collectInt(IntFunction<? super V> intFunction) {
        return this.delegate.collectInt(intFunction);
    }

    public <R extends MutableIntCollection> R collectInt(IntFunction<? super V> intFunction, R target) {
        return (R)this.delegate.collectInt(intFunction, target);
    }

    public LongIterable collectLong(LongFunction<? super V> longFunction) {
        return this.delegate.collectLong(longFunction);
    }

    public <R extends MutableLongCollection> R collectLong(LongFunction<? super V> longFunction, R target) {
        return (R)this.delegate.collectLong(longFunction, target);
    }

    public ShortIterable collectShort(ShortFunction<? super V> shortFunction) {
        return this.delegate.collectShort(shortFunction);
    }

    public <R extends MutableShortCollection> R collectShort(ShortFunction<? super V> shortFunction, R target) {
        return (R)this.delegate.collectShort(shortFunction, target);
    }

    public <V1> RichIterable<V1> collectIf(Predicate<? super V> predicate, Function<? super V, ? extends V1> function) {
        return this.delegate.collectIf(predicate, function);
    }

    public <VV, R extends Collection<VV>> R collectIf(Predicate<? super V> predicate, Function<? super V, ? extends VV> function, R target) {
        return (R)this.delegate.collectIf(predicate, function, target);
    }

    public <V1> RichIterable<V1> flatCollect(Function<? super V, ? extends Iterable<V1>> function) {
        return this.delegate.flatCollect(function);
    }

    public <VV, R extends Collection<VV>> R flatCollect(Function<? super V, ? extends Iterable<VV>> function, R target) {
        return (R)this.delegate.flatCollect(function, target);
    }

    public <IV> IV injectInto(IV injectedValue, Function2<? super IV, ? super V, ? extends IV> function) {
        return (IV)this.delegate.injectInto(injectedValue, function);
    }

    public int injectInto(int injectedValue, IntObjectToIntFunction<? super V> function) {
        return this.delegate.injectInto(injectedValue, function);
    }

    public long injectInto(long injectedValue, LongObjectToLongFunction<? super V> function) {
        return this.delegate.injectInto(injectedValue, function);
    }

    public float injectInto(float injectedValue, FloatObjectToFloatFunction<? super V> function) {
        return this.delegate.injectInto(injectedValue, function);
    }

    public double injectInto(double injectedValue, DoubleObjectToDoubleFunction<? super V> function) {
        return this.delegate.injectInto(injectedValue, function);
    }

    public <R extends Collection<V>> R into(R target) {
        return (R)this.delegate.into(target);
    }

    public ImmutableBiMap<K, V> toImmutable() {
        return this.delegate.toImmutable();
    }

    public MutableList<V> toList() {
        return this.delegate.toList();
    }

    public MutableList<V> toSortedList() {
        return this.delegate.toSortedList();
    }

    public MutableList<V> toSortedList(Comparator<? super V> comparator) {
        return this.delegate.toSortedList(comparator);
    }

    public <VV extends Comparable<? super VV>> MutableList<V> toSortedListBy(Function<? super V, ? extends VV> function) {
        return this.delegate.toSortedListBy(function);
    }

    public MutableSet<V> toSet() {
        return this.delegate.toSet();
    }

    public MutableSortedSet<V> toSortedSet() {
        return this.delegate.toSortedSet();
    }

    public MutableSortedSet<V> toSortedSet(Comparator<? super V> comparator) {
        return this.delegate.toSortedSet(comparator);
    }

    public <VV extends Comparable<? super VV>> MutableSortedSet<V> toSortedSetBy(Function<? super V, ? extends VV> function) {
        return this.delegate.toSortedSetBy(function);
    }

    public MutableBag<V> toBag() {
        return this.delegate.toBag();
    }

    public MutableSortedBag<V> toSortedBag() {
        return this.delegate.toSortedBag();
    }

    public MutableSortedBag<V> toSortedBag(Comparator<? super V> comparator) {
        return this.delegate.toSortedBag(comparator);
    }

    public <VV extends Comparable<? super VV>> MutableSortedBag<V> toSortedBagBy(Function<? super V, ? extends VV> function) {
        return this.delegate.toSortedBagBy(function);
    }

    public <NK, NV> MutableMap<NK, NV> toMap(Function<? super V, ? extends NK> keyFunction, Function<? super V, ? extends NV> valueFunction) {
        return this.delegate.toMap(keyFunction, valueFunction);
    }

    public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Function<? super V, ? extends NK> keyFunction, Function<? super V, ? extends NV> valueFunction) {
        return this.delegate.toSortedMap(keyFunction, valueFunction);
    }

    public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Comparator<? super NK> comparator, Function<? super V, ? extends NK> keyFunction, Function<? super V, ? extends NV> valueFunction) {
        return this.delegate.toSortedMap(comparator, keyFunction, valueFunction);
    }

    public <KK extends Comparable<? super KK>, NK, NV> MutableSortedMap<NK, NV> toSortedMapBy(Function<? super NK, KK> sortBy, Function<? super V, ? extends NK> keyFunction, Function<? super V, ? extends NV> valueFunction) {
        return this.delegate.toSortedMapBy(sortBy, keyFunction, valueFunction);
    }

    public Object[] toArray() {
        return this.delegate.toArray();
    }

    public <T> T[] toArray(T[] target) {
        return this.delegate.toArray((Object[])target);
    }

    public V min(Comparator<? super V> comparator) {
        return (V)this.delegate.min(comparator);
    }

    public V min() {
        return (V)this.delegate.min();
    }

    public <VV extends Comparable<? super VV>> V minBy(Function<? super V, ? extends VV> function) {
        return (V)this.delegate.minBy(function);
    }

    public V max(Comparator<? super V> comparator) {
        return (V)this.delegate.max(comparator);
    }

    public V max() {
        return (V)this.delegate.max();
    }

    public <VV extends Comparable<? super VV>> V maxBy(Function<? super V, ? extends VV> function) {
        return (V)this.delegate.maxBy(function);
    }

    public long sumOfInt(IntFunction<? super V> function) {
        return this.delegate.sumOfInt(function);
    }

    public double sumOfFloat(FloatFunction<? super V> function) {
        return this.delegate.sumOfFloat(function);
    }

    public long sumOfLong(LongFunction<? super V> function) {
        return this.delegate.sumOfLong(function);
    }

    public double sumOfDouble(DoubleFunction<? super V> function) {
        return this.delegate.sumOfDouble(function);
    }

    public <V1> MutableObjectLongMap<V1> sumByInt(Function<? super V, ? extends V1> groupBy, IntFunction<? super V> function) {
        return this.delegate.sumByInt(groupBy, function);
    }

    public <V1> MutableObjectDoubleMap<V1> sumByFloat(Function<? super V, ? extends V1> groupBy, FloatFunction<? super V> function) {
        return this.delegate.sumByFloat(groupBy, function);
    }

    public <V1> MutableObjectLongMap<V1> sumByLong(Function<? super V, ? extends V1> groupBy, LongFunction<? super V> function) {
        return this.delegate.sumByLong(groupBy, function);
    }

    public <V1> MutableObjectDoubleMap<V1> sumByDouble(Function<? super V, ? extends V1> groupBy, DoubleFunction<? super V> function) {
        return this.delegate.sumByDouble(groupBy, function);
    }

    public String makeString() {
        return this.delegate.makeString();
    }

    public String makeString(String separator) {
        return this.delegate.makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.delegate.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.delegate.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.delegate.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.appendString(appendable, start, separator, end);
    }

    public <S> MutableSet<Pair<V, S>> zip(Iterable<S> that) {
        return this.delegate.zip(that);
    }

    public <S, R extends Collection<Pair<V, S>>> R zip(Iterable<S> that, R target) {
        return (R)this.delegate.zip(that, target);
    }

    public MutableSet<Pair<V, Integer>> zipWithIndex() {
        return this.delegate.zipWithIndex();
    }

    public <R extends Collection<Pair<V, Integer>>> R zipWithIndex(R target) {
        return (R)this.delegate.zipWithIndex(target);
    }

    public RichIterable<RichIterable<V>> chunk(int size) {
        return this.delegate.chunk(size);
    }

    public <K, V1> MutableMap<K, V1> aggregateInPlaceBy(Function<? super V, ? extends K> groupBy, Function0<? extends V1> zeroValueFactory, Procedure2<? super V1, ? super V> mutatingAggregator) {
        return this.delegate.aggregateInPlaceBy(groupBy, zeroValueFactory, mutatingAggregator);
    }

    public <K, V1> MutableMap<K, V1> aggregateBy(Function<? super V, ? extends K> groupBy, Function0<? extends V1> zeroValueFactory, Function2<? super V1, ? super V, ? extends V1> nonMutatingAggregator) {
        return this.delegate.aggregateBy(groupBy, zeroValueFactory, nonMutatingAggregator);
    }

    public <V1> MutableSetMultimap<V1, V> groupBy(Function<? super V, ? extends V1> function) {
        return this.delegate.groupBy(function);
    }

    public <VV, R extends MutableMultimap<VV, V>> R groupBy(Function<? super V, ? extends VV> function, R target) {
        return (R)this.delegate.groupBy(function, target);
    }

    public <V1> MutableSetMultimap<V1, V> groupByEach(Function<? super V, ? extends Iterable<V1>> function) {
        return this.delegate.groupByEach(function);
    }

    public <VV, R extends MutableMultimap<VV, V>> R groupByEach(Function<? super V, ? extends Iterable<VV>> function, R target) {
        return (R)this.delegate.groupByEach(function, target);
    }

    public <VV> MutableBiMap<VV, V> groupByUniqueKey(Function<? super V, ? extends VV> function) {
        return this.delegate.groupByUniqueKey(function);
    }

    public <VV, R extends MutableMap<VV, V>> R groupByUniqueKey(Function<? super V, ? extends VV> function, R target) {
        return (R)this.delegate.groupByUniqueKey(function, target);
    }

    public V put(K key, V value) {
        throw new UnsupportedOperationException("Cannot call put() on " + this.getClass().getSimpleName());
    }

    public void putAll(Map<? extends K, ? extends V> m) {
        throw new UnsupportedOperationException("Cannot call putAll() on " + this.getClass().getSimpleName());
    }

    public V forcePut(K key, V value) {
        throw new UnsupportedOperationException("Cannot call forcePut() on " + this.getClass().getSimpleName());
    }

    public V putPair(Pair<K, V> keyValuePair) {
        throw new UnsupportedOperationException("Cannot call putPair() on " + this.getClass().getSimpleName());
    }

    public V add(Pair<K, V> keyValuePair) {
        throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
    }

    public V remove(Object key) {
        throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
    }

    public V removeKey(K key) {
        throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
    }

    public void clear() {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    public V getIfAbsentPut(K key, Function0<? extends V> function) {
        throw new UnsupportedOperationException("Cannot call getIfAbsentPut() on " + this.getClass().getSimpleName());
    }

    public V getIfAbsentPut(K key, V value) {
        throw new UnsupportedOperationException("Cannot call getIfAbsentPut() on " + this.getClass().getSimpleName());
    }

    public V getIfAbsentPutWithKey(K key, Function<? super K, ? extends V> function) {
        throw new UnsupportedOperationException("Cannot call getIfAbsentPutWithKey() on " + this.getClass().getSimpleName());
    }

    public <P> V getIfAbsentPutWith(K key, Function<? super P, ? extends V> function, P parameter) {
        throw new UnsupportedOperationException("Cannot call getIfAbsentPutWith() on " + this.getClass().getSimpleName());
    }

    public V updateValue(K key, Function0<? extends V> factory, Function<? super V, ? extends V> function) {
        throw new UnsupportedOperationException("Cannot call updateValue() on " + this.getClass().getSimpleName());
    }

    public <P> V updateValueWith(K key, Function0<? extends V> factory, Function2<? super V, ? super P, ? extends V> function, P parameter) {
        throw new UnsupportedOperationException("Cannot call updateValueWith() on " + this.getClass().getSimpleName());
    }

    public MutableBiMap<K, V> withKeyValue(K key, V value) {
        throw new UnsupportedOperationException("Cannot call withKeyValue() on " + this.getClass().getSimpleName());
    }

    public MutableBiMap<K, V> withAllKeyValues(Iterable<? extends Pair<? extends K, ? extends V>> keyValues) {
        throw new UnsupportedOperationException("Cannot call withAllKeyValues() on " + this.getClass().getSimpleName());
    }

    public MutableBiMap<K, V> withAllKeyValueArguments(Pair<? extends K, ? extends V> ... keyValuePairs) {
        throw new UnsupportedOperationException("Cannot call keyValuePairs() on " + this.getClass().getSimpleName());
    }

    public MutableBiMap<K, V> withoutKey(K key) {
        throw new UnsupportedOperationException("Cannot call withoutKey() on " + this.getClass().getSimpleName());
    }

    public MutableBiMap<K, V> withoutAllKeys(Iterable<? extends K> keys) {
        throw new UnsupportedOperationException("Cannot call withoutAllKeys() on " + this.getClass().getSimpleName());
    }
}

