/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable.primitive;

import java.io.Serializable;
import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.LazyFloatIterable;
import org.eclipse.collections.api.LazyShortIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.primitive.MutableShortBag;
import org.eclipse.collections.api.block.function.primitive.FloatToShortFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectShortToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction0;
import org.eclipse.collections.api.block.function.primitive.ShortToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ShortToShortFunction;
import org.eclipse.collections.api.block.predicate.primitive.FloatShortPredicate;
import org.eclipse.collections.api.block.predicate.primitive.ShortPredicate;
import org.eclipse.collections.api.block.procedure.primitive.FloatProcedure;
import org.eclipse.collections.api.block.procedure.primitive.FloatShortProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ShortProcedure;
import org.eclipse.collections.api.collection.primitive.MutableShortCollection;
import org.eclipse.collections.api.iterator.MutableShortIterator;
import org.eclipse.collections.api.iterator.ShortIterator;
import org.eclipse.collections.api.list.primitive.MutableShortList;
import org.eclipse.collections.api.map.primitive.FloatShortMap;
import org.eclipse.collections.api.map.primitive.ImmutableFloatShortMap;
import org.eclipse.collections.api.map.primitive.MutableFloatShortMap;
import org.eclipse.collections.api.map.primitive.MutableShortFloatMap;
import org.eclipse.collections.api.set.primitive.MutableFloatSet;
import org.eclipse.collections.api.set.primitive.MutableShortSet;
import org.eclipse.collections.api.tuple.primitive.FloatShortPair;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableShortCollection;
import org.eclipse.collections.impl.factory.primitive.FloatShortMaps;
import org.eclipse.collections.impl.iterator.UnmodifiableShortIterator;
import org.eclipse.collections.impl.map.mutable.primitive.SynchronizedFloatShortMap;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableFloatSet;

public final class UnmodifiableFloatShortMap
implements MutableFloatShortMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableFloatShortMap map;

    public UnmodifiableFloatShortMap(MutableFloatShortMap map) {
        if (map == null) {
            throw new IllegalArgumentException("Cannot create a UnmodifiableFloatShortMap on a null map");
        }
        this.map = map;
    }

    public void clear() {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    public void put(float key, short value) {
        throw new UnsupportedOperationException("Cannot call put() on " + this.getClass().getSimpleName());
    }

    public void putPair(FloatShortPair keyValuePair) {
        throw new UnsupportedOperationException("Cannot call putPair() on " + this.getClass().getSimpleName());
    }

    public void putAll(FloatShortMap map) {
        throw new UnsupportedOperationException("Cannot call putAll() on " + this.getClass().getSimpleName());
    }

    public void removeKey(float key) {
        throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
    }

    public void remove(float key) {
        throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
    }

    public short removeKeyIfAbsent(float key, short value) {
        if (this.map.containsKey(key)) {
            throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
        }
        return value;
    }

    public short getIfAbsentPut(float key, short value) {
        return this.map.getIfAbsentPut(key, (ShortFunction0 & Serializable)() -> {
            throw new UnsupportedOperationException();
        });
    }

    public short getIfAbsentPut(float key, ShortFunction0 function) {
        return this.map.getIfAbsentPut(key, (ShortFunction0 & Serializable)() -> {
            throw new UnsupportedOperationException();
        });
    }

    public short getIfAbsentPutWithKey(float key, FloatToShortFunction function) {
        return this.map.getIfAbsentPut(key, (ShortFunction0 & Serializable)() -> {
            throw new UnsupportedOperationException();
        });
    }

    public <P> short getIfAbsentPutWith(float key, ShortFunction<? super P> function, P parameter) {
        return this.map.getIfAbsentPut(key, (ShortFunction0 & Serializable)() -> {
            throw new UnsupportedOperationException();
        });
    }

    public short updateValue(float key, short initialValueIfAbsent, ShortToShortFunction function) {
        throw new UnsupportedOperationException("Cannot call updateValue() on " + this.getClass().getSimpleName());
    }

    public short get(float key) {
        return this.map.get(key);
    }

    public short getIfAbsent(float key, short ifAbsent) {
        return this.map.getIfAbsent(key, ifAbsent);
    }

    public short getOrThrow(float key) {
        return this.map.getOrThrow(key);
    }

    public boolean containsKey(float key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(short value) {
        return this.map.containsValue(value);
    }

    public void forEachValue(ShortProcedure procedure) {
        this.map.forEachValue(procedure);
    }

    public void forEachKey(FloatProcedure procedure) {
        this.map.forEachKey(procedure);
    }

    public void forEachKeyValue(FloatShortProcedure procedure) {
        this.map.forEachKeyValue(procedure);
    }

    public LazyFloatIterable keysView() {
        return this.map.keysView();
    }

    public RichIterable<FloatShortPair> keyValuesView() {
        return this.map.keyValuesView();
    }

    public MutableShortFloatMap flipUniqueValues() {
        return this.map.flipUniqueValues().asUnmodifiable();
    }

    public MutableFloatShortMap select(FloatShortPredicate predicate) {
        return this.map.select(predicate);
    }

    public MutableFloatShortMap reject(FloatShortPredicate predicate) {
        return this.map.reject(predicate);
    }

    public MutableShortIterator shortIterator() {
        return new UnmodifiableShortIterator((ShortIterator)this.map.shortIterator());
    }

    public void forEach(ShortProcedure procedure) {
        this.each(procedure);
    }

    public void each(ShortProcedure procedure) {
        this.map.forEach(procedure);
    }

    public int count(ShortPredicate predicate) {
        return this.map.count(predicate);
    }

    public boolean anySatisfy(ShortPredicate predicate) {
        return this.map.anySatisfy(predicate);
    }

    public boolean allSatisfy(ShortPredicate predicate) {
        return this.map.allSatisfy(predicate);
    }

    public boolean noneSatisfy(ShortPredicate predicate) {
        return this.map.noneSatisfy(predicate);
    }

    public MutableShortBag select(ShortPredicate predicate) {
        return this.map.select(predicate);
    }

    public MutableShortBag reject(ShortPredicate predicate) {
        return this.map.reject(predicate);
    }

    public <V> MutableBag<V> collect(ShortToObjectFunction<? extends V> function) {
        return this.map.collect(function);
    }

    public short detectIfNone(ShortPredicate predicate, short ifNone) {
        return this.map.detectIfNone(predicate, ifNone);
    }

    public long sum() {
        return this.map.sum();
    }

    public short max() {
        return this.map.max();
    }

    public short maxIfEmpty(short defaultValue) {
        return this.map.maxIfEmpty(defaultValue);
    }

    public short min() {
        return this.map.min();
    }

    public short minIfEmpty(short defaultValue) {
        return this.map.minIfEmpty(defaultValue);
    }

    public double average() {
        return this.map.average();
    }

    public double median() {
        return this.map.median();
    }

    public short addToValue(float key, short toBeAdded) {
        throw new UnsupportedOperationException("Cannot call addToValue() on " + this.getClass().getSimpleName());
    }

    public short[] toSortedArray() {
        return this.map.toSortedArray();
    }

    public MutableShortList toSortedList() {
        return this.map.toSortedList();
    }

    public short[] toArray() {
        return this.map.toArray();
    }

    public boolean contains(short value) {
        return this.map.contains(value);
    }

    public boolean containsAll(short ... source) {
        return this.map.containsAll(source);
    }

    public boolean containsAll(ShortIterable source) {
        return this.map.containsAll(source);
    }

    public MutableShortList toList() {
        return this.map.toList();
    }

    public MutableShortSet toSet() {
        return this.map.toSet();
    }

    public MutableShortBag toBag() {
        return this.map.toBag();
    }

    public LazyShortIterable asLazy() {
        return this.map.asLazy();
    }

    public MutableFloatShortMap withKeyValue(float key, short value) {
        throw new UnsupportedOperationException("Cannot call withKeyValue() on " + this.getClass().getSimpleName());
    }

    public MutableFloatShortMap withoutKey(float key) {
        throw new UnsupportedOperationException("Cannot call withoutKey() on " + this.getClass().getSimpleName());
    }

    public MutableFloatShortMap withoutAllKeys(FloatIterable keys) {
        throw new UnsupportedOperationException("Cannot call withoutAllKeys() on " + this.getClass().getSimpleName());
    }

    public MutableFloatShortMap asUnmodifiable() {
        return this;
    }

    public MutableFloatShortMap asSynchronized() {
        return new SynchronizedFloatShortMap(this);
    }

    public ImmutableFloatShortMap toImmutable() {
        return FloatShortMaps.immutable.withAll((FloatShortMap)this);
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean notEmpty() {
        return this.map.notEmpty();
    }

    public MutableFloatSet keySet() {
        return UnmodifiableFloatSet.of(this.map.keySet());
    }

    public MutableShortCollection values() {
        return UnmodifiableShortCollection.of(this.map.values());
    }

    public boolean equals(Object otherMap) {
        return this.map.equals(otherMap);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return this.map.toString();
    }

    public String makeString() {
        return this.map.makeString();
    }

    public String makeString(String separator) {
        return this.map.makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.map.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.map.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.map.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.map.appendString(appendable, start, separator, end);
    }

    public <T> T injectInto(T injectedValue, ObjectShortToObjectFunction<? super T, ? extends T> function) {
        return (T)this.map.injectInto(injectedValue, function);
    }
}

