/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable.primitive;

import java.io.Serializable;
import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.LazyByteIterable;
import org.eclipse.collections.api.LazyLongIterable;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.primitive.MutableByteBag;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction0;
import org.eclipse.collections.api.block.function.primitive.ByteToByteFunction;
import org.eclipse.collections.api.block.function.primitive.ByteToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.LongToByteFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BytePredicate;
import org.eclipse.collections.api.block.predicate.primitive.LongBytePredicate;
import org.eclipse.collections.api.block.procedure.primitive.ByteProcedure;
import org.eclipse.collections.api.block.procedure.primitive.LongByteProcedure;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import org.eclipse.collections.api.iterator.ByteIterator;
import org.eclipse.collections.api.iterator.MutableByteIterator;
import org.eclipse.collections.api.list.primitive.MutableByteList;
import org.eclipse.collections.api.map.primitive.ImmutableLongByteMap;
import org.eclipse.collections.api.map.primitive.LongByteMap;
import org.eclipse.collections.api.map.primitive.MutableByteLongMap;
import org.eclipse.collections.api.map.primitive.MutableLongByteMap;
import org.eclipse.collections.api.set.primitive.MutableByteSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.api.tuple.primitive.LongBytePair;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableByteCollection;
import org.eclipse.collections.impl.factory.primitive.LongByteMaps;
import org.eclipse.collections.impl.iterator.UnmodifiableByteIterator;
import org.eclipse.collections.impl.map.mutable.primitive.SynchronizedLongByteMap;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableLongSet;

public final class UnmodifiableLongByteMap
implements MutableLongByteMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableLongByteMap map;

    public UnmodifiableLongByteMap(MutableLongByteMap map) {
        if (map == null) {
            throw new IllegalArgumentException("Cannot create a UnmodifiableLongByteMap on a null map");
        }
        this.map = map;
    }

    public void clear() {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    public void put(long key, byte value) {
        throw new UnsupportedOperationException("Cannot call put() on " + this.getClass().getSimpleName());
    }

    public void putPair(LongBytePair keyValuePair) {
        throw new UnsupportedOperationException("Cannot call putPair() on " + this.getClass().getSimpleName());
    }

    public void putAll(LongByteMap map) {
        throw new UnsupportedOperationException("Cannot call putAll() on " + this.getClass().getSimpleName());
    }

    public void removeKey(long key) {
        throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
    }

    public void remove(long key) {
        throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
    }

    public byte removeKeyIfAbsent(long key, byte value) {
        if (this.map.containsKey(key)) {
            throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
        }
        return value;
    }

    public byte getIfAbsentPut(long key, byte value) {
        return this.map.getIfAbsentPut(key, (ByteFunction0 & Serializable)() -> {
            throw new UnsupportedOperationException();
        });
    }

    public byte getIfAbsentPut(long key, ByteFunction0 function) {
        return this.map.getIfAbsentPut(key, (ByteFunction0 & Serializable)() -> {
            throw new UnsupportedOperationException();
        });
    }

    public byte getIfAbsentPutWithKey(long key, LongToByteFunction function) {
        return this.map.getIfAbsentPut(key, (ByteFunction0 & Serializable)() -> {
            throw new UnsupportedOperationException();
        });
    }

    public <P> byte getIfAbsentPutWith(long key, ByteFunction<? super P> function, P parameter) {
        return this.map.getIfAbsentPut(key, (ByteFunction0 & Serializable)() -> {
            throw new UnsupportedOperationException();
        });
    }

    public byte updateValue(long key, byte initialValueIfAbsent, ByteToByteFunction function) {
        throw new UnsupportedOperationException("Cannot call updateValue() on " + this.getClass().getSimpleName());
    }

    public byte get(long key) {
        return this.map.get(key);
    }

    public byte getIfAbsent(long key, byte ifAbsent) {
        return this.map.getIfAbsent(key, ifAbsent);
    }

    public byte getOrThrow(long key) {
        return this.map.getOrThrow(key);
    }

    public boolean containsKey(long key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(byte value) {
        return this.map.containsValue(value);
    }

    public void forEachValue(ByteProcedure procedure) {
        this.map.forEachValue(procedure);
    }

    public void forEachKey(LongProcedure procedure) {
        this.map.forEachKey(procedure);
    }

    public void forEachKeyValue(LongByteProcedure procedure) {
        this.map.forEachKeyValue(procedure);
    }

    public LazyLongIterable keysView() {
        return this.map.keysView();
    }

    public RichIterable<LongBytePair> keyValuesView() {
        return this.map.keyValuesView();
    }

    public MutableByteLongMap flipUniqueValues() {
        return this.map.flipUniqueValues().asUnmodifiable();
    }

    public MutableLongByteMap select(LongBytePredicate predicate) {
        return this.map.select(predicate);
    }

    public MutableLongByteMap reject(LongBytePredicate predicate) {
        return this.map.reject(predicate);
    }

    public MutableByteIterator byteIterator() {
        return new UnmodifiableByteIterator((ByteIterator)this.map.byteIterator());
    }

    public void forEach(ByteProcedure procedure) {
        this.each(procedure);
    }

    public void each(ByteProcedure procedure) {
        this.map.forEach(procedure);
    }

    public int count(BytePredicate predicate) {
        return this.map.count(predicate);
    }

    public boolean anySatisfy(BytePredicate predicate) {
        return this.map.anySatisfy(predicate);
    }

    public boolean allSatisfy(BytePredicate predicate) {
        return this.map.allSatisfy(predicate);
    }

    public boolean noneSatisfy(BytePredicate predicate) {
        return this.map.noneSatisfy(predicate);
    }

    public MutableByteBag select(BytePredicate predicate) {
        return this.map.select(predicate);
    }

    public MutableByteBag reject(BytePredicate predicate) {
        return this.map.reject(predicate);
    }

    public <V> MutableBag<V> collect(ByteToObjectFunction<? extends V> function) {
        return this.map.collect(function);
    }

    public byte detectIfNone(BytePredicate predicate, byte ifNone) {
        return this.map.detectIfNone(predicate, ifNone);
    }

    public long sum() {
        return this.map.sum();
    }

    public byte max() {
        return this.map.max();
    }

    public byte maxIfEmpty(byte defaultValue) {
        return this.map.maxIfEmpty(defaultValue);
    }

    public byte min() {
        return this.map.min();
    }

    public byte minIfEmpty(byte defaultValue) {
        return this.map.minIfEmpty(defaultValue);
    }

    public double average() {
        return this.map.average();
    }

    public double median() {
        return this.map.median();
    }

    public byte addToValue(long key, byte toBeAdded) {
        throw new UnsupportedOperationException("Cannot call addToValue() on " + this.getClass().getSimpleName());
    }

    public byte[] toSortedArray() {
        return this.map.toSortedArray();
    }

    public MutableByteList toSortedList() {
        return this.map.toSortedList();
    }

    public byte[] toArray() {
        return this.map.toArray();
    }

    public boolean contains(byte value) {
        return this.map.contains(value);
    }

    public boolean containsAll(byte ... source) {
        return this.map.containsAll(source);
    }

    public boolean containsAll(ByteIterable source) {
        return this.map.containsAll(source);
    }

    public MutableByteList toList() {
        return this.map.toList();
    }

    public MutableByteSet toSet() {
        return this.map.toSet();
    }

    public MutableByteBag toBag() {
        return this.map.toBag();
    }

    public LazyByteIterable asLazy() {
        return this.map.asLazy();
    }

    public MutableLongByteMap withKeyValue(long key, byte value) {
        throw new UnsupportedOperationException("Cannot call withKeyValue() on " + this.getClass().getSimpleName());
    }

    public MutableLongByteMap withoutKey(long key) {
        throw new UnsupportedOperationException("Cannot call withoutKey() on " + this.getClass().getSimpleName());
    }

    public MutableLongByteMap withoutAllKeys(LongIterable keys) {
        throw new UnsupportedOperationException("Cannot call withoutAllKeys() on " + this.getClass().getSimpleName());
    }

    public MutableLongByteMap asUnmodifiable() {
        return this;
    }

    public MutableLongByteMap asSynchronized() {
        return new SynchronizedLongByteMap(this);
    }

    public ImmutableLongByteMap toImmutable() {
        return LongByteMaps.immutable.withAll((LongByteMap)this);
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean notEmpty() {
        return this.map.notEmpty();
    }

    public MutableLongSet keySet() {
        return UnmodifiableLongSet.of(this.map.keySet());
    }

    public MutableByteCollection values() {
        return UnmodifiableByteCollection.of(this.map.values());
    }

    public boolean equals(Object otherMap) {
        return this.map.equals(otherMap);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return this.map.toString();
    }

    public String makeString() {
        return this.map.makeString();
    }

    public String makeString(String separator) {
        return this.map.makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.map.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.map.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.map.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.map.appendString(appendable, start, separator, end);
    }

    public <T> T injectInto(T injectedValue, ObjectByteToObjectFunction<? super T, ? extends T> function) {
        return (T)this.map.injectInto(injectedValue, function);
    }
}

