/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.stack.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.EmptyStackException;
import org.eclipse.collections.api.BooleanIterable;
import org.eclipse.collections.api.LazyBooleanIterable;
import org.eclipse.collections.api.bag.primitive.MutableBooleanBag;
import org.eclipse.collections.api.block.function.primitive.BooleanToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectBooleanIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectBooleanToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BooleanPredicate;
import org.eclipse.collections.api.block.procedure.primitive.BooleanIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.BooleanProcedure;
import org.eclipse.collections.api.iterator.BooleanIterator;
import org.eclipse.collections.api.list.primitive.BooleanList;
import org.eclipse.collections.api.list.primitive.MutableBooleanList;
import org.eclipse.collections.api.set.primitive.MutableBooleanSet;
import org.eclipse.collections.api.stack.ImmutableStack;
import org.eclipse.collections.api.stack.primitive.BooleanStack;
import org.eclipse.collections.api.stack.primitive.ImmutableBooleanStack;
import org.eclipse.collections.impl.bag.mutable.primitive.BooleanHashBag;
import org.eclipse.collections.impl.factory.Stacks;
import org.eclipse.collections.impl.factory.primitive.BooleanStacks;
import org.eclipse.collections.impl.iterator.ImmutableEmptyBooleanIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyBooleanIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.BooleanArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.BooleanHashSet;

final class ImmutableBooleanEmptyStack
implements ImmutableBooleanStack,
Serializable {
    static final ImmutableBooleanStack INSTANCE = new ImmutableBooleanEmptyStack();
    private static final long serialVersionUID = 1L;

    ImmutableBooleanEmptyStack() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    public BooleanIterator booleanIterator() {
        return ImmutableEmptyBooleanIterator.INSTANCE;
    }

    public void forEach(BooleanProcedure procedure) {
    }

    public void each(BooleanProcedure procedure) {
    }

    public int count(BooleanPredicate predicate) {
        return 0;
    }

    public boolean anySatisfy(BooleanPredicate predicate) {
        return false;
    }

    public boolean allSatisfy(BooleanPredicate predicate) {
        return true;
    }

    public boolean noneSatisfy(BooleanPredicate predicate) {
        return true;
    }

    public boolean peek() {
        throw new EmptyStackException();
    }

    public BooleanList peek(int count) {
        this.checkNegativeCount(count);
        if (count == 0) {
            return new BooleanArrayList(0);
        }
        throw new EmptyStackException();
    }

    public boolean peekAt(int index) {
        this.checkNegativeCount(index);
        throw new EmptyStackException();
    }

    public ImmutableBooleanStack select(BooleanPredicate predicate) {
        return this;
    }

    public ImmutableBooleanStack reject(BooleanPredicate predicate) {
        return this;
    }

    public boolean detectIfNone(BooleanPredicate predicate, boolean ifNone) {
        return ifNone;
    }

    public <V> ImmutableStack<V> collect(BooleanToObjectFunction<? extends V> function) {
        return Stacks.immutable.of();
    }

    public boolean[] toArray() {
        return new boolean[0];
    }

    public boolean contains(boolean value) {
        return false;
    }

    public boolean containsAll(boolean ... source) {
        return source.length == 0;
    }

    public boolean containsAll(BooleanIterable source) {
        return source.isEmpty();
    }

    public MutableBooleanList toList() {
        return new BooleanArrayList();
    }

    public MutableBooleanSet toSet() {
        return new BooleanHashSet();
    }

    public MutableBooleanBag toBag() {
        return new BooleanHashBag();
    }

    public LazyBooleanIterable asLazy() {
        return new LazyBooleanIterableAdapter((BooleanIterable)this);
    }

    public ImmutableBooleanStack toImmutable() {
        return this;
    }

    public ImmutableBooleanStack push(boolean element) {
        return BooleanStacks.immutable.with(element);
    }

    public ImmutableBooleanStack pop() {
        throw new EmptyStackException();
    }

    public ImmutableBooleanStack pop(int count) {
        this.checkNegativeCount(count);
        if (count == 0) {
            return this;
        }
        throw new EmptyStackException();
    }

    private void checkNegativeCount(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be positive but was " + count);
        }
    }

    public int size() {
        return 0;
    }

    public boolean isEmpty() {
        return true;
    }

    public boolean notEmpty() {
        return false;
    }

    public <T> T injectInto(T injectedValue, ObjectBooleanToObjectFunction<? super T, ? extends T> function) {
        return injectedValue;
    }

    public boolean equals(Object otherStack) {
        if (otherStack == this) {
            return true;
        }
        if (!(otherStack instanceof BooleanStack)) {
            return false;
        }
        BooleanStack stack = (BooleanStack)otherStack;
        return stack.isEmpty();
    }

    public int hashCode() {
        return 1;
    }

    public String toString() {
        return "[]";
    }

    public String makeString() {
        return "";
    }

    public String makeString(String separator) {
        return "";
    }

    public String makeString(String start, String separator, String end) {
        return start + end;
    }

    public void appendString(Appendable appendable) {
    }

    public void appendString(Appendable appendable, String separator) {
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean getFirst() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".getFirst() not implemented yet");
    }

    public int indexOf(boolean value) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".indexOf() not implemented yet");
    }

    public <T> T injectIntoWithIndex(T injectedValue, ObjectBooleanIntToObjectFunction<? super T, ? extends T> function) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".injectIntoWithIndex() not implemented yet");
    }

    public void forEachWithIndex(BooleanIntProcedure procedure) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".forEachWithIndex() not implemented yet");
    }
}

