/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.multimap.list;

import java.io.Serializable;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.multimap.list.ImmutableListMultimap;
import org.eclipse.collections.api.multimap.list.MutableListMultimap;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.map.mutable.UnifiedMap;
import org.eclipse.collections.impl.multimap.AbstractMutableMultimap;
import org.eclipse.collections.impl.multimap.bag.HashBagMultimap;
import org.eclipse.collections.impl.multimap.list.FastListMultimap;
import org.eclipse.collections.impl.multimap.list.ImmutableListMultimapImpl;
import org.eclipse.collections.impl.multimap.list.SynchronizedListMultimap;

public abstract class AbstractMutableListMultimap<K, V>
extends AbstractMutableMultimap<K, V, MutableList<V>>
implements MutableListMultimap<K, V> {
    protected AbstractMutableListMultimap() {
    }

    protected AbstractMutableListMultimap(Pair<K, V> ... pairs) {
        super(pairs);
    }

    protected AbstractMutableListMultimap(Iterable<Pair<K, V>> inputIterable) {
        super(inputIterable);
    }

    protected AbstractMutableListMultimap(int size) {
        super(size);
    }

    public MutableListMultimap<K, V> toMutable() {
        return new FastListMultimap(this);
    }

    public ImmutableListMultimap<K, V> toImmutable() {
        UnifiedMap map = UnifiedMap.newMap();
        this.map.forEachKeyValue((Procedure2 & Serializable)(key, list) -> {
            ImmutableList cfr_ignored_0 = (ImmutableList)map.put(key, list.toImmutable());
        });
        return new ImmutableListMultimapImpl(map);
    }

    public <K2, V2> HashBagMultimap<K2, V2> collectKeysValues(Function2<? super K, ? super V, Pair<K2, V2>> function) {
        return this.collectKeysValues(function, HashBagMultimap.newMultimap());
    }

    public <V2> FastListMultimap<K, V2> collectValues(Function<? super V, ? extends V2> function) {
        return this.collectValues(function, FastListMultimap.newMultimap());
    }

    public MutableListMultimap<K, V> asSynchronized() {
        return SynchronizedListMultimap.of(this);
    }
}

