/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.list.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.LazyByteIterable;
import org.eclipse.collections.api.bag.primitive.MutableByteBag;
import org.eclipse.collections.api.block.function.primitive.ByteToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectByteIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BytePredicate;
import org.eclipse.collections.api.block.procedure.primitive.ByteIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ByteProcedure;
import org.eclipse.collections.api.iterator.ByteIterator;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.primitive.ByteList;
import org.eclipse.collections.api.list.primitive.ImmutableByteList;
import org.eclipse.collections.api.list.primitive.MutableByteList;
import org.eclipse.collections.api.set.primitive.MutableByteSet;
import org.eclipse.collections.impl.bag.mutable.primitive.ByteHashBag;
import org.eclipse.collections.impl.factory.primitive.ByteLists;
import org.eclipse.collections.impl.iterator.UnmodifiableByteIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyByteIterableAdapter;
import org.eclipse.collections.impl.lazy.primitive.ReverseByteIterable;
import org.eclipse.collections.impl.list.mutable.FastList;
import org.eclipse.collections.impl.list.mutable.primitive.ByteArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.ByteHashSet;

final class ImmutableByteSingletonList
implements ImmutableByteList,
Serializable {
    private static final long serialVersionUID = 1L;
    private final byte element1;

    ImmutableByteSingletonList(byte element) {
        this.element1 = element;
    }

    public byte get(int index) {
        if (index == 0) {
            return this.element1;
        }
        throw new IndexOutOfBoundsException("Index: " + index + ", Size: 1");
    }

    public byte getFirst() {
        return this.element1;
    }

    public byte getLast() {
        return this.element1;
    }

    public int indexOf(byte value) {
        return this.element1 == value ? 0 : -1;
    }

    public int lastIndexOf(byte value) {
        return this.element1 == value ? 0 : -1;
    }

    public ByteIterator byteIterator() {
        return new UnmodifiableByteIterator((ByteIterator)ByteArrayList.newListWith(this.element1).byteIterator());
    }

    public void forEach(ByteProcedure procedure) {
        this.each(procedure);
    }

    public void each(ByteProcedure procedure) {
        procedure.value(this.element1);
    }

    public void forEachWithIndex(ByteIntProcedure procedure) {
        procedure.value(this.element1, 0);
    }

    public int count(BytePredicate predicate) {
        return predicate.accept(this.element1) ? 1 : 0;
    }

    public boolean anySatisfy(BytePredicate predicate) {
        return predicate.accept(this.element1);
    }

    public boolean allSatisfy(BytePredicate predicate) {
        return predicate.accept(this.element1);
    }

    public boolean noneSatisfy(BytePredicate predicate) {
        return !predicate.accept(this.element1);
    }

    public ImmutableByteList select(BytePredicate predicate) {
        return predicate.accept(this.element1) ? ByteArrayList.newListWith(this.element1).toImmutable() : new ByteArrayList().toImmutable();
    }

    public ImmutableByteList reject(BytePredicate predicate) {
        return predicate.accept(this.element1) ? new ByteArrayList().toImmutable() : ByteArrayList.newListWith(this.element1).toImmutable();
    }

    public byte detectIfNone(BytePredicate predicate, byte ifNone) {
        return predicate.accept(this.element1) ? this.element1 : ifNone;
    }

    public <V> ImmutableList<V> collect(ByteToObjectFunction<? extends V> function) {
        return FastList.newListWith(function.valueOf(this.element1)).toImmutable();
    }

    public long sum() {
        return this.element1;
    }

    public byte max() {
        return this.element1;
    }

    public byte maxIfEmpty(byte defaultValue) {
        return this.element1;
    }

    public byte min() {
        return this.element1;
    }

    public byte minIfEmpty(byte defaultValue) {
        return this.element1;
    }

    public double average() {
        return this.element1;
    }

    public double median() {
        return this.element1;
    }

    public byte[] toSortedArray() {
        return new byte[]{this.element1};
    }

    public MutableByteList toSortedList() {
        return ByteArrayList.newListWith(this.element1);
    }

    public int binarySearch(byte value) {
        if (this.element1 == value) {
            return 0;
        }
        if (this.element1 < value) {
            return -2;
        }
        return -1;
    }

    public long dotProduct(ByteList list) {
        if (list.size() != 1) {
            throw new IllegalArgumentException("Lists used in dotProduct must be the same size");
        }
        return (long)this.element1 * (long)list.getFirst();
    }

    public byte[] toArray() {
        return new byte[]{this.element1};
    }

    public boolean contains(byte value) {
        return this.element1 == value;
    }

    public boolean containsAll(byte ... source) {
        for (byte value : source) {
            if (this.element1 == value) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(ByteIterable source) {
        ByteIterator iterator = source.byteIterator();
        while (iterator.hasNext()) {
            if (this.element1 == iterator.next()) continue;
            return false;
        }
        return true;
    }

    public LazyByteIterable asReversed() {
        return ReverseByteIterable.adapt((ByteList)this);
    }

    public MutableByteList toList() {
        return ByteArrayList.newListWith(this.element1);
    }

    public MutableByteSet toSet() {
        return ByteHashSet.newSetWith(this.element1);
    }

    public MutableByteBag toBag() {
        return ByteHashBag.newBagWith(this.element1);
    }

    public LazyByteIterable asLazy() {
        return new LazyByteIterableAdapter((ByteIterable)this);
    }

    public ImmutableByteList toImmutable() {
        return this;
    }

    public ImmutableByteSingletonList toReversed() {
        return this;
    }

    public ImmutableByteList newWith(byte element) {
        return ByteLists.immutable.with(new byte[]{this.element1, element});
    }

    public ImmutableByteList newWithout(byte element) {
        return this.element1 == element ? ByteLists.immutable.with() : this;
    }

    public ImmutableByteList newWithAll(ByteIterable elements) {
        ByteArrayList arrayList = ByteArrayList.newListWith(this.element1);
        arrayList.addAll(elements);
        return arrayList.toImmutable();
    }

    public ImmutableByteList newWithoutAll(ByteIterable elements) {
        return elements.contains(this.element1) ? ByteLists.immutable.with() : this;
    }

    public int size() {
        return 1;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean notEmpty() {
        return true;
    }

    public <T> T injectInto(T injectedValue, ObjectByteToObjectFunction<? super T, ? extends T> function) {
        return (T)function.valueOf(injectedValue, this.element1);
    }

    public <T> T injectIntoWithIndex(T injectedValue, ObjectByteIntToObjectFunction<? super T, ? extends T> function) {
        return (T)function.valueOf(injectedValue, this.element1, 0);
    }

    public boolean equals(Object otherList) {
        if (otherList == this) {
            return true;
        }
        if (!(otherList instanceof ByteList)) {
            return false;
        }
        ByteList list = (ByteList)otherList;
        if (list.size() != 1) {
            return false;
        }
        return this.element1 == list.get(0);
    }

    public int hashCode() {
        return 31 + this.element1;
    }

    public String toString() {
        return "[" + this.element1 + ']';
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.element1));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ImmutableByteList distinct() {
        return this;
    }

    public ImmutableByteList subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException("subList not yet implemented!");
    }
}

