/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.collection.mutable.primitive;

import java.io.Serializable;
import net.jcip.annotations.ThreadSafe;
import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.LazyDoubleIterable;
import org.eclipse.collections.api.bag.primitive.MutableDoubleBag;
import org.eclipse.collections.api.block.function.primitive.DoubleToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectDoubleToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.DoublePredicate;
import org.eclipse.collections.api.block.procedure.primitive.DoubleProcedure;
import org.eclipse.collections.api.collection.MutableCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableDoubleCollection;
import org.eclipse.collections.api.collection.primitive.MutableDoubleCollection;
import org.eclipse.collections.api.iterator.DoubleIterator;
import org.eclipse.collections.api.iterator.MutableDoubleIterator;
import org.eclipse.collections.api.list.primitive.MutableDoubleList;
import org.eclipse.collections.api.set.primitive.MutableDoubleSet;
import org.eclipse.collections.impl.collection.mutable.primitive.SynchronizedDoubleCollection;
import org.eclipse.collections.impl.iterator.UnmodifiableDoubleIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyDoubleIterableAdapter;

@ThreadSafe
public abstract class AbstractUnmodifiableDoubleCollection
implements MutableDoubleCollection,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableDoubleCollection collection;

    protected AbstractUnmodifiableDoubleCollection(MutableDoubleCollection collection) {
        if (collection == null) {
            throw new IllegalArgumentException("Cannot create a AbstractUnmodifiableDoubleCollection on a null collection");
        }
        this.collection = collection;
    }

    protected MutableDoubleCollection getDoubleCollection() {
        return this.collection;
    }

    public int size() {
        return this.collection.size();
    }

    public boolean isEmpty() {
        return this.collection.isEmpty();
    }

    public boolean notEmpty() {
        return this.collection.notEmpty();
    }

    public void clear() {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    public boolean contains(double value) {
        return this.collection.contains(value);
    }

    public boolean containsAll(double ... source) {
        return this.collection.containsAll(source);
    }

    public boolean containsAll(DoubleIterable source) {
        return this.collection.containsAll(source);
    }

    public boolean add(double newItem) {
        throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
    }

    public boolean addAll(double ... source) {
        throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
    }

    public boolean addAll(DoubleIterable source) {
        throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
    }

    public boolean remove(double value) {
        throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
    }

    public boolean removeAll(DoubleIterable source) {
        throw new UnsupportedOperationException("Cannot call removeAll() on " + this.getClass().getSimpleName());
    }

    public boolean removeAll(double ... source) {
        throw new UnsupportedOperationException("Cannot call removeAll() on " + this.getClass().getSimpleName());
    }

    public boolean retainAll(DoubleIterable source) {
        throw new UnsupportedOperationException("Cannot call retainAll() on " + this.getClass().getSimpleName());
    }

    public boolean retainAll(double ... source) {
        throw new UnsupportedOperationException("Cannot call retainAll() on " + this.getClass().getSimpleName());
    }

    public MutableDoubleIterator doubleIterator() {
        return new UnmodifiableDoubleIterator((DoubleIterator)this.collection.doubleIterator());
    }

    public void forEach(DoubleProcedure procedure) {
        this.each(procedure);
    }

    public void each(DoubleProcedure procedure) {
        this.collection.forEach(procedure);
    }

    public int count(DoublePredicate predicate) {
        return this.collection.count(predicate);
    }

    public boolean anySatisfy(DoublePredicate predicate) {
        return this.collection.anySatisfy(predicate);
    }

    public boolean allSatisfy(DoublePredicate predicate) {
        return this.collection.allSatisfy(predicate);
    }

    public boolean noneSatisfy(DoublePredicate predicate) {
        return this.collection.noneSatisfy(predicate);
    }

    public MutableDoubleCollection select(DoublePredicate predicate) {
        return this.collection.select(predicate);
    }

    public MutableDoubleCollection reject(DoublePredicate predicate) {
        return this.collection.reject(predicate);
    }

    public <V> MutableCollection<V> collect(DoubleToObjectFunction<? extends V> function) {
        return this.collection.collect(function);
    }

    public MutableDoubleCollection with(double element) {
        throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
    }

    public MutableDoubleCollection without(double element) {
        throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
    }

    public MutableDoubleCollection withAll(DoubleIterable elements) {
        throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
    }

    public MutableDoubleCollection withoutAll(DoubleIterable elements) {
        throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
    }

    public MutableDoubleCollection asUnmodifiable() {
        return this;
    }

    public MutableDoubleCollection asSynchronized() {
        return new SynchronizedDoubleCollection(this);
    }

    public ImmutableDoubleCollection toImmutable() {
        return this.collection.toImmutable();
    }

    public LazyDoubleIterable asLazy() {
        return new LazyDoubleIterableAdapter((DoubleIterable)this);
    }

    public double detectIfNone(DoublePredicate predicate, double ifNone) {
        return this.collection.detectIfNone(predicate, ifNone);
    }

    public double sum() {
        return this.collection.sum();
    }

    public double max() {
        return this.collection.max();
    }

    public double min() {
        return this.collection.min();
    }

    public double minIfEmpty(double defaultValue) {
        return this.collection.minIfEmpty(defaultValue);
    }

    public double maxIfEmpty(double defaultValue) {
        return this.collection.maxIfEmpty(defaultValue);
    }

    public double average() {
        return this.collection.average();
    }

    public double median() {
        return this.collection.median();
    }

    public MutableDoubleList toSortedList() {
        return this.collection.toSortedList();
    }

    public double[] toSortedArray() {
        return this.collection.toSortedArray();
    }

    public double[] toArray() {
        return this.collection.toArray();
    }

    public String toString() {
        return this.collection.toString();
    }

    public String makeString() {
        return this.collection.makeString();
    }

    public String makeString(String separator) {
        return this.collection.makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.collection.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.collection.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.collection.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.collection.appendString(appendable, start, separator, end);
    }

    public MutableDoubleList toList() {
        return this.collection.toList();
    }

    public MutableDoubleSet toSet() {
        return this.collection.toSet();
    }

    public MutableDoubleBag toBag() {
        return this.collection.toBag();
    }

    public <T> T injectInto(T injectedValue, ObjectDoubleToObjectFunction<? super T, ? extends T> function) {
        return (T)this.collection.injectInto(injectedValue, function);
    }
}

