/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy.primitive;

import java.util.Arrays;
import java.util.Iterator;
import net.jcip.annotations.Immutable;
import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.bag.primitive.MutableFloatBag;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.primitive.FloatPredicate;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.FloatProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.iterator.FloatIterator;
import org.eclipse.collections.api.list.primitive.MutableFloatList;
import org.eclipse.collections.api.set.primitive.MutableFloatSet;
import org.eclipse.collections.impl.bag.mutable.primitive.FloatHashBag;
import org.eclipse.collections.impl.lazy.primitive.AbstractLazyFloatIterable;
import org.eclipse.collections.impl.list.mutable.primitive.FloatArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.FloatHashSet;

@Immutable
public class CollectFloatIterable<T>
extends AbstractLazyFloatIterable {
    private final LazyIterable<T> iterable;
    private final FloatFunction<? super T> function;
    private final FloatFunctionToProcedure<T> floatFunctionToProcedure;

    public CollectFloatIterable(LazyIterable<T> adapted, FloatFunction<? super T> function) {
        this.iterable = adapted;
        this.function = function;
        this.floatFunctionToProcedure = new FloatFunctionToProcedure(function);
    }

    public FloatIterator floatIterator() {
        return new FloatIterator(){
            private final Iterator<T> iterator;
            {
                this.iterator = CollectFloatIterable.this.iterable.iterator();
            }

            public float next() {
                return CollectFloatIterable.this.function.floatValueOf(this.iterator.next());
            }

            public boolean hasNext() {
                return this.iterator.hasNext();
            }
        };
    }

    @Override
    public void forEach(FloatProcedure procedure) {
        this.each(procedure);
    }

    public void each(FloatProcedure procedure) {
        this.iterable.forEachWith(this.floatFunctionToProcedure, (Object)procedure);
    }

    @Override
    public int size() {
        return this.iterable.size();
    }

    @Override
    public boolean isEmpty() {
        return this.iterable.isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return this.iterable.notEmpty();
    }

    @Override
    public int count(final FloatPredicate predicate) {
        return this.iterable.count(new Predicate<T>(){

            public boolean accept(T each) {
                return predicate.accept(CollectFloatIterable.this.function.floatValueOf(each));
            }
        });
    }

    @Override
    public boolean anySatisfy(final FloatPredicate predicate) {
        return this.iterable.anySatisfy(new Predicate<T>(){

            public boolean accept(T each) {
                return predicate.accept(CollectFloatIterable.this.function.floatValueOf(each));
            }
        });
    }

    @Override
    public boolean allSatisfy(final FloatPredicate predicate) {
        return this.iterable.allSatisfy(new Predicate<T>(){

            public boolean accept(T each) {
                return predicate.accept(CollectFloatIterable.this.function.floatValueOf(each));
            }
        });
    }

    @Override
    public boolean noneSatisfy(final FloatPredicate predicate) {
        return this.iterable.allSatisfy(new Predicate<T>(){

            public boolean accept(T each) {
                return !predicate.accept(CollectFloatIterable.this.function.floatValueOf(each));
            }
        });
    }

    @Override
    public float[] toArray() {
        final float[] array = new float[this.size()];
        this.iterable.forEachWithIndex(new ObjectIntProcedure<T>(){

            public void value(T each, int index) {
                array[index] = CollectFloatIterable.this.function.floatValueOf(each);
            }
        });
        return array;
    }

    @Override
    public float[] toSortedArray() {
        float[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    @Override
    public MutableFloatList toList() {
        return FloatArrayList.newList((FloatIterable)this);
    }

    @Override
    public MutableFloatSet toSet() {
        return FloatHashSet.newSet((FloatIterable)this);
    }

    @Override
    public MutableFloatBag toBag() {
        return FloatHashBag.newBag((FloatIterable)this);
    }

    @Override
    public boolean containsAll(float ... source) {
        for (float value : source) {
            if (this.contains(value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(FloatIterable source) {
        FloatIterator iterator = source.floatIterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    private static final class FloatFunctionToProcedure<T>
    implements Procedure2<T, FloatProcedure> {
        private static final long serialVersionUID = 1L;
        private final FloatFunction<? super T> function;

        private FloatFunctionToProcedure(FloatFunction<? super T> function) {
            this.function = function;
        }

        public void value(T each, FloatProcedure procedure) {
            procedure.value(this.function.floatValueOf(each));
        }
    }
}

