/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable.primitive;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.LazyCharIterable;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.primitive.MutableCharBag;
import org.eclipse.collections.api.block.function.primitive.CharToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectCharToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.CharPredicate;
import org.eclipse.collections.api.block.procedure.primitive.CharProcedure;
import org.eclipse.collections.api.collection.MutableCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableCharCollection;
import org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import org.eclipse.collections.api.iterator.CharIterator;
import org.eclipse.collections.api.iterator.MutableCharIterator;
import org.eclipse.collections.api.list.primitive.MutableCharList;
import org.eclipse.collections.api.map.primitive.MutableCharValuesMap;
import org.eclipse.collections.api.set.primitive.MutableCharSet;
import org.eclipse.collections.impl.bag.mutable.HashBag;
import org.eclipse.collections.impl.bag.mutable.primitive.CharHashBag;
import org.eclipse.collections.impl.collection.mutable.primitive.SynchronizedCharCollection;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableCharCollection;
import org.eclipse.collections.impl.factory.primitive.CharLists;
import org.eclipse.collections.impl.lazy.primitive.LazyCharIterableAdapter;
import org.eclipse.collections.impl.map.mutable.primitive.AbstractSentinelValues;
import org.eclipse.collections.impl.primitive.AbstractCharIterable;
import org.eclipse.collections.impl.set.mutable.primitive.CharHashSet;

public abstract class AbstractMutableCharValuesMap
extends AbstractCharIterable
implements MutableCharValuesMap {
    protected abstract int getOccupiedWithData();

    protected abstract SentinelValues getSentinelValues();

    protected abstract void setSentinelValuesNull();

    protected abstract char getEmptyValue();

    protected abstract char getValueAtIndex(int var1);

    protected abstract int getTableSize();

    protected abstract boolean isNonSentinelAtIndex(int var1);

    protected void addEmptyKeyValue(char value) {
        this.getSentinelValues().containsZeroKey = true;
        this.getSentinelValues().zeroValue = value;
    }

    protected void removeEmptyKey() {
        if (this.getSentinelValues().containsOneKey) {
            this.getSentinelValues().containsZeroKey = false;
            this.getSentinelValues().zeroValue = this.getEmptyValue();
        } else {
            this.setSentinelValuesNull();
        }
    }

    protected void addRemovedKeyValue(char value) {
        this.getSentinelValues().containsOneKey = true;
        this.getSentinelValues().oneValue = value;
    }

    protected void removeRemovedKey() {
        if (this.getSentinelValues().containsZeroKey) {
            this.getSentinelValues().containsOneKey = false;
            this.getSentinelValues().oneValue = this.getEmptyValue();
        } else {
            this.setSentinelValuesNull();
        }
    }

    public boolean contains(char value) {
        return this.containsValue(value);
    }

    @Override
    public boolean containsAll(CharIterable source) {
        return source.allSatisfy(new CharPredicate(){

            public boolean accept(char value) {
                return AbstractMutableCharValuesMap.this.contains(value);
            }
        });
    }

    public char max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        MutableCharIterator iterator = this.charIterator();
        char max = iterator.next();
        while (iterator.hasNext()) {
            char value = iterator.next();
            if (max >= value) continue;
            max = value;
        }
        return max;
    }

    public char min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        MutableCharIterator iterator = this.charIterator();
        char min = iterator.next();
        while (iterator.hasNext()) {
            char value = iterator.next();
            if (value >= min) continue;
            min = value;
        }
        return min;
    }

    public int size() {
        return this.getOccupiedWithData() + (this.getSentinelValues() == null ? 0 : this.getSentinelValues().size());
    }

    @Override
    public boolean isEmpty() {
        return this.getOccupiedWithData() == 0 && (this.getSentinelValues() == null || this.getSentinelValues().size() == 0);
    }

    @Override
    public boolean notEmpty() {
        return this.getOccupiedWithData() != 0 || this.getSentinelValues() != null && this.getSentinelValues().size() != 0;
    }

    public void forEach(CharProcedure procedure) {
        this.each(procedure);
    }

    public void each(CharProcedure procedure) {
        this.forEachValue(procedure);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            boolean first = true;
            if (this.getSentinelValues() != null) {
                if (this.getSentinelValues().containsZeroKey) {
                    appendable.append(String.valueOf(this.getSentinelValues().zeroValue));
                    first = false;
                }
                if (this.getSentinelValues().containsOneKey) {
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(this.getSentinelValues().oneValue));
                    first = false;
                }
            }
            for (int i = 0; i < this.getTableSize(); ++i) {
                if (!this.isNonSentinelAtIndex(i)) continue;
                if (!first) {
                    appendable.append(separator);
                }
                appendable.append(String.valueOf(this.getValueAtIndex(i)));
                first = false;
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public char[] toArray() {
        char[] array = new char[this.size()];
        int index = 0;
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey) {
                array[index] = this.getSentinelValues().zeroValue;
                ++index;
            }
            if (this.getSentinelValues().containsOneKey) {
                array[index] = this.getSentinelValues().oneValue;
                ++index;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!this.isNonSentinelAtIndex(i)) continue;
            array[index] = this.getValueAtIndex(i);
            ++index;
        }
        return array;
    }

    public MutableCharBag select(CharPredicate predicate) {
        CharHashBag result = new CharHashBag();
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey && predicate.accept(this.getSentinelValues().zeroValue)) {
                result.add(this.getSentinelValues().zeroValue);
            }
            if (this.getSentinelValues().containsOneKey && predicate.accept(this.getSentinelValues().oneValue)) {
                result.add(this.getSentinelValues().oneValue);
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!this.isNonSentinelAtIndex(i) || !predicate.accept(this.getValueAtIndex(i))) continue;
            result.add(this.getValueAtIndex(i));
        }
        return result;
    }

    public MutableCharBag reject(CharPredicate predicate) {
        CharHashBag result = new CharHashBag();
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey && !predicate.accept(this.getSentinelValues().zeroValue)) {
                result.add(this.getSentinelValues().zeroValue);
            }
            if (this.getSentinelValues().containsOneKey && !predicate.accept(this.getSentinelValues().oneValue)) {
                result.add(this.getSentinelValues().oneValue);
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!this.isNonSentinelAtIndex(i) || predicate.accept(this.getValueAtIndex(i))) continue;
            result.add(this.getValueAtIndex(i));
        }
        return result;
    }

    public <V> MutableBag<V> collect(CharToObjectFunction<? extends V> function) {
        HashBag target = HashBag.newBag(this.size());
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey) {
                target.add(function.valueOf(this.getSentinelValues().zeroValue));
            }
            if (this.getSentinelValues().containsOneKey) {
                target.add(function.valueOf(this.getSentinelValues().oneValue));
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!this.isNonSentinelAtIndex(i)) continue;
            target.add(function.valueOf(this.getValueAtIndex(i)));
        }
        return target;
    }

    public char detectIfNone(CharPredicate predicate, char value) {
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey && predicate.accept(this.getSentinelValues().zeroValue)) {
                return this.getSentinelValues().zeroValue;
            }
            if (this.getSentinelValues().containsOneKey && predicate.accept(this.getSentinelValues().oneValue)) {
                return this.getSentinelValues().oneValue;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!this.isNonSentinelAtIndex(i) || !predicate.accept(this.getValueAtIndex(i))) continue;
            return this.getValueAtIndex(i);
        }
        return value;
    }

    public int count(CharPredicate predicate) {
        int count = 0;
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey && predicate.accept(this.getSentinelValues().zeroValue)) {
                ++count;
            }
            if (this.getSentinelValues().containsOneKey && predicate.accept(this.getSentinelValues().oneValue)) {
                ++count;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!this.isNonSentinelAtIndex(i) || !predicate.accept(this.getValueAtIndex(i))) continue;
            ++count;
        }
        return count;
    }

    public boolean anySatisfy(CharPredicate predicate) {
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey && predicate.accept(this.getSentinelValues().zeroValue)) {
                return true;
            }
            if (this.getSentinelValues().containsOneKey && predicate.accept(this.getSentinelValues().oneValue)) {
                return true;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!this.isNonSentinelAtIndex(i) || !predicate.accept(this.getValueAtIndex(i))) continue;
            return true;
        }
        return false;
    }

    public boolean allSatisfy(CharPredicate predicate) {
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey && !predicate.accept(this.getSentinelValues().zeroValue)) {
                return false;
            }
            if (this.getSentinelValues().containsOneKey && !predicate.accept(this.getSentinelValues().oneValue)) {
                return false;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!this.isNonSentinelAtIndex(i) || predicate.accept(this.getValueAtIndex(i))) continue;
            return false;
        }
        return true;
    }

    public boolean noneSatisfy(CharPredicate predicate) {
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey && predicate.accept(this.getSentinelValues().zeroValue)) {
                return false;
            }
            if (this.getSentinelValues().containsOneKey && predicate.accept(this.getSentinelValues().oneValue)) {
                return false;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!this.isNonSentinelAtIndex(i) || !predicate.accept(this.getValueAtIndex(i))) continue;
            return false;
        }
        return true;
    }

    public long sum() {
        long result = 0L;
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey) {
                result += (long)this.getSentinelValues().zeroValue;
            }
            if (this.getSentinelValues().containsOneKey) {
                result += (long)this.getSentinelValues().oneValue;
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!this.isNonSentinelAtIndex(i)) continue;
            result += (long)this.getValueAtIndex(i);
        }
        return result;
    }

    public boolean containsValue(char value) {
        if (this.getSentinelValues() != null && this.getSentinelValues().containsValue(value)) {
            return true;
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!this.isNonSentinelAtIndex(i) || this.getValueAtIndex(i) != value) continue;
            return true;
        }
        return false;
    }

    public void forEachValue(CharProcedure procedure) {
        if (this.getSentinelValues() != null) {
            if (this.getSentinelValues().containsZeroKey) {
                procedure.value(this.getSentinelValues().zeroValue);
            }
            if (this.getSentinelValues().containsOneKey) {
                procedure.value(this.getSentinelValues().oneValue);
            }
        }
        for (int i = 0; i < this.getTableSize(); ++i) {
            if (!this.isNonSentinelAtIndex(i)) continue;
            procedure.value(this.getValueAtIndex(i));
        }
    }

    protected abstract class AbstractCharValuesCollection
    implements MutableCharCollection {
        protected AbstractCharValuesCollection() {
        }

        public void clear() {
            AbstractMutableCharValuesMap.this.clear();
        }

        public MutableCharCollection select(CharPredicate predicate) {
            return AbstractMutableCharValuesMap.this.select(predicate);
        }

        public MutableCharCollection reject(CharPredicate predicate) {
            return AbstractMutableCharValuesMap.this.reject(predicate);
        }

        public char detectIfNone(CharPredicate predicate, char ifNone) {
            return AbstractMutableCharValuesMap.this.detectIfNone(predicate, ifNone);
        }

        public <V> MutableCollection<V> collect(CharToObjectFunction<? extends V> function) {
            return AbstractMutableCharValuesMap.this.collect(function);
        }

        public <T> T injectInto(T injectedValue, ObjectCharToObjectFunction<? super T, ? extends T> function) {
            return (T)AbstractMutableCharValuesMap.this.injectInto(injectedValue, function);
        }

        public long sum() {
            return AbstractMutableCharValuesMap.this.sum();
        }

        public char max() {
            return AbstractMutableCharValuesMap.this.max();
        }

        public char maxIfEmpty(char defaultValue) {
            return AbstractMutableCharValuesMap.this.maxIfEmpty(defaultValue);
        }

        public char min() {
            return AbstractMutableCharValuesMap.this.min();
        }

        public char minIfEmpty(char defaultValue) {
            return AbstractMutableCharValuesMap.this.minIfEmpty(defaultValue);
        }

        public double average() {
            return AbstractMutableCharValuesMap.this.average();
        }

        public double median() {
            return AbstractMutableCharValuesMap.this.median();
        }

        public char[] toSortedArray() {
            return AbstractMutableCharValuesMap.this.toSortedArray();
        }

        public MutableCharList toSortedList() {
            return AbstractMutableCharValuesMap.this.toSortedList();
        }

        public MutableCharCollection with(char element) {
            throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
        }

        public MutableCharCollection without(char element) {
            throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
        }

        public MutableCharCollection withAll(CharIterable elements) {
            throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
        }

        public MutableCharCollection withoutAll(CharIterable elements) {
            throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
        }

        public MutableCharCollection asUnmodifiable() {
            return UnmodifiableCharCollection.of(this);
        }

        public MutableCharCollection asSynchronized() {
            return SynchronizedCharCollection.of(this);
        }

        public ImmutableCharCollection toImmutable() {
            return CharLists.immutable.withAll((CharIterable)this);
        }

        public boolean contains(char value) {
            return AbstractMutableCharValuesMap.this.containsValue(value);
        }

        public boolean containsAll(char ... source) {
            return AbstractMutableCharValuesMap.this.containsAll(source);
        }

        public boolean containsAll(CharIterable source) {
            return AbstractMutableCharValuesMap.this.containsAll(source);
        }

        public MutableCharList toList() {
            return AbstractMutableCharValuesMap.this.toList();
        }

        public MutableCharSet toSet() {
            return AbstractMutableCharValuesMap.this.toSet();
        }

        public MutableCharBag toBag() {
            return AbstractMutableCharValuesMap.this.toBag();
        }

        public LazyCharIterable asLazy() {
            return new LazyCharIterableAdapter((CharIterable)this);
        }

        public boolean isEmpty() {
            return AbstractMutableCharValuesMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return AbstractMutableCharValuesMap.this.notEmpty();
        }

        public String makeString() {
            return AbstractMutableCharValuesMap.this.makeString();
        }

        public String makeString(String separator) {
            return AbstractMutableCharValuesMap.this.makeString(separator);
        }

        public String makeString(String start, String separator, String end) {
            return AbstractMutableCharValuesMap.this.makeString(start, separator, end);
        }

        public void appendString(Appendable appendable) {
            AbstractMutableCharValuesMap.this.appendString(appendable);
        }

        public void appendString(Appendable appendable, String separator) {
            AbstractMutableCharValuesMap.this.appendString(appendable, separator);
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            AbstractMutableCharValuesMap.this.appendString(appendable, start, separator, end);
        }

        public void forEach(CharProcedure procedure) {
            this.each(procedure);
        }

        public void each(CharProcedure procedure) {
            AbstractMutableCharValuesMap.this.each(procedure);
        }

        public int count(CharPredicate predicate) {
            return AbstractMutableCharValuesMap.this.count(predicate);
        }

        public boolean anySatisfy(CharPredicate predicate) {
            return AbstractMutableCharValuesMap.this.anySatisfy(predicate);
        }

        public boolean allSatisfy(CharPredicate predicate) {
            return AbstractMutableCharValuesMap.this.allSatisfy(predicate);
        }

        public boolean noneSatisfy(CharPredicate predicate) {
            return AbstractMutableCharValuesMap.this.noneSatisfy(predicate);
        }

        public boolean add(char element) {
            throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
        }

        public boolean addAll(char ... source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        public boolean addAll(CharIterable source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        public boolean removeAll(CharIterable source) {
            int oldSize = AbstractMutableCharValuesMap.this.size();
            CharIterator iterator = source.charIterator();
            while (iterator.hasNext()) {
                this.remove(iterator.next());
            }
            return oldSize != AbstractMutableCharValuesMap.this.size();
        }

        public boolean removeAll(char ... source) {
            int oldSize = AbstractMutableCharValuesMap.this.size();
            for (char item : source) {
                this.remove(item);
            }
            return oldSize != AbstractMutableCharValuesMap.this.size();
        }

        public boolean retainAll(char ... source) {
            return this.retainAll(CharHashSet.newSetWith(source));
        }

        public int size() {
            return AbstractMutableCharValuesMap.this.size();
        }

        public char[] toArray() {
            return AbstractMutableCharValuesMap.this.toArray();
        }
    }

    protected static class SentinelValues
    extends AbstractSentinelValues {
        protected char zeroValue;
        protected char oneValue;

        protected SentinelValues() {
        }

        public boolean containsValue(char value) {
            boolean valueEqualsZeroValue = this.containsZeroKey && this.zeroValue == value;
            boolean valueEqualsOneValue = this.containsOneKey && this.oneValue == value;
            return valueEqualsZeroValue || valueEqualsOneValue;
        }

        public SentinelValues copy() {
            SentinelValues sentinelValues = new SentinelValues();
            sentinelValues.zeroValue = this.zeroValue;
            sentinelValues.oneValue = this.oneValue;
            sentinelValues.containsOneKey = this.containsOneKey;
            sentinelValues.containsZeroKey = this.containsZeroKey;
            return sentinelValues;
        }
    }
}

