/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.LazyCharIterable;
import org.eclipse.collections.api.LazyIntIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableIntBag;
import org.eclipse.collections.api.block.function.primitive.IntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.CharIntPredicate;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.procedure.primitive.CharIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.CharProcedure;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.collection.ImmutableCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableIntCollection;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.iterator.IntIterator;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.api.map.primitive.CharIntMap;
import org.eclipse.collections.api.map.primitive.ImmutableCharIntMap;
import org.eclipse.collections.api.set.primitive.MutableCharSet;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.api.tuple.primitive.CharIntPair;
import org.eclipse.collections.impl.bag.mutable.primitive.IntHashBag;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableIntCollection;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.IntLists;
import org.eclipse.collections.impl.iterator.ImmutableEmptyIntIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyIntIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.IntArrayList;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableCharIntSingletonMap;
import org.eclipse.collections.impl.set.mutable.primitive.CharHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableCharSet;
import org.eclipse.collections.impl.utility.LazyIterate;
import org.eclipse.collections.impl.utility.primitive.LazyCharIterate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImmutableCharIntEmptyMap
implements ImmutableCharIntMap,
Serializable {
    static final ImmutableCharIntMap INSTANCE = new ImmutableCharIntEmptyMap();
    private static final long serialVersionUID = 1L;
    private static final int EMPTY_VALUE = 0;

    ImmutableCharIntEmptyMap() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    public int get(char key) {
        return 0;
    }

    public int getIfAbsent(char key, int ifAbsent) {
        return ifAbsent;
    }

    public int getOrThrow(char key) {
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(char key) {
        return false;
    }

    public boolean containsValue(int value) {
        return false;
    }

    public void forEachValue(IntProcedure procedure) {
    }

    public void forEachKey(CharProcedure procedure) {
    }

    public void forEachKeyValue(CharIntProcedure procedure) {
    }

    public LazyCharIterable keysView() {
        return LazyCharIterate.empty();
    }

    public RichIterable<CharIntPair> keyValuesView() {
        return LazyIterate.empty();
    }

    public ImmutableCharIntMap select(CharIntPredicate predicate) {
        return this;
    }

    public ImmutableCharIntMap reject(CharIntPredicate predicate) {
        return this;
    }

    public ImmutableCharIntMap toImmutable() {
        return this;
    }

    public IntIterator intIterator() {
        return ImmutableEmptyIntIterator.INSTANCE;
    }

    public void forEach(IntProcedure procedure) {
    }

    public void each(IntProcedure procedure) {
    }

    public int count(IntPredicate predicate) {
        return 0;
    }

    public long sum() {
        return 0L;
    }

    public int min() {
        throw new NoSuchElementException();
    }

    public int max() {
        throw new NoSuchElementException();
    }

    public int maxIfEmpty(int defaultValue) {
        return defaultValue;
    }

    public int minIfEmpty(int defaultValue) {
        return defaultValue;
    }

    public double average() {
        throw new ArithmeticException();
    }

    public double median() {
        throw new ArithmeticException();
    }

    public int[] toSortedArray() {
        return new int[0];
    }

    public MutableIntList toSortedList() {
        return new IntArrayList();
    }

    public boolean anySatisfy(IntPredicate predicate) {
        return false;
    }

    public boolean allSatisfy(IntPredicate predicate) {
        return true;
    }

    public boolean noneSatisfy(IntPredicate predicate) {
        return true;
    }

    public ImmutableIntCollection select(IntPredicate predicate) {
        return IntLists.immutable.with();
    }

    public ImmutableIntCollection reject(IntPredicate predicate) {
        return IntLists.immutable.with();
    }

    public int detectIfNone(IntPredicate predicate, int ifNone) {
        return ifNone;
    }

    public <V> ImmutableCollection<V> collect(IntToObjectFunction<? extends V> function) {
        return Lists.immutable.of();
    }

    public <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function) {
        return injectedValue;
    }

    public int[] toArray() {
        return new int[0];
    }

    public boolean contains(int value) {
        return false;
    }

    public boolean containsAll(int ... source) {
        return source.length == 0;
    }

    public boolean containsAll(IntIterable source) {
        return source.isEmpty();
    }

    public MutableIntList toList() {
        return new IntArrayList();
    }

    public MutableIntSet toSet() {
        return new IntHashSet();
    }

    public MutableIntBag toBag() {
        return new IntHashBag();
    }

    public LazyIntIterable asLazy() {
        return new LazyIntIterableAdapter((IntIterable)this);
    }

    public ImmutableCharIntMap newWithKeyValue(char key, int value) {
        return new ImmutableCharIntSingletonMap(key, value);
    }

    public ImmutableCharIntMap newWithoutKey(char key) {
        return this;
    }

    public ImmutableCharIntMap newWithoutAllKeys(CharIterable keys) {
        return this;
    }

    public int size() {
        return 0;
    }

    public boolean isEmpty() {
        return true;
    }

    public boolean notEmpty() {
        return false;
    }

    public MutableCharSet keySet() {
        return UnmodifiableCharSet.of(new CharHashSet());
    }

    public MutableIntCollection values() {
        return UnmodifiableIntCollection.of((MutableIntCollection)new IntArrayList());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CharIntMap)) {
            return false;
        }
        CharIntMap map = (CharIntMap)obj;
        return map.isEmpty();
    }

    public int hashCode() {
        return 0;
    }

    public String toString() {
        return "{}";
    }

    public String makeString() {
        return "";
    }

    public String makeString(String separator) {
        return "";
    }

    public String makeString(String start, String separator, String end) {
        return start + end;
    }

    public void appendString(Appendable appendable) {
    }

    public void appendString(Appendable appendable, String separator) {
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

