/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy.primitive;

import java.util.NoSuchElementException;
import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.LazyFloatIterable;
import org.eclipse.collections.api.bag.primitive.MutableFloatBag;
import org.eclipse.collections.api.block.procedure.primitive.FloatProcedure;
import org.eclipse.collections.api.iterator.FloatIterator;
import org.eclipse.collections.api.list.primitive.FloatList;
import org.eclipse.collections.api.list.primitive.MutableFloatList;
import org.eclipse.collections.api.set.primitive.MutableFloatSet;
import org.eclipse.collections.impl.bag.mutable.primitive.FloatHashBag;
import org.eclipse.collections.impl.lazy.primitive.AbstractLazyFloatIterable;
import org.eclipse.collections.impl.lazy.primitive.LazyFloatIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.FloatArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.FloatHashSet;

public class ReverseFloatIterable
extends AbstractLazyFloatIterable {
    private final FloatList adapted;

    public ReverseFloatIterable(FloatList newAdapted) {
        this.adapted = newAdapted;
    }

    public static ReverseFloatIterable adapt(FloatList floatList) {
        return new ReverseFloatIterable(floatList);
    }

    public FloatIterator floatIterator() {
        return new ReverseFloatIterator();
    }

    public void each(FloatProcedure procedure) {
        FloatIterator iterator = this.floatIterator();
        while (iterator.hasNext()) {
            procedure.value(iterator.next());
        }
    }

    public double sum() {
        return this.adapted.sum();
    }

    public float max() {
        return this.adapted.max();
    }

    public float min() {
        return this.adapted.min();
    }

    public float minIfEmpty(float defaultValue) {
        if (this.adapted.isEmpty()) {
            return defaultValue;
        }
        return this.adapted.min();
    }

    public float maxIfEmpty(float defaultValue) {
        if (this.adapted.isEmpty()) {
            return defaultValue;
        }
        return this.adapted.max();
    }

    public double average() {
        return this.adapted.average();
    }

    public double median() {
        return this.adapted.median();
    }

    public float[] toSortedArray() {
        return this.adapted.toSortedArray();
    }

    public float[] toArray() {
        float[] results = new float[this.adapted.size()];
        int index = 0;
        FloatIterator iterator = this.floatIterator();
        while (iterator.hasNext()) {
            results[index] = iterator.next();
            ++index;
        }
        return results;
    }

    public boolean contains(float value) {
        return this.adapted.contains(value);
    }

    public boolean containsAll(float ... source) {
        return this.adapted.containsAll(source);
    }

    public boolean containsAll(FloatIterable source) {
        return this.adapted.containsAll(source);
    }

    public int size() {
        return this.adapted.size();
    }

    public boolean isEmpty() {
        return this.adapted.isEmpty();
    }

    public boolean notEmpty() {
        return this.adapted.notEmpty();
    }

    public MutableFloatList toList() {
        return FloatArrayList.newList((FloatIterable)this);
    }

    public MutableFloatSet toSet() {
        return FloatHashSet.newSet((FloatIterable)this);
    }

    public MutableFloatBag toBag() {
        return FloatHashBag.newBag((FloatIterable)this);
    }

    public LazyFloatIterable asLazy() {
        return new LazyFloatIterableAdapter((FloatIterable)this);
    }

    private class ReverseFloatIterator
    implements FloatIterator {
        private int currentIndex;

        private ReverseFloatIterator() {
            this.currentIndex = ReverseFloatIterable.this.adapted.size() - 1;
        }

        public boolean hasNext() {
            return this.currentIndex != -1;
        }

        public float next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            float next = ReverseFloatIterable.this.adapted.get(this.currentIndex);
            --this.currentIndex;
            return next;
        }
    }
}

