/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable.primitive;

import java.io.Serializable;
import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.LazyDoubleIterable;
import org.eclipse.collections.api.LazyLongIterable;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.primitive.MutableLongBag;
import org.eclipse.collections.api.block.function.primitive.DoubleLongToLongFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleToLongFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction0;
import org.eclipse.collections.api.block.function.primitive.LongToLongFunction;
import org.eclipse.collections.api.block.function.primitive.LongToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectLongToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.DoubleLongPredicate;
import org.eclipse.collections.api.block.predicate.primitive.LongPredicate;
import org.eclipse.collections.api.block.procedure.primitive.DoubleLongProcedure;
import org.eclipse.collections.api.block.procedure.primitive.DoubleProcedure;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.iterator.MutableLongIterator;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.map.primitive.DoubleLongMap;
import org.eclipse.collections.api.map.primitive.ImmutableDoubleLongMap;
import org.eclipse.collections.api.map.primitive.MutableDoubleLongMap;
import org.eclipse.collections.api.map.primitive.MutableLongDoubleMap;
import org.eclipse.collections.api.set.primitive.MutableDoubleSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.api.tuple.primitive.DoubleLongPair;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableLongCollection;
import org.eclipse.collections.impl.factory.primitive.DoubleLongMaps;
import org.eclipse.collections.impl.iterator.UnmodifiableLongIterator;
import org.eclipse.collections.impl.map.mutable.primitive.SynchronizedDoubleLongMap;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableDoubleSet;

public class UnmodifiableDoubleLongMap
implements MutableDoubleLongMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableDoubleLongMap map;

    public UnmodifiableDoubleLongMap(MutableDoubleLongMap map) {
        if (map == null) {
            throw new IllegalArgumentException("Cannot create a UnmodifiableDoubleLongMap on a null map");
        }
        this.map = map;
    }

    public void clear() {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    public void put(double key, long value) {
        throw new UnsupportedOperationException("Cannot call put() on " + this.getClass().getSimpleName());
    }

    public void putPair(DoubleLongPair keyValuePair) {
        throw new UnsupportedOperationException("Cannot call putPair() on " + this.getClass().getSimpleName());
    }

    public void putAll(DoubleLongMap map) {
        throw new UnsupportedOperationException("Cannot call putAll() on " + this.getClass().getSimpleName());
    }

    public void updateValues(DoubleLongToLongFunction function) {
        throw new UnsupportedOperationException("Cannot call updateValues() on " + this.getClass().getSimpleName());
    }

    public void removeKey(double key) {
        throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
    }

    public void remove(double key) {
        throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
    }

    public long removeKeyIfAbsent(double key, long value) {
        if (this.map.containsKey(key)) {
            throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
        }
        return value;
    }

    public long getIfAbsentPut(double key, long value) {
        return this.map.getIfAbsentPut(key, (LongFunction0 & Serializable)() -> {
            throw new UnsupportedOperationException();
        });
    }

    public long getIfAbsentPut(double key, LongFunction0 function) {
        return this.map.getIfAbsentPut(key, (LongFunction0 & Serializable)() -> {
            throw new UnsupportedOperationException();
        });
    }

    public long getIfAbsentPutWithKey(double key, DoubleToLongFunction function) {
        return this.map.getIfAbsentPut(key, (LongFunction0 & Serializable)() -> {
            throw new UnsupportedOperationException();
        });
    }

    public <P> long getIfAbsentPutWith(double key, LongFunction<? super P> function, P parameter) {
        return this.map.getIfAbsentPut(key, (LongFunction0 & Serializable)() -> {
            throw new UnsupportedOperationException();
        });
    }

    public long updateValue(double key, long initialValueIfAbsent, LongToLongFunction function) {
        throw new UnsupportedOperationException("Cannot call updateValue() on " + this.getClass().getSimpleName());
    }

    public long get(double key) {
        return this.map.get(key);
    }

    public long getIfAbsent(double key, long ifAbsent) {
        return this.map.getIfAbsent(key, ifAbsent);
    }

    public long getOrThrow(double key) {
        return this.map.getOrThrow(key);
    }

    public boolean containsKey(double key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(long value) {
        return this.map.containsValue(value);
    }

    public void forEachValue(LongProcedure procedure) {
        this.map.forEachValue(procedure);
    }

    public void forEachKey(DoubleProcedure procedure) {
        this.map.forEachKey(procedure);
    }

    public void forEachKeyValue(DoubleLongProcedure procedure) {
        this.map.forEachKeyValue(procedure);
    }

    public LazyDoubleIterable keysView() {
        return this.map.keysView();
    }

    public RichIterable<DoubleLongPair> keyValuesView() {
        return this.map.keyValuesView();
    }

    public MutableLongDoubleMap flipUniqueValues() {
        return this.map.flipUniqueValues().asUnmodifiable();
    }

    public MutableDoubleLongMap select(DoubleLongPredicate predicate) {
        return this.map.select(predicate);
    }

    public MutableDoubleLongMap reject(DoubleLongPredicate predicate) {
        return this.map.reject(predicate);
    }

    public MutableLongIterator longIterator() {
        return new UnmodifiableLongIterator((LongIterator)this.map.longIterator());
    }

    public void forEach(LongProcedure procedure) {
        this.each(procedure);
    }

    public void each(LongProcedure procedure) {
        this.map.forEach(procedure);
    }

    public int count(LongPredicate predicate) {
        return this.map.count(predicate);
    }

    public boolean anySatisfy(LongPredicate predicate) {
        return this.map.anySatisfy(predicate);
    }

    public boolean allSatisfy(LongPredicate predicate) {
        return this.map.allSatisfy(predicate);
    }

    public boolean noneSatisfy(LongPredicate predicate) {
        return this.map.noneSatisfy(predicate);
    }

    public MutableLongBag select(LongPredicate predicate) {
        return this.map.select(predicate);
    }

    public MutableLongBag reject(LongPredicate predicate) {
        return this.map.reject(predicate);
    }

    public <V> MutableBag<V> collect(LongToObjectFunction<? extends V> function) {
        return this.map.collect(function);
    }

    public long detectIfNone(LongPredicate predicate, long ifNone) {
        return this.map.detectIfNone(predicate, ifNone);
    }

    public long sum() {
        return this.map.sum();
    }

    public long max() {
        return this.map.max();
    }

    public long maxIfEmpty(long defaultValue) {
        return this.map.maxIfEmpty(defaultValue);
    }

    public long min() {
        return this.map.min();
    }

    public long minIfEmpty(long defaultValue) {
        return this.map.minIfEmpty(defaultValue);
    }

    public double average() {
        return this.map.average();
    }

    public double median() {
        return this.map.median();
    }

    public long addToValue(double key, long toBeAdded) {
        throw new UnsupportedOperationException("Cannot call addToValue() on " + this.getClass().getSimpleName());
    }

    public long[] toSortedArray() {
        return this.map.toSortedArray();
    }

    public MutableLongList toSortedList() {
        return this.map.toSortedList();
    }

    public long[] toArray() {
        return this.map.toArray();
    }

    public boolean contains(long value) {
        return this.map.contains(value);
    }

    public boolean containsAll(long ... source) {
        return this.map.containsAll(source);
    }

    public boolean containsAll(LongIterable source) {
        return this.map.containsAll(source);
    }

    public MutableLongList toList() {
        return this.map.toList();
    }

    public MutableLongSet toSet() {
        return this.map.toSet();
    }

    public MutableLongBag toBag() {
        return this.map.toBag();
    }

    public LazyLongIterable asLazy() {
        return this.map.asLazy();
    }

    public MutableDoubleLongMap withKeyValue(double key, long value) {
        throw new UnsupportedOperationException("Cannot call withKeyValue() on " + this.getClass().getSimpleName());
    }

    public MutableDoubleLongMap withoutKey(double key) {
        throw new UnsupportedOperationException("Cannot call withoutKey() on " + this.getClass().getSimpleName());
    }

    public MutableDoubleLongMap withoutAllKeys(DoubleIterable keys) {
        throw new UnsupportedOperationException("Cannot call withoutAllKeys() on " + this.getClass().getSimpleName());
    }

    public MutableDoubleLongMap asUnmodifiable() {
        return this;
    }

    public MutableDoubleLongMap asSynchronized() {
        return new SynchronizedDoubleLongMap(this);
    }

    public ImmutableDoubleLongMap toImmutable() {
        return DoubleLongMaps.immutable.withAll((DoubleLongMap)this);
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean notEmpty() {
        return this.map.notEmpty();
    }

    public MutableDoubleSet keySet() {
        return UnmodifiableDoubleSet.of(this.map.keySet());
    }

    public MutableLongCollection values() {
        return UnmodifiableLongCollection.of(this.map.values());
    }

    public boolean equals(Object otherMap) {
        return this.map.equals(otherMap);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return this.map.toString();
    }

    public String makeString() {
        return this.map.makeString();
    }

    public String makeString(String separator) {
        return this.map.makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.map.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.map.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.map.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.map.appendString(appendable, start, separator, end);
    }

    public <T> T injectInto(T injectedValue, ObjectLongToObjectFunction<? super T, ? extends T> function) {
        return (T)this.map.injectInto(injectedValue, function);
    }

    public RichIterable<LongIterable> chunk(int size) {
        return this.map.chunk(size);
    }
}

