/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.mutable;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Iterator;
import java.util.RandomAccess;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.collection.primitive.MutableBooleanCollection;
import org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import org.eclipse.collections.api.collection.primitive.MutableDoubleCollection;
import org.eclipse.collections.api.collection.primitive.MutableFloatCollection;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.collection.primitive.MutableShortCollection;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.multimap.set.MutableSetMultimap;
import org.eclipse.collections.api.partition.set.PartitionMutableSet;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.api.set.MultiReaderSet;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.set.ParallelUnsortedSetIterable;
import org.eclipse.collections.api.set.SetIterable;
import org.eclipse.collections.api.set.UnsortedSetIterable;
import org.eclipse.collections.api.set.primitive.MutableBooleanSet;
import org.eclipse.collections.api.set.primitive.MutableByteSet;
import org.eclipse.collections.api.set.primitive.MutableCharSet;
import org.eclipse.collections.api.set.primitive.MutableDoubleSet;
import org.eclipse.collections.api.set.primitive.MutableFloatSet;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.api.set.primitive.MutableShortSet;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.collection.mutable.AbstractMultiReaderMutableCollection;
import org.eclipse.collections.impl.factory.Iterables;
import org.eclipse.collections.impl.factory.Sets;
import org.eclipse.collections.impl.lazy.parallel.set.MultiReaderParallelUnsortedSetIterable;
import org.eclipse.collections.impl.set.mutable.SynchronizedMutableSet;
import org.eclipse.collections.impl.set.mutable.UnifiedSet;
import org.eclipse.collections.impl.set.mutable.UnmodifiableMutableSet;
import org.eclipse.collections.impl.utility.LazyIterate;

public final class MultiReaderUnifiedSet<T>
extends AbstractMultiReaderMutableCollection<T>
implements RandomAccess,
Externalizable,
MultiReaderSet<T> {
    private static final long serialVersionUID = 1L;
    private MutableSet<T> delegate;

    @Deprecated
    public MultiReaderUnifiedSet() {
    }

    private MultiReaderUnifiedSet(MutableSet<T> newDelegate) {
        this(newDelegate, new ReentrantReadWriteLock());
    }

    private MultiReaderUnifiedSet(MutableSet<T> newDelegate, ReadWriteLock newLock) {
        this.lock = newLock;
        this.lockWrapper = new AbstractMultiReaderMutableCollection.ReadWriteLockWrapper(newLock);
        this.delegate = newDelegate;
    }

    public static <T> MultiReaderUnifiedSet<T> newSet() {
        return new MultiReaderUnifiedSet(UnifiedSet.newSet());
    }

    public static <T> MultiReaderUnifiedSet<T> newSet(int capacity) {
        return new MultiReaderUnifiedSet(UnifiedSet.newSet(capacity));
    }

    public static <T> MultiReaderUnifiedSet<T> newSet(Iterable<T> iterable) {
        return new MultiReaderUnifiedSet<T>(UnifiedSet.newSet(iterable));
    }

    public static <T> MultiReaderUnifiedSet<T> newSetWith(T ... elements) {
        return new MultiReaderUnifiedSet<T>(UnifiedSet.newSetWith(elements));
    }

    @Override
    protected MutableSet<T> getDelegate() {
        return this.delegate;
    }

    UntouchableMutableSet<T> asReadUntouchable() {
        return new UntouchableMutableSet(this.delegate.asUnmodifiable());
    }

    UntouchableMutableSet<T> asWriteUntouchable() {
        return new UntouchableMutableSet(this.delegate);
    }

    public void withReadLockAndDelegate(Procedure<? super MutableSet<T>> procedure) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            UntouchableMutableSet<T> untouchableSet = this.asReadUntouchable();
            procedure.value(untouchableSet);
            untouchableSet.becomeUseless();
        }
    }

    public void withWriteLockAndDelegate(Procedure<? super MutableSet<T>> procedure) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireWriteLock();){
            UntouchableMutableSet<T> untouchableSet = this.asWriteUntouchable();
            procedure.value(untouchableSet);
            untouchableSet.becomeUseless();
        }
    }

    public MutableSet<T> asSynchronized() {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            SynchronizedMutableSet synchronizedMutableSet = SynchronizedMutableSet.of(this);
            return synchronizedMutableSet;
        }
    }

    public ImmutableSet<T> toImmutable() {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            ImmutableSet immutableSet = Sets.immutable.withAll(this.delegate);
            return immutableSet;
        }
    }

    public MutableSet<T> asUnmodifiable() {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            UnmodifiableMutableSet unmodifiableMutableSet = UnmodifiableMutableSet.of(this);
            return unmodifiableMutableSet;
        }
    }

    public MutableSet<T> clone() {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MultiReaderUnifiedSet<T> multiReaderUnifiedSet = new MultiReaderUnifiedSet<T>(this.delegate.clone());
            return multiReaderUnifiedSet;
        }
    }

    public <V> MutableSet<V> collect(Function<? super T, ? extends V> function) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableSet mutableSet = this.delegate.collect(function);
            return mutableSet;
        }
    }

    public MutableBooleanSet collectBoolean(BooleanFunction<? super T> booleanFunction) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableBooleanSet mutableBooleanSet = this.delegate.collectBoolean(booleanFunction);
            return mutableBooleanSet;
        }
    }

    public MutableByteSet collectByte(ByteFunction<? super T> byteFunction) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableByteSet mutableByteSet = this.delegate.collectByte(byteFunction);
            return mutableByteSet;
        }
    }

    public MutableCharSet collectChar(CharFunction<? super T> charFunction) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableCharSet mutableCharSet = this.delegate.collectChar(charFunction);
            return mutableCharSet;
        }
    }

    public MutableDoubleSet collectDouble(DoubleFunction<? super T> doubleFunction) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableDoubleSet mutableDoubleSet = this.delegate.collectDouble(doubleFunction);
            return mutableDoubleSet;
        }
    }

    public MutableFloatSet collectFloat(FloatFunction<? super T> floatFunction) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableFloatSet mutableFloatSet = this.delegate.collectFloat(floatFunction);
            return mutableFloatSet;
        }
    }

    public MutableIntSet collectInt(IntFunction<? super T> intFunction) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableIntSet mutableIntSet = this.delegate.collectInt(intFunction);
            return mutableIntSet;
        }
    }

    public MutableLongSet collectLong(LongFunction<? super T> longFunction) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableLongSet mutableLongSet = this.delegate.collectLong(longFunction);
            return mutableLongSet;
        }
    }

    public MutableShortSet collectShort(ShortFunction<? super T> shortFunction) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableShortSet mutableShortSet = this.delegate.collectShort(shortFunction);
            return mutableShortSet;
        }
    }

    public <V> MutableSet<V> flatCollect(Function<? super T, ? extends Iterable<V>> function) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableSet mutableSet = this.delegate.flatCollect(function);
            return mutableSet;
        }
    }

    public <V> MutableSet<V> collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableSet mutableSet = this.delegate.collectIf(predicate, function);
            return mutableSet;
        }
    }

    public <P, V> MutableSet<V> collectWith(Function2<? super T, ? super P, ? extends V> function, P parameter) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableSet mutableSet = this.delegate.collectWith(function, parameter);
            return mutableSet;
        }
    }

    public MutableSet<T> newEmpty() {
        return MultiReaderUnifiedSet.newSet();
    }

    public MutableSet<T> reject(Predicate<? super T> predicate) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableSet mutableSet = this.delegate.reject(predicate);
            return mutableSet;
        }
    }

    public <P> MutableSet<T> rejectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableSet mutableSet = this.delegate.rejectWith(predicate, parameter);
            return mutableSet;
        }
    }

    public MutableSet<T> tap(Procedure<? super T> procedure) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            this.forEach(procedure);
            MultiReaderUnifiedSet multiReaderUnifiedSet = this;
            return multiReaderUnifiedSet;
        }
    }

    public MutableSet<T> select(Predicate<? super T> predicate) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableSet mutableSet = this.delegate.select(predicate);
            return mutableSet;
        }
    }

    public <P> MutableSet<T> selectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableSet mutableSet = this.delegate.selectWith(predicate, parameter);
            return mutableSet;
        }
    }

    public PartitionMutableSet<T> partition(Predicate<? super T> predicate) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            PartitionMutableSet partitionMutableSet = this.delegate.partition(predicate);
            return partitionMutableSet;
        }
    }

    public <P> PartitionMutableSet<T> partitionWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            PartitionMutableSet partitionMutableSet = this.delegate.partitionWith(predicate, parameter);
            return partitionMutableSet;
        }
    }

    public <S> MutableSet<S> selectInstancesOf(Class<S> clazz) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableSet mutableSet = this.delegate.selectInstancesOf(clazz);
            return mutableSet;
        }
    }

    public MutableSet<T> with(T element) {
        this.add(element);
        return this;
    }

    public MutableSet<T> without(T element) {
        this.remove(element);
        return this;
    }

    public MutableSet<T> withAll(Iterable<? extends T> elements) {
        this.addAllIterable(elements);
        return this;
    }

    public MutableSet<T> withoutAll(Iterable<? extends T> elements) {
        this.removeAllIterable(elements);
        return this;
    }

    public boolean equals(Object o) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            boolean bl = this.delegate.equals(o);
            return bl;
        }
    }

    public int hashCode() {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            int n = this.delegate.hashCode();
            return n;
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.delegate);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.delegate = (MutableSet)in.readObject();
        this.lock = new ReentrantReadWriteLock();
        this.lockWrapper = new AbstractMultiReaderMutableCollection.ReadWriteLockWrapper(this.lock);
    }

    public <V> MutableSetMultimap<V, T> groupBy(Function<? super T, ? extends V> function) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableSetMultimap mutableSetMultimap = this.delegate.groupBy(function);
            return mutableSetMultimap;
        }
    }

    public <V> MutableSetMultimap<V, T> groupByEach(Function<? super T, ? extends Iterable<V>> function) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableSetMultimap mutableSetMultimap = this.delegate.groupByEach(function);
            return mutableSetMultimap;
        }
    }

    public <V> MutableMap<V, T> groupByUniqueKey(Function<? super T, ? extends V> function) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableMap mutableMap = this.delegate.groupByUniqueKey(function);
            return mutableMap;
        }
    }

    @Deprecated
    public <S> MutableSet<Pair<T, S>> zip(Iterable<S> that) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableSet mutableSet = this.delegate.zip(that);
            return mutableSet;
        }
    }

    @Deprecated
    public MutableSet<Pair<T, Integer>> zipWithIndex() {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableSet mutableSet = this.delegate.zipWithIndex();
            return mutableSet;
        }
    }

    public RichIterable<RichIterable<T>> chunk(int size) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            RichIterable richIterable = this.delegate.chunk(size);
            return richIterable;
        }
    }

    public MutableSet<T> union(SetIterable<? extends T> set) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableSet mutableSet = this.delegate.union(set);
            return mutableSet;
        }
    }

    public <R extends Set<T>> R unionInto(SetIterable<? extends T> set, R targetSet) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            Set set2 = this.delegate.unionInto(set, targetSet);
            return (R)set2;
        }
    }

    public MutableSet<T> intersect(SetIterable<? extends T> set) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableSet mutableSet = this.delegate.intersect(set);
            return mutableSet;
        }
    }

    public <R extends Set<T>> R intersectInto(SetIterable<? extends T> set, R targetSet) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            Set set2 = this.delegate.intersectInto(set, targetSet);
            return (R)set2;
        }
    }

    public MutableSet<T> difference(SetIterable<? extends T> subtrahendSet) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableSet mutableSet = this.delegate.difference(subtrahendSet);
            return mutableSet;
        }
    }

    public <R extends Set<T>> R differenceInto(SetIterable<? extends T> subtrahendSet, R targetSet) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            Set set = this.delegate.differenceInto(subtrahendSet, targetSet);
            return (R)set;
        }
    }

    public MutableSet<T> symmetricDifference(SetIterable<? extends T> setB) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableSet mutableSet = this.delegate.symmetricDifference(setB);
            return mutableSet;
        }
    }

    public <R extends Set<T>> R symmetricDifferenceInto(SetIterable<? extends T> set, R targetSet) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            Set set2 = this.delegate.symmetricDifferenceInto(set, targetSet);
            return (R)set2;
        }
    }

    public boolean isSubsetOf(SetIterable<? extends T> candidateSuperset) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            boolean bl = this.delegate.isSubsetOf(candidateSuperset);
            return bl;
        }
    }

    public boolean isProperSubsetOf(SetIterable<? extends T> candidateSuperset) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            boolean bl = this.delegate.isProperSubsetOf(candidateSuperset);
            return bl;
        }
    }

    public MutableSet<UnsortedSetIterable<T>> powerSet() {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableSet mutableSet = this.delegate.powerSet();
            return mutableSet;
        }
    }

    public <B> LazyIterable<Pair<T, B>> cartesianProduct(SetIterable<B> set) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            LazyIterable lazyIterable = this.delegate.cartesianProduct(set);
            return lazyIterable;
        }
    }

    public ParallelUnsortedSetIterable<T> asParallel(ExecutorService executorService, int batchSize) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MultiReaderParallelUnsortedSetIterable multiReaderParallelUnsortedSetIterable = new MultiReaderParallelUnsortedSetIterable(this.delegate.asParallel(executorService, batchSize), this.lock);
            return multiReaderParallelUnsortedSetIterable;
        }
    }

    private static final class UntouchableIterator<T>
    implements Iterator<T> {
        private Iterator<T> delegate;

        private UntouchableIterator(Iterator<T> newDelegate) {
            this.delegate = newDelegate;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public T next() {
            return this.delegate.next();
        }

        @Override
        public void remove() {
            this.delegate.remove();
        }

        public void becomeUseless() {
            this.delegate = null;
        }
    }

    static final class UntouchableMutableSet<T>
    extends AbstractMultiReaderMutableCollection.UntouchableMutableCollection<T>
    implements MutableSet<T> {
        private final MutableList<UntouchableIterator<T>> requestedIterators = Iterables.mList();

        private UntouchableMutableSet(MutableSet<T> newDelegate) {
            this.delegate = newDelegate;
        }

        public void becomeUseless() {
            this.delegate = null;
            this.requestedIterators.each(UntouchableIterator::becomeUseless);
        }

        public MutableSet<T> with(T element) {
            this.add(element);
            return this;
        }

        public MutableSet<T> without(T element) {
            this.remove(element);
            return this;
        }

        public MutableSet<T> withAll(Iterable<? extends T> elements) {
            this.addAllIterable(elements);
            return this;
        }

        public MutableSet<T> withoutAll(Iterable<? extends T> elements) {
            this.removeAllIterable(elements);
            return this;
        }

        public MutableSet<T> asSynchronized() {
            throw new UnsupportedOperationException("Cannot call asSynchronized() on " + this.getClass().getSimpleName());
        }

        public MutableSet<T> asUnmodifiable() {
            throw new UnsupportedOperationException("Cannot call asUnmodifiable() on " + this.getClass().getSimpleName());
        }

        public ImmutableSet<T> toImmutable() {
            return Sets.immutable.withAll(this.getDelegate());
        }

        public LazyIterable<T> asLazy() {
            return LazyIterate.adapt(this);
        }

        public MutableSet<T> clone() {
            return this.getDelegate().clone();
        }

        public <V> MutableSet<V> collect(Function<? super T, ? extends V> function) {
            return this.getDelegate().collect(function);
        }

        public MutableBooleanSet collectBoolean(BooleanFunction<? super T> booleanFunction) {
            return this.getDelegate().collectBoolean(booleanFunction);
        }

        public <R extends MutableBooleanCollection> R collectBoolean(BooleanFunction<? super T> booleanFunction, R target) {
            return (R)this.getDelegate().collectBoolean(booleanFunction, target);
        }

        public MutableByteSet collectByte(ByteFunction<? super T> byteFunction) {
            return this.getDelegate().collectByte(byteFunction);
        }

        public <R extends MutableByteCollection> R collectByte(ByteFunction<? super T> byteFunction, R target) {
            return (R)this.getDelegate().collectByte(byteFunction, target);
        }

        public MutableCharSet collectChar(CharFunction<? super T> charFunction) {
            return this.getDelegate().collectChar(charFunction);
        }

        public <R extends MutableCharCollection> R collectChar(CharFunction<? super T> charFunction, R target) {
            return (R)this.getDelegate().collectChar(charFunction, target);
        }

        public MutableDoubleSet collectDouble(DoubleFunction<? super T> doubleFunction) {
            return this.getDelegate().collectDouble(doubleFunction);
        }

        public <R extends MutableDoubleCollection> R collectDouble(DoubleFunction<? super T> doubleFunction, R target) {
            return (R)this.getDelegate().collectDouble(doubleFunction, target);
        }

        public MutableFloatSet collectFloat(FloatFunction<? super T> floatFunction) {
            return this.getDelegate().collectFloat(floatFunction);
        }

        public <R extends MutableFloatCollection> R collectFloat(FloatFunction<? super T> floatFunction, R target) {
            return (R)this.getDelegate().collectFloat(floatFunction, target);
        }

        public MutableIntSet collectInt(IntFunction<? super T> intFunction) {
            return this.getDelegate().collectInt(intFunction);
        }

        public <R extends MutableIntCollection> R collectInt(IntFunction<? super T> intFunction, R target) {
            return (R)this.getDelegate().collectInt(intFunction, target);
        }

        public MutableLongSet collectLong(LongFunction<? super T> longFunction) {
            return this.getDelegate().collectLong(longFunction);
        }

        public <R extends MutableLongCollection> R collectLong(LongFunction<? super T> longFunction, R target) {
            return (R)this.getDelegate().collectLong(longFunction, target);
        }

        public MutableShortSet collectShort(ShortFunction<? super T> shortFunction) {
            return this.getDelegate().collectShort(shortFunction);
        }

        public <R extends MutableShortCollection> R collectShort(ShortFunction<? super T> shortFunction, R target) {
            return (R)this.getDelegate().collectShort(shortFunction, target);
        }

        public <V> MutableSet<V> flatCollect(Function<? super T, ? extends Iterable<V>> function) {
            return this.getDelegate().flatCollect(function);
        }

        public <V> MutableSet<V> collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function) {
            return this.getDelegate().collectIf(predicate, function);
        }

        public <P, V> MutableSet<V> collectWith(Function2<? super T, ? super P, ? extends V> function, P parameter) {
            return this.getDelegate().collectWith(function, parameter);
        }

        public <V> MutableSetMultimap<V, T> groupBy(Function<? super T, ? extends V> function) {
            return this.getDelegate().groupBy(function);
        }

        public <V> MutableSetMultimap<V, T> groupByEach(Function<? super T, ? extends Iterable<V>> function) {
            return this.getDelegate().groupByEach(function);
        }

        public <V> MutableMap<V, T> groupByUniqueKey(Function<? super T, ? extends V> function) {
            return this.getDelegate().groupByUniqueKey(function);
        }

        public MutableSet<T> newEmpty() {
            return this.getDelegate().newEmpty();
        }

        public MutableSet<T> reject(Predicate<? super T> predicate) {
            return this.getDelegate().reject(predicate);
        }

        public <P> MutableSet<T> rejectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
            return this.getDelegate().rejectWith(predicate, parameter);
        }

        public MutableSet<T> tap(Procedure<? super T> procedure) {
            this.forEach(procedure);
            return this;
        }

        public MutableSet<T> select(Predicate<? super T> predicate) {
            return this.getDelegate().select(predicate);
        }

        public <P> MutableSet<T> selectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
            return this.getDelegate().selectWith(predicate, parameter);
        }

        public PartitionMutableSet<T> partition(Predicate<? super T> predicate) {
            return this.getDelegate().partition(predicate);
        }

        public <P> PartitionMutableSet<T> partitionWith(Predicate2<? super T, ? super P> predicate, P parameter) {
            return this.getDelegate().partitionWith(predicate, parameter);
        }

        public <S> MutableSet<S> selectInstancesOf(Class<S> clazz) {
            return this.getDelegate().selectInstancesOf(clazz);
        }

        public Iterator<T> iterator() {
            UntouchableIterator iterator = new UntouchableIterator(this.delegate.iterator());
            this.requestedIterators.add(iterator);
            return iterator;
        }

        @Deprecated
        public <S> MutableSet<Pair<T, S>> zip(Iterable<S> that) {
            return this.getDelegate().zip(that);
        }

        @Deprecated
        public MutableSet<Pair<T, Integer>> zipWithIndex() {
            return this.getDelegate().zipWithIndex();
        }

        public MutableSet<T> union(SetIterable<? extends T> set) {
            return this.getDelegate().union(set);
        }

        public <R extends Set<T>> R unionInto(SetIterable<? extends T> set, R targetSet) {
            return (R)this.getDelegate().unionInto(set, targetSet);
        }

        public MutableSet<T> intersect(SetIterable<? extends T> set) {
            return this.getDelegate().intersect(set);
        }

        public <R extends Set<T>> R intersectInto(SetIterable<? extends T> set, R targetSet) {
            return (R)this.getDelegate().intersectInto(set, targetSet);
        }

        public MutableSet<T> difference(SetIterable<? extends T> subtrahendSet) {
            return this.getDelegate().difference(subtrahendSet);
        }

        public <R extends Set<T>> R differenceInto(SetIterable<? extends T> subtrahendSet, R targetSet) {
            return (R)this.getDelegate().differenceInto(subtrahendSet, targetSet);
        }

        public MutableSet<T> symmetricDifference(SetIterable<? extends T> setB) {
            return this.getDelegate().symmetricDifference(setB);
        }

        public <R extends Set<T>> R symmetricDifferenceInto(SetIterable<? extends T> set, R targetSet) {
            return (R)this.getDelegate().symmetricDifferenceInto(set, targetSet);
        }

        public boolean isSubsetOf(SetIterable<? extends T> candidateSuperset) {
            return this.getDelegate().isSubsetOf(candidateSuperset);
        }

        public boolean isProperSubsetOf(SetIterable<? extends T> candidateSuperset) {
            return this.getDelegate().isProperSubsetOf(candidateSuperset);
        }

        public MutableSet<UnsortedSetIterable<T>> powerSet() {
            return this.getDelegate().powerSet();
        }

        public <B> LazyIterable<Pair<T, B>> cartesianProduct(SetIterable<B> set) {
            return this.getDelegate().cartesianProduct(set);
        }

        public ParallelUnsortedSetIterable<T> asParallel(ExecutorService executorService, int batchSize) {
            return this.getDelegate().asParallel(executorService, batchSize);
        }

        private MutableSet<T> getDelegate() {
            return (MutableSet)this.delegate;
        }
    }
}

