/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.factory;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.factory.set.FixedSizeSetFactory;
import org.eclipse.collections.api.factory.set.ImmutableSetFactory;
import org.eclipse.collections.api.factory.set.MutableSetFactory;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.block.factory.Comparators;
import org.eclipse.collections.impl.set.fixed.FixedSizeSetFactoryImpl;
import org.eclipse.collections.impl.set.immutable.ImmutableSetFactoryImpl;
import org.eclipse.collections.impl.set.mutable.MultiReaderMutableSetFactory;
import org.eclipse.collections.impl.set.mutable.MutableSetFactoryImpl;
import org.eclipse.collections.impl.set.mutable.SetAdapter;
import org.eclipse.collections.impl.set.mutable.UnifiedSet;
import org.eclipse.collections.impl.tuple.Tuples;
import org.eclipse.collections.impl.utility.ArrayIterate;
import org.eclipse.collections.impl.utility.Iterate;
import org.eclipse.collections.impl.utility.LazyIterate;

public final class Sets {
    public static final ImmutableSetFactory immutable = ImmutableSetFactoryImpl.INSTANCE;
    public static final FixedSizeSetFactory fixedSize = FixedSizeSetFactoryImpl.INSTANCE;
    public static final MutableSetFactory mutable = MutableSetFactoryImpl.INSTANCE;
    public static final MutableSetFactory multiReader = MultiReaderMutableSetFactory.INSTANCE;
    private static final Predicate<Set<?>> INSTANCE_OF_SORTED_SET_PREDICATE = SortedSet.class::isInstance;
    private static final Predicate<Set<?>> HAS_NON_NULL_COMPARATOR = (Predicate & Serializable)set -> ((SortedSet)set).comparator() != null;

    private Sets() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static <T> MutableSet<T> adapt(Set<T> list) {
        return SetAdapter.adapt(list);
    }

    public static <E> MutableSet<E> union(Set<? extends E> setA, Set<? extends E> setB) {
        return Sets.unionInto(Sets.newSet(setA, setB), setA, setB);
    }

    public static <E, R extends Set<E>> R unionInto(R targetSet, Set<? extends E> setA, Set<? extends E> setB) {
        return setA.size() > setB.size() ? Sets.fillSet(targetSet, Sets.addAllProcedure(), setA, setB) : Sets.fillSet(targetSet, Sets.addAllProcedure(), setB, setA);
    }

    public static <E> MutableSet<E> unionAll(Set<? extends E> ... sets) {
        return Sets.unionAllInto(Sets.newSet(sets), sets);
    }

    public static <E, R extends Set<E>> R unionAllInto(R targetSet, Set<? extends E> ... sets) {
        Arrays.sort(sets, 0, sets.length, Comparators.descendingCollectionSizeComparator());
        return Sets.fillSet(targetSet, Sets.addAllProcedure(), sets);
    }

    public static <E> MutableSet<E> intersect(Set<? extends E> setA, Set<? extends E> setB) {
        return Sets.intersectInto(Sets.newSet(setA, setB), setA, setB);
    }

    public static <E, R extends Set<E>> R intersectInto(R targetSet, Set<? extends E> setA, Set<? extends E> setB) {
        return setA.size() < setB.size() ? Sets.fillSet(targetSet, Sets.retainAllProcedure(), setA, setB) : Sets.fillSet(targetSet, Sets.retainAllProcedure(), setB, setA);
    }

    public static <E> MutableSet<E> intersectAll(Set<? extends E> ... sets) {
        return Sets.intersectAllInto(Sets.newSet(sets), sets);
    }

    public static <E, R extends Set<E>> R intersectAllInto(R targetSet, Set<? extends E> ... sets) {
        Arrays.sort(sets, 0, sets.length, Comparators.ascendingCollectionSizeComparator());
        return Sets.fillSet(targetSet, Sets.retainAllProcedure(), sets);
    }

    public static <E> MutableSet<E> difference(Set<? extends E> minuendSet, Set<? extends E> subtrahendSet) {
        return Sets.differenceInto(Sets.newSet(minuendSet, subtrahendSet), minuendSet, subtrahendSet);
    }

    public static <E, R extends Set<E>> R differenceInto(R targetSet, Set<? extends E> minuendSet, Set<? extends E> subtrahendSet) {
        return Sets.fillSet(targetSet, Sets.removeAllProcedure(), minuendSet, subtrahendSet);
    }

    public static <E> MutableSet<E> differenceAll(Set<? extends E> ... sets) {
        return Sets.differenceAllInto(Sets.newSet(sets), sets);
    }

    public static <E, R extends Set<E>> R differenceAllInto(R targetSet, Set<? extends E> ... sets) {
        return Sets.fillSet(targetSet, Sets.removeAllProcedure(), sets);
    }

    public static <E> MutableSet<E> symmetricDifference(Set<? extends E> setA, Set<? extends E> setB) {
        return Sets.symmetricDifferenceInto(Sets.newSet(setA, setB), setA, setB);
    }

    public static <E, R extends Set<E>> R symmetricDifferenceInto(R targetSet, Set<? extends E> setA, Set<? extends E> setB) {
        return Sets.unionInto(targetSet, Sets.differenceInto(Sets.newSet(setA, setB), setA, setB), Sets.differenceInto(Sets.newSet(setA, setB), setB, setA));
    }

    public static <E> boolean isSubsetOf(Set<? extends E> candidateSubset, Set<? extends E> candidateSuperset) {
        return candidateSubset.size() <= candidateSuperset.size() && candidateSuperset.containsAll(candidateSubset);
    }

    public static <E> boolean isProperSubsetOf(Set<? extends E> candidateSubset, Set<? extends E> candidateSuperset) {
        return candidateSubset.size() < candidateSuperset.size() && candidateSuperset.containsAll(candidateSubset);
    }

    private static <E> MutableSet<E> newSet(Set<? extends E> ... sets) {
        Comparator<? extends E> comparator = Sets.extractComparator(sets);
        if (comparator != null) {
            return SetAdapter.adapt(new TreeSet<E>(comparator));
        }
        return UnifiedSet.newSet();
    }

    private static <E> Comparator<? super E> extractComparator(Set<? extends E> ... sets) {
        MutableList<Set<?>> sortedSetCollection = ArrayIterate.select(sets, INSTANCE_OF_SORTED_SET_PREDICATE);
        if (sortedSetCollection.isEmpty()) {
            return null;
        }
        SortedSet sortedSetWithComparator = (SortedSet)Iterate.detect(sortedSetCollection, HAS_NON_NULL_COMPARATOR);
        if (sortedSetWithComparator != null) {
            return sortedSetWithComparator.comparator();
        }
        return Comparators.safeNullsLow(Comparators.naturalOrder());
    }

    private static <E, R extends Set<E>> R fillSet(R targetSet, Procedure2<Set<? extends E>, R> procedure, Set<? extends E> ... sets) {
        targetSet.addAll(sets[0]);
        for (int i = 1; i < sets.length; ++i) {
            procedure.value(sets[i], targetSet);
        }
        return targetSet;
    }

    private static <E, R extends Set<E>> Procedure2<Set<? extends E>, R> addAllProcedure() {
        return (Procedure2 & Serializable)(argumentSet, targetSet) -> targetSet.addAll(argumentSet);
    }

    private static <E, R extends Set<E>> Procedure2<Set<? extends E>, R> retainAllProcedure() {
        return (Procedure2 & Serializable)(argumentSet, targetSet) -> targetSet.retainAll((Collection<?>)argumentSet);
    }

    private static <E, R extends Set<E>> Procedure2<Set<? extends E>, R> removeAllProcedure() {
        return (Procedure2 & Serializable)(argumentSet, targetSet) -> targetSet.removeAll((Collection<?>)argumentSet);
    }

    public static <T> MutableSet<MutableSet<T>> powerSet(Set<T> set) {
        UnifiedSet<MutableSet> seed = UnifiedSet.newSetWith(UnifiedSet.newSet());
        return Iterate.injectInto(seed, set, (Function2 & Serializable)(accumulator, element) -> Sets.union(accumulator, accumulator.collect((Function & Serializable)innerSet -> innerSet.toSet().with(element))));
    }

    public static <A, B> LazyIterable<Pair<A, B>> cartesianProduct(Set<A> set1, Set<B> set2) {
        return Sets.cartesianProduct(set1, set2, Tuples::pair);
    }

    public static <A, B, C> LazyIterable<C> cartesianProduct(Set<A> set1, Set<B> set2, Function2<? super A, ? super B, ? extends C> function) {
        return LazyIterate.cartesianProduct(set1, set2, function);
    }
}

