/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.java.languageserver;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collections;
import javax.annotation.PostConstruct;
import org.eclipse.che.api.core.notification.EventService;
import org.eclipse.che.api.core.notification.EventSubscriber;
import org.eclipse.che.api.languageserver.LanguageServiceUtils;
import org.eclipse.che.api.project.server.ProjectManager;
import org.eclipse.che.api.project.server.notification.PreProjectDeletedEvent;
import org.eclipse.che.api.project.server.notification.ProjectCreatedEvent;
import org.eclipse.che.jdt.ls.extension.api.dto.UpdateWorkspaceParameters;
import org.eclipse.che.plugin.java.languageserver.WorkspaceSynchronizer;

@Singleton
public class ProjectsListener {
    private final EventService eventService;
    private final ProjectManager projectManager;
    private final WorkspaceSynchronizer workspaceSynchronizer;

    @Inject
    public ProjectsListener(EventService eventService, ProjectManager projectManager, WorkspaceSynchronizer workspaceSynchronizer) {
        this.eventService = eventService;
        this.projectManager = projectManager;
        this.workspaceSynchronizer = workspaceSynchronizer;
    }

    @PostConstruct
    protected void initializeListeners() {
        this.eventService.subscribe((EventSubscriber)new EventSubscriber<ProjectCreatedEvent>(){

            public void onEvent(ProjectCreatedEvent event) {
                ProjectsListener.this.onProjectCreated(event);
            }
        });
        this.eventService.subscribe((EventSubscriber)new EventSubscriber<PreProjectDeletedEvent>(){

            public void onEvent(PreProjectDeletedEvent event) {
                ProjectsListener.this.onPreProjectDeleted(event);
            }
        });
    }

    private void onProjectCreated(ProjectCreatedEvent event) {
        if (!this.isProjectRegistered(event.getProjectPath())) {
            return;
        }
        String projectUri = LanguageServiceUtils.prefixURI((String)event.getProjectPath());
        UpdateWorkspaceParameters params = new UpdateWorkspaceParameters(Collections.singletonList(projectUri), Collections.emptyList());
        this.workspaceSynchronizer.syncronizerWorkspaceAsync(params);
    }

    private void onPreProjectDeleted(PreProjectDeletedEvent event) {
        if (!this.isProjectRegistered(event.getProjectPath())) {
            return;
        }
        String projectUri = LanguageServiceUtils.prefixURI((String)event.getProjectPath());
        UpdateWorkspaceParameters params = new UpdateWorkspaceParameters(Collections.emptyList(), Collections.singletonList(projectUri));
        this.workspaceSynchronizer.syncronizerWorkspaceAsync(params);
    }

    private boolean isProjectRegistered(String path) {
        return this.projectManager.isRegistered(path);
    }
}

