/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.java.languageserver;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.PreDestroy;
import org.eclipse.che.api.core.ApiException;
import org.eclipse.che.api.core.BadRequestException;
import org.eclipse.che.api.core.ConflictException;
import org.eclipse.che.api.core.ForbiddenException;
import org.eclipse.che.api.core.NotFoundException;
import org.eclipse.che.api.core.ServerException;
import org.eclipse.che.api.core.jsonrpc.commons.JsonRpcException;
import org.eclipse.che.api.core.model.workspace.config.ProjectConfig;
import org.eclipse.che.api.core.notification.EventService;
import org.eclipse.che.api.languageserver.LanguageServerConfig;
import org.eclipse.che.api.languageserver.LanguageServiceUtils;
import org.eclipse.che.api.languageserver.ProcessCommunicationProvider;
import org.eclipse.che.api.languageserver.service.FileContentAccess;
import org.eclipse.che.api.languageserver.util.DynamicWrapper;
import org.eclipse.che.api.languageserver.util.JsonUtil;
import org.eclipse.che.api.project.server.ProjectManager;
import org.eclipse.che.api.project.server.impl.RootDirPathProvider;
import org.eclipse.che.commons.lang.concurrent.LoggingUncaughtExceptionHandler;
import org.eclipse.che.jdt.ls.extension.api.dto.ProgressReport;
import org.eclipse.che.jdt.ls.extension.api.dto.StatusReport;
import org.eclipse.che.plugin.java.languageserver.ExecuteClientCommandJsonRpcTransmitter;
import org.eclipse.che.plugin.java.languageserver.JavaLSWrapper;
import org.eclipse.che.plugin.java.languageserver.JavaLanguageClient;
import org.eclipse.che.plugin.java.languageserver.JavaLanguageServer;
import org.eclipse.che.plugin.java.languageserver.NotifyJsonRpcTransmitter;
import org.eclipse.che.plugin.java.languageserver.ProcessorJsonRpcCommunication;
import org.eclipse.che.plugin.java.languageserver.ProjectClassPathChangedEvent;
import org.eclipse.che.plugin.java.languageserver.ProjectsSynchronizer;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class JavaLanguageServerLauncher
implements LanguageServerConfig {
    private static final Logger LOG = LoggerFactory.getLogger(JavaLanguageServerLauncher.class);
    private final Path launchScript;
    private final RootDirPathProvider rootDirPathProvider;
    private final ProcessorJsonRpcCommunication processorJsonRpcCommunication;
    private final ExecuteClientCommandJsonRpcTransmitter executeCliendCommandTransmitter;
    private final NotifyJsonRpcTransmitter notifyTransmitter;
    private final EventService eventService;
    private final ProjectManager projectManager;
    private final ProjectsSynchronizer projectSynchronizer;
    private final AtomicBoolean isStarted = new AtomicBoolean(false);
    private final ExecutorService notificationHandler;

    @Inject
    public JavaLanguageServerLauncher(RootDirPathProvider rootDirPathProvider, ProcessorJsonRpcCommunication processorJsonRpcCommunication, ExecuteClientCommandJsonRpcTransmitter executeCliendCommandTransmitter, NotifyJsonRpcTransmitter notifyTransmitter, EventService eventService, ProjectManager projectManager, ProjectsSynchronizer projectSynchronizer) {
        this.rootDirPathProvider = rootDirPathProvider;
        this.processorJsonRpcCommunication = processorJsonRpcCommunication;
        this.executeCliendCommandTransmitter = executeCliendCommandTransmitter;
        this.notifyTransmitter = notifyTransmitter;
        this.eventService = eventService;
        this.projectManager = projectManager;
        this.projectSynchronizer = projectSynchronizer;
        this.notificationHandler = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("Jdtls Notification Handler").setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)LoggingUncaughtExceptionHandler.getInstance()).setDaemon(true).build());
        this.launchScript = Paths.get(System.getenv("HOME"), "che/ls-java/launch.sh");
    }

    @PreDestroy
    public void shutDown() {
        this.notificationHandler.shutdownNow();
    }

    public void sendStatusReport(StatusReport report) {
        this.notificationHandler.execute(() -> this.handleStatusReport(report));
    }

    private void handleStatusReport(StatusReport report) {
        LOG.info("{}: {}", (Object)report.getType(), (Object)report.getMessage());
        if ("Started".equals(report.getType())) {
            this.isStarted.set(true);
            this.updateWorkspaceOnLSStarted();
        }
    }

    public boolean isStarted() {
        return this.isStarted.get();
    }

    private void updateWorkspaceOnLSStarted() {
        this.projectManager.getAll().forEach(registeredProject -> {
            if (new StringTokenizer(registeredProject.getPath(), "/", false).countTokens() == 1) {
                CompletableFuture.runAsync(() -> this.projectSynchronizer.synchronize(registeredProject.getPath()));
            }
            try {
                this.projectManager.update((ProjectConfig)registeredProject);
                this.eventService.publish((Object)new ProjectClassPathChangedEvent(registeredProject.getPath()));
                this.notifyTransmitter.sendNotification(new ExecuteCommandParams("che.jdt.ls.extension.workspace.clientUpdateProjectsClasspath", Collections.singletonList(registeredProject.getPath())));
            }
            catch (BadRequestException | ConflictException | ForbiddenException | NotFoundException | ServerException e) {
                LOG.error(String.format("Failed to update project '%s' configuration", registeredProject.getName()), e);
            }
        });
    }

    public void sendProgressReport(ProgressReport report) {
        this.processorJsonRpcCommunication.sendProgressNotification(report);
    }

    public CompletableFuture<Object> executeClientCommand(ExecuteCommandParams params) {
        return this.executeCliendCommandTransmitter.executeClientCommand(params);
    }

    public void sendNotification(ExecuteCommandParams params) {
        this.notificationHandler.execute(() -> this.handleNotification(params));
    }

    private void handleNotification(ExecuteCommandParams params) {
        String command = params.getCommand();
        List arguments = params.getArguments();
        switch (command) {
            case "che.jdt.ls.extension.workspace.clientUpdateProjectsClasspath": {
                ArrayList<String> fixedPathList = new ArrayList<String>(arguments.size());
                for (Object uri : arguments) {
                    String uriString = JsonUtil.convertToJson(uri).getAsString();
                    String projectPath = LanguageServiceUtils.removePrefixUri((String)uriString);
                    fixedPathList.add(projectPath);
                    this.projectManager.get(projectPath).ifPresent(project -> {
                        try {
                            LOG.info("updating projectconfig for {}", (Object)projectPath);
                            this.eventService.publish((Object)new ProjectClassPathChangedEvent(project.getPath()));
                            this.projectManager.update((ProjectConfig)project);
                        }
                        catch (BadRequestException | ConflictException | ForbiddenException | NotFoundException | ServerException e) {
                            throw this.toJsonRpcException((ApiException)e);
                        }
                    });
                }
                params.setArguments(fixedPathList);
                this.notifyClient(params);
                break;
            }
            case "che.jdt.ls.extension.workspace.projectCreated": {
                ArrayList<String> fixedPathList = new ArrayList<String>(arguments.size());
                for (Object uri : arguments) {
                    String uriString = JsonUtil.convertToJson(uri).getAsString();
                    String projectPath = LanguageServiceUtils.removePrefixUri((String)uriString);
                    fixedPathList.add(projectPath);
                    this.projectSynchronizer.ensureMavenProject(projectPath);
                }
                params.setArguments(fixedPathList);
                this.notifyClient(params);
                break;
            }
        }
    }

    void notifyClient(ExecuteCommandParams params) {
        this.notifyTransmitter.sendNotification(params);
    }

    private JsonRpcException toJsonRpcException(ApiException e) {
        if (e instanceof ForbiddenException) {
            return new JsonRpcException(-27103, e.getMessage());
        }
        if (e instanceof ServerException) {
            return new JsonRpcException(-27104, e.getMessage());
        }
        if (e instanceof NotFoundException) {
            return new JsonRpcException(-27100, e.getMessage());
        }
        if (e instanceof ConflictException) {
            return new JsonRpcException(-27102, e.getMessage());
        }
        if (e instanceof BadRequestException) {
            return new JsonRpcException(-27101, e.getMessage());
        }
        return new JsonRpcException(-27000, e.getMessage());
    }

    public LanguageServerConfig.RegexProvider getRegexpProvider() {
        return new LanguageServerConfig.RegexProvider(){

            public Map<String, String> getLanguageRegexes() {
                HashMap<String, String> regex = new HashMap<String, String>();
                regex.put("java", "(^jdt://.*|^chelib://.*|.*\\.java|.*\\.class)");
                return regex;
            }

            public Set<String> getFileWatchPatterns() {
                HashSet<String> regex = new HashSet<String>();
                regex.add("glob:**/*.java");
                regex.add("glob:**/pom.xml");
                regex.add("glob:**/*.gradle");
                regex.add("glob:**/.project");
                regex.add("glob:**/.classpath");
                regex.add("glob:**/settings/*.prefs");
                return regex;
            }
        };
    }

    public String getProjectsRoot() {
        return this.rootDirPathProvider.get();
    }

    public LanguageServerConfig.CommunicationProvider getCommunicationProvider() {
        ProcessBuilder processBuilder = new ProcessBuilder(this.launchScript.toString());
        processBuilder.directory(this.launchScript.getParent().toFile());
        processBuilder.redirectInput(ProcessBuilder.Redirect.PIPE);
        processBuilder.redirectOutput(ProcessBuilder.Redirect.PIPE);
        processBuilder.redirectError(ProcessBuilder.Redirect.INHERIT);
        return new ProcessCommunicationProvider(processBuilder, "Che-LS-JDT");
    }

    public LanguageServerConfig.InstallerStatusProvider getInstallerStatusProvider() {
        return new LanguageServerConfig.InstallerStatusProvider(){

            public boolean isSuccessfullyInstalled() {
                return JavaLanguageServerLauncher.this.launchScript.toFile().exists();
            }

            public String getCause() {
                return this.isSuccessfullyInstalled() ? null : "Launch script file does not exist";
            }
        };
    }

    public LanguageServerConfig.InstanceProvider getInstanceProvider() {
        return new LanguageServerConfig.InstanceProvider(){

            public LanguageServer get(LanguageClient client, InputStream in, OutputStream out) {
                Object javaLangClient = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{LanguageClient.class, JavaLanguageClient.class}, (InvocationHandler)new DynamicWrapper((Object)JavaLanguageServerLauncher.this, (Object)client));
                Launcher launcher = Launcher.createLauncher((Object)javaLangClient, JavaLanguageServer.class, (InputStream)in, (OutputStream)out);
                launcher.startListening();
                JavaLanguageServer proxy = (JavaLanguageServer)launcher.getRemoteProxy();
                LanguageServer wrapped = (LanguageServer)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{LanguageServer.class, FileContentAccess.class}, (InvocationHandler)new DynamicWrapper((Object)new JavaLSWrapper(JavaLanguageServerLauncher.this, proxy), (Object)proxy));
                return wrapped;
            }
        };
    }

    public void pomChanged(String uri) {
        String pomPath = LanguageServiceUtils.removePrefixUri((String)uri);
        this.projectManager.getClosest(pomPath).ifPresent(project -> {
            try {
                LOG.info("updating projectconfig for {}", (Object)project.getPath());
                this.projectManager.update((ProjectConfig)project);
                this.notifyClient(new ExecuteCommandParams("java/pomChanged", Collections.singletonList(pomPath)));
            }
            catch (BadRequestException | ConflictException | ForbiddenException | NotFoundException | ServerException e) {
                throw this.toJsonRpcException((ApiException)e);
            }
        });
    }
}

