/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.java.languageserver;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import org.eclipse.che.api.languageserver.service.FileContentAccess;
import org.eclipse.che.api.languageserver.util.DynamicWrapper;
import org.eclipse.che.plugin.java.languageserver.JavaLanguageServer;
import org.eclipse.che.plugin.java.languageserver.JavaLanguageServerLauncher;
import org.eclipse.che.plugin.java.languageserver.JavaTextDocumentServiceWraper;
import org.eclipse.lsp4j.DidChangeWatchedFilesParams;
import org.eclipse.lsp4j.FileEvent;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceClientCapabilities;
import org.eclipse.lsp4j.WorkspaceEditCapabilities;
import org.eclipse.lsp4j.services.TextDocumentService;
import org.eclipse.lsp4j.services.WorkspaceService;

public class JavaLSWrapper {
    private JavaLanguageServer wrapped;
    private JavaLanguageServerLauncher launcher;

    public JavaLSWrapper(JavaLanguageServerLauncher launcher, JavaLanguageServer wrapped) {
        this.launcher = launcher;
        this.wrapped = wrapped;
    }

    public CompletableFuture<String> getFileContent(String uri) {
        return this.wrapped.classFileContents(new TextDocumentIdentifier(uri));
    }

    public CompletableFuture<InitializeResult> initialize(InitializeParams params) {
        HashMap initOptions = new HashMap();
        HashMap<String, String> extendedCapabilities = new HashMap<String, String>();
        extendedCapabilities.put("progressReportProvider", "true");
        extendedCapabilities.put("classFileContentsSupport", "true");
        initOptions.put("extendedClientCapabilities", extendedCapabilities);
        WorkspaceClientCapabilities workspaceClientCapabilities = params.getCapabilities().getWorkspace();
        WorkspaceEditCapabilities workspaceEditCapabilities = new WorkspaceEditCapabilities();
        workspaceEditCapabilities.setResourceChanges(Boolean.valueOf(true));
        workspaceClientCapabilities.setWorkspaceEdit(workspaceEditCapabilities);
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put("java.configuration.updateBuildConfiguration", "automatic");
        initOptions.put("settings", settings);
        params.setInitializationOptions(initOptions);
        return this.wrapped.initialize(params).thenApply(result -> {
            result.getCapabilities().setDocumentSymbolProvider(Boolean.valueOf(false));
            result.getCapabilities().setReferencesProvider(Boolean.valueOf(false));
            result.getCapabilities().setRenameProvider(Boolean.valueOf(false));
            return result;
        });
    }

    public TextDocumentService getTextDocumentService() {
        return (TextDocumentService)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{TextDocumentService.class, FileContentAccess.class}, (InvocationHandler)new DynamicWrapper((Object)new JavaTextDocumentServiceWraper(this.wrapped.getTextDocumentService()), (Object)this.wrapped.getTextDocumentService()));
    }

    public WorkspaceService getWorkspaceService() {
        return (WorkspaceService)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{WorkspaceService.class}, (InvocationHandler)new DynamicWrapper((Object)this, (Object)this.wrapped.getWorkspaceService()));
    }

    public void didChangeWatchedFiles(DidChangeWatchedFilesParams params) {
        for (FileEvent event : params.getChanges()) {
            if (!event.getUri().endsWith("/pom.xml")) continue;
            this.launcher.pomChanged(event.getUri());
        }
        this.wrapped.getWorkspaceService().didChangeWatchedFiles(params);
    }
}

