/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.java.languageserver;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.che.commons.lang.concurrent.LoggingUncaughtExceptionHandler;
import org.eclipse.che.jdt.ls.extension.api.dto.JobResult;
import org.eclipse.che.jdt.ls.extension.api.dto.UpdateWorkspaceParameters;
import org.eclipse.che.plugin.java.languageserver.JavaLanguageServerExtensionService;
import org.eclipse.che.plugin.java.languageserver.ProjectsSynchronizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class WorkspaceSynchronizer {
    private static final Logger LOG = LoggerFactory.getLogger(WorkspaceSynchronizer.class);
    private final JavaLanguageServerExtensionService service;
    private final ExecutorService executorService;
    private final ProjectsSynchronizer projectsSynchronizer;

    @Inject
    public WorkspaceSynchronizer(JavaLanguageServerExtensionService service, ProjectsSynchronizer projectsSynchronizer) {
        this.service = service;
        this.projectsSynchronizer = projectsSynchronizer;
        this.executorService = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("WorkspaceUpdater-%d").setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)LoggingUncaughtExceptionHandler.getInstance()).setDaemon(true).build());
    }

    public void syncronizerWorkspaceAsync(UpdateWorkspaceParameters updateWorkspaceParameters) {
        this.executorService.submit(() -> {
            JobResult jobResult = this.service.updateWorkspace(updateWorkspaceParameters);
            switch (jobResult.getSeverity()) {
                case ERROR: {
                    LOG.error("Failed to update workspace. Result code: '{}', message: '{}'. Added projects: '{}', removed projects: '{}'", new Object[]{jobResult.getResultCode(), jobResult.getMessage(), updateWorkspaceParameters.getAddedProjectsUri().toString(), updateWorkspaceParameters.getRemovedProjectsUri().toString()});
                    break;
                }
                case WARNING: 
                case CANCEL: {
                    LOG.warn("Failed to update workspace. Result code: '{}', message: '{}'. Added projects: '{}', removed projects: '{}'", new Object[]{jobResult.getResultCode(), jobResult.getMessage(), updateWorkspaceParameters.getAddedProjectsUri().toString(), updateWorkspaceParameters.getRemovedProjectsUri().toString()});
                    break;
                }
                default: {
                    updateWorkspaceParameters.getAddedProjectsUri().forEach(this.projectsSynchronizer::synchronize);
                    LOG.info("Workspace updated. Result code: '{}', message: '{}'. Added projects: '{}', removed projects: '{}'", new Object[]{jobResult.getResultCode(), jobResult.getMessage(), updateWorkspaceParameters.getAddedProjectsUri().toString(), updateWorkspaceParameters.getRemovedProjectsUri().toString()});
                }
            }
        });
    }
}

