/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.eclipse.californium.elements.util.SimpleCounterStatistic;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.DtlsClusterHealth;
import org.eclipse.californium.scandium.DtlsHealthLogger;

public class DtlsClusterHealthLogger
extends DtlsHealthLogger
implements DtlsClusterHealth {
    public static final String DROPPED_INTERNAL_UDP_MESSAGES = "dropped internal udp";
    private final SimpleCounterStatistic forwardedMessage;
    private final SimpleCounterStatistic processedForwardedMessage;
    private final SimpleCounterStatistic badForwardMessage;
    private final SimpleCounterStatistic dropForwardMessage;
    private final SimpleCounterStatistic backwardedMessage;
    private final SimpleCounterStatistic sendBackwardedMessage;
    private final SimpleCounterStatistic badBackwardMessage;
    private final SimpleCounterStatistic dropBackwardMessage;
    private final SimpleCounterStatistic sendingClusterManagementMessage;
    private final SimpleCounterStatistic receivingClusterManagementMessage;
    private final SimpleCounterStatistic droppedInternalMessages;

    public DtlsClusterHealthLogger() {
        this("");
    }

    public DtlsClusterHealthLogger(String tag) {
        super(tag);
        this.forwardedMessage = new SimpleCounterStatistic("forwarded", this.align);
        this.processedForwardedMessage = new SimpleCounterStatistic("process forwarded", this.align);
        this.badForwardMessage = new SimpleCounterStatistic("bad forward", this.align);
        this.dropForwardMessage = new SimpleCounterStatistic("drop forward", this.align);
        this.backwardedMessage = new SimpleCounterStatistic("backwarded", this.align);
        this.sendBackwardedMessage = new SimpleCounterStatistic("send backwarded", this.align);
        this.badBackwardMessage = new SimpleCounterStatistic("bad backward", this.align);
        this.dropBackwardMessage = new SimpleCounterStatistic("drop backward", this.align);
        this.sendingClusterManagementMessage = new SimpleCounterStatistic("sent cluster mgmt", this.align);
        this.receivingClusterManagementMessage = new SimpleCounterStatistic("recv cluster mgmt", this.align);
        this.droppedInternalMessages = new SimpleCounterStatistic(DROPPED_INTERNAL_UDP_MESSAGES, this.align);
        this.init();
    }

    public DtlsClusterHealthLogger(String tag, int interval, TimeUnit unit, ScheduledExecutorService executor) {
        super(tag, interval, unit, executor);
        this.forwardedMessage = new SimpleCounterStatistic("forwarded", this.align);
        this.processedForwardedMessage = new SimpleCounterStatistic("process forwarded", this.align);
        this.badForwardMessage = new SimpleCounterStatistic("bad forward", this.align);
        this.dropForwardMessage = new SimpleCounterStatistic("drop forward", this.align);
        this.backwardedMessage = new SimpleCounterStatistic("backwarded", this.align);
        this.sendBackwardedMessage = new SimpleCounterStatistic("send backwarded", this.align);
        this.badBackwardMessage = new SimpleCounterStatistic("bad backward", this.align);
        this.dropBackwardMessage = new SimpleCounterStatistic("drop backward", this.align);
        this.sendingClusterManagementMessage = new SimpleCounterStatistic("sent cluster mgmt", this.align);
        this.receivingClusterManagementMessage = new SimpleCounterStatistic("recv cluster mgmt", this.align);
        this.droppedInternalMessages = new SimpleCounterStatistic(DROPPED_INTERNAL_UDP_MESSAGES, this.align);
        this.init();
    }

    private void init() {
        this.add(this.forwardedMessage);
        this.add(this.processedForwardedMessage);
        this.add(this.badForwardMessage);
        this.add(this.dropForwardMessage);
        this.add(this.backwardedMessage);
        this.add(this.sendBackwardedMessage);
        this.add(this.badBackwardMessage);
        this.add(this.dropBackwardMessage);
        this.add(this.sendingClusterManagementMessage);
        this.add(this.receivingClusterManagementMessage);
        this.add(this.droppedInternalMessages);
    }

    @Override
    protected boolean isUsed() {
        return super.isUsed() || this.forwardedMessage.isUsed() || this.dropForwardMessage.isUsed() || this.badForwardMessage.isUsed();
    }

    @Override
    protected void dump(String head, StringBuilder log) {
        String eol = StringUtil.lineSeparator();
        log.append(eol);
        log.append(head).append(this.forwardedMessage).append(eol);
        log.append(head).append(this.processedForwardedMessage).append(eol);
        log.append(head).append(this.badForwardMessage).append(eol);
        log.append(head).append(this.dropForwardMessage).append(eol);
        log.append(head).append(this.backwardedMessage).append(eol);
        log.append(head).append(this.sendBackwardedMessage).append(eol);
        log.append(head).append(this.badBackwardMessage).append(eol);
        log.append(head).append(this.dropBackwardMessage).append(eol);
        log.append(head).append(this.sendingClusterManagementMessage).append(eol);
        log.append(head).append(this.receivingClusterManagementMessage);
        if (this.droppedInternalMessages.isStarted()) {
            log.append(eol).append(head).append(this.droppedInternalMessages);
        }
    }

    @Override
    public void forwardMessage() {
        this.forwardedMessage.increment();
    }

    @Override
    public void backwardMessage() {
        this.backwardedMessage.increment();
    }

    @Override
    public void processForwardedMessage() {
        this.processedForwardedMessage.increment();
    }

    @Override
    public void sendBackwardedMessage() {
        this.sendBackwardedMessage.increment();
    }

    @Override
    public void dropForwardMessage() {
        this.dropForwardMessage.increment();
    }

    @Override
    public void dropBackwardMessage() {
        this.dropBackwardMessage.increment();
    }

    @Override
    public void badForwardMessage() {
        this.badForwardMessage.increment();
    }

    @Override
    public void badBackwardMessage() {
        this.badBackwardMessage.increment();
    }

    @Override
    public void sendingClusterManagementMessage() {
        this.sendingClusterManagementMessage.increment();
    }

    @Override
    public void receivingClusterManagementMessage() {
        this.receivingClusterManagementMessage.increment();
    }
}

