/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.auth;

import java.security.GeneralSecurityException;
import java.security.Principal;
import org.eclipse.californium.elements.auth.PreSharedKeyIdentity;
import org.eclipse.californium.elements.auth.RawPublicKeyIdentity;
import org.eclipse.californium.elements.auth.X509CertPath;
import org.eclipse.californium.elements.util.Asn1DerDecoder;
import org.eclipse.californium.elements.util.DataStreamReader;
import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.elements.util.SerializationUtil;

public final class PrincipalSerializer {
    private static final int PSK_HOSTNAME_LENGTH_BITS = 16;
    private static final int PSK_IDENTITY_LENGTH_BITS = 16;

    private PrincipalSerializer() {
    }

    public static void serialize(Principal principal, DatagramWriter writer) {
        if (writer == null) {
            throw new NullPointerException("Writer must not be null");
        }
        if (principal == null) {
            writer.writeByte(ClientAuthenticationType.ANONYMOUS.code);
        } else if (principal instanceof PreSharedKeyIdentity) {
            PrincipalSerializer.serializeIdentity((PreSharedKeyIdentity)principal, writer);
        } else if (principal instanceof RawPublicKeyIdentity) {
            PrincipalSerializer.serializeSubjectInfo((RawPublicKeyIdentity)principal, writer);
        } else if (principal instanceof X509CertPath) {
            PrincipalSerializer.serializeCertChain((X509CertPath)principal, writer);
        } else {
            throw new IllegalArgumentException("unsupported principal type: " + principal.getClass().getName());
        }
    }

    private static void serializeIdentity(PreSharedKeyIdentity principal, DatagramWriter writer) {
        writer.writeByte(ClientAuthenticationType.PSK.code);
        if (principal.isScopedIdentity()) {
            writer.writeByte((byte)1);
            SerializationUtil.write((DatagramWriter)writer, (String)principal.getVirtualHost(), (int)16);
            SerializationUtil.write((DatagramWriter)writer, (String)principal.getIdentity(), (int)16);
        } else {
            writer.writeByte((byte)0);
            SerializationUtil.write((DatagramWriter)writer, (String)principal.getIdentity(), (int)16);
        }
    }

    private static void serializeSubjectInfo(RawPublicKeyIdentity principal, DatagramWriter writer) {
        writer.writeByte(ClientAuthenticationType.RPK.code);
        writer.writeBytes(principal.getSubjectInfo());
    }

    private static void serializeCertChain(X509CertPath principal, DatagramWriter writer) {
        writer.writeByte(ClientAuthenticationType.CERT.code);
        writer.writeBytes(principal.toByteArray());
    }

    public static Principal deserialize(DatagramReader reader) throws GeneralSecurityException {
        if (reader == null) {
            throw new NullPointerException("reader must not be null");
        }
        byte code = reader.readNextByte();
        ClientAuthenticationType type = ClientAuthenticationType.fromCode(code);
        switch (type) {
            case CERT: {
                return PrincipalSerializer.deserializeCertChain(reader);
            }
            case PSK: {
                return PrincipalSerializer.deserializeIdentity(reader);
            }
            case RPK: {
                return PrincipalSerializer.deserializeSubjectInfo(reader);
            }
        }
        return null;
    }

    private static X509CertPath deserializeCertChain(DatagramReader reader) {
        byte[] certificatePath = Asn1DerDecoder.readSequenceEntity((DatagramReader)reader);
        return X509CertPath.fromBytes((byte[])certificatePath);
    }

    private static PreSharedKeyIdentity deserializeIdentity(DatagramReader reader) {
        byte scoped = reader.readNextByte();
        if (scoped == 1) {
            String virtualHost = SerializationUtil.readString((DataStreamReader)reader, (int)16);
            String pskIdentity = SerializationUtil.readString((DataStreamReader)reader, (int)16);
            return new PreSharedKeyIdentity(virtualHost, pskIdentity);
        }
        String pskIdentity = SerializationUtil.readString((DataStreamReader)reader, (int)16);
        return new PreSharedKeyIdentity(pskIdentity);
    }

    private static RawPublicKeyIdentity deserializeSubjectInfo(DatagramReader reader) throws GeneralSecurityException {
        byte[] subjectInfo = Asn1DerDecoder.readSequenceEntity((DatagramReader)reader);
        return new RawPublicKeyIdentity(subjectInfo);
    }

    private static enum ClientAuthenticationType {
        ANONYMOUS(0),
        CERT(1),
        PSK(2),
        RPK(-1);

        private byte code;

        private ClientAuthenticationType(byte code) {
            this.code = code;
        }

        static ClientAuthenticationType fromCode(byte code) {
            for (ClientAuthenticationType type : ClientAuthenticationType.values()) {
                if (type.code != code) continue;
                return type;
            }
            throw new IllegalArgumentException("unknown ClientAuthenticationType: " + code);
        }
    }
}

