/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls.cipher;

import java.security.GeneralSecurityException;
import java.security.Signature;
import org.eclipse.californium.elements.util.Asn1DerDecoder;
import org.eclipse.californium.scandium.dtls.cipher.ThreadLocalCrypto;
import org.eclipse.californium.scandium.dtls.cipher.ThreadLocalCryptoMap;

public class ThreadLocalSignature
extends ThreadLocalCrypto<Signature> {
    public static final ThreadLocalCryptoMap<ThreadLocalSignature> SIGNATURES = new ThreadLocalCryptoMap<ThreadLocalSignature>(new ThreadLocalCryptoMap.Factory<ThreadLocalSignature>(){

        @Override
        public ThreadLocalSignature getInstance(String algorithm) {
            return new ThreadLocalSignature(algorithm);
        }
    });

    public ThreadLocalSignature(final String algorithm) {
        super(new ThreadLocalCrypto.Factory<Signature>(){

            @Override
            public Signature getInstance() throws GeneralSecurityException {
                String standardAlgorithm = Asn1DerDecoder.getEdDsaStandardAlgorithmName((String)algorithm, (String)algorithm);
                return Signature.getInstance(standardAlgorithm);
            }
        });
    }
}

